#include <stdint.h>
#include "inc/tm4c123gh6pm.h"
#include <stdio.h>
#include <stdlib.h>
#include "schedule.h"


uint8_t current_task = 1;
uint32_t g_tick_count = 0;
uint8_t current_task_index = 1;
uint8_t current_priority = MAX_PRIORITY;


__attribute__((naked)) void init_sched_stack(uint32_t sched_stack_top){
    __asm volatile ("MSR MSP, %0": : "r" (sched_stack_top) : );
    __asm volatile ("BX LR");
}


void init_tasks_stack() {

    for (int i = 0; i < MAX_TASKS; i++) {
        if (user_tasks[i].task_handler != NULL) {
            uint32_t* psp = (uint32_t*) user_tasks[i].psp_value;
            psp--;
            *psp = DUMMY_XPSR;

            psp--;
            *psp = (uint32_t) user_tasks[i].task_handler;

            psp--;
            *psp = 0xFFFFFFFD;

            for (int j = 0; j < 13; j++) {
                psp--;
                *psp = 0;
            }
            user_tasks[i].psp_value = (uint32_t) psp;
        }
    }
}



__attribute__((naked)) void pendsv_Handler(){

    /*save the context of current task*/
            //1.get current running task PSP value.
            __asm volatile("MRS R0, PSP");
           //2.using that PSP value store Stack frame(R4 to R11).
           __asm volatile("STMDB R0!,{R4-R11}");
            __asm volatile("PUSH {LR}");
            //3.save the current value of PSP.
            __asm volatile ("BL save_psp_value");


            /*save the context of the next task*/
            //1.decide next task to run.
            __asm volatile("BL update_next_task");
            //2.get its past PSP value.
            __asm volatile("BL get_psp_value");
            //3.using that PSP value retrieve R4 to R11.
            __asm volatile("LDMIA R0!, {R4-R11}");
            //__asm volatile("POP {LR}");
            //4.update PSP and exit.
            __asm volatile("MSR PSP, R0");
            __asm volatile("POP {LR}");

            __asm volatile("BX LR");
}

void update_global_tick_count(void){
    g_tick_count++;
}


void unblock_tasks(void){
    for(int i=1; i< MAX_TASKS;i++)
    {
        if(user_tasks[i].current_state == TASK_BLOCKED_STATE)
        {
            user_tasks[i].block_count = user_tasks[i].block_count - 1;
        }
        if(user_tasks[i].block_count == 0 && user_tasks[i].current_state == TASK_BLOCKED_STATE )
        {
            user_tasks[i].current_state = TASK_READY_STATE;
        }
    }
}

uint32_t get_psp_value(void){
    return user_tasks[current_task].psp_value;
}


void save_psp_value(uint32_t current_psp_value)
{
    user_tasks[current_task].psp_value = current_psp_value;
}


void update_next_task(void)
{
    int next_task_index = current_task;
       uint8_t lowest_priority = 255; // Initialize with the lowest priority value

       // Find the task with the highest priority
       for (int i = 1; i < MAX_TASKS; i++) { // Start from index 1 to skip the idle task
           if (user_tasks[i].current_state == TASK_READY_STATE &&
                       user_tasks[i].priority > 0 && // Ignore idle task
                       user_tasks[i].priority < lowest_priority) {
                       lowest_priority = user_tasks[i].priority;
                       next_task_index = i;
           }
       }

       current_task = next_task_index;

}

__attribute__((naked)) void switch_sp_psp(void){

    //1.initialize the PSP with task1 stack start address

    //get the current task psp value
    __asm volatile ("PUSH {LR}");  //preserve LR which connects back to main
    __asm volatile ("BL get_psp_value");
    __asm volatile("MSR PSP, R0");  //initialize PSP value
    __asm volatile("POP {LR}");  //pops back LR value

    //change sp to psp using control register
    __asm volatile ("MOV R0, #0x02");
    __asm volatile("MSR CONTROL, R0");
    __asm volatile("BX LR");
}

void schedule(void)
{
    uint32_t *pICSR = (uint32_t *) 0xE000ED04;
    *pICSR |= (1<<28);

}

void task_delay(uint32_t tick_count){

    if(current_task)
    {
        //user_tasks[current_task].block_count = g_tick_count + tick_count;
        user_tasks[current_task].block_count = tick_count;
        user_tasks[current_task].current_state = TASK_BLOCKED_STATE;
        schedule();
    }
}

void create_task(void (*task_handler)(void), uint32_t priority) {
        // Find a free slot for the new task
        for (int i = 0; i < MAX_TASKS; i++) {
            if (user_tasks[i].task_handler == NULL) {
                user_tasks[i].psp_value = SRAM_END_ADDRESS - i * STACK_TASK_SIZE;
                user_tasks[i].block_count = 0;
                user_tasks[i].current_state = TASK_READY_STATE;
                user_tasks[i].priority = priority;
                user_tasks[i].task_handler = task_handler;
                return;
           }
     }

}

// Function to delete a task with a given priority
void delete_task(void (*task_handler)(void), uint32_t priority) {
    // Delete task with given priority
    // Find the task with the given priority and delete it
        for (int i = 0; i < MAX_TASKS; i++) {
            if (user_tasks[i].task_handler == task_handler && user_tasks[i].priority == priority) {
                user_tasks[i].task_handler = NULL;
                user_tasks[i].priority = 0;
                user_tasks[i].current_state = TASK_READY_STATE;
                // Optionally, reset other task fields as needed
                break;
            }
        }
}


void launchScheduler(void)
{
    uint8_t lowest_priority = 255; // Initialize with the lowest priority value

    // Find the task with the highest priority
    for (int i = 1; i < MAX_TASKS; i++)
    {
        // Start from index 1 to skip the idle task
        if (user_tasks[i].current_state == TASK_READY_STATE && user_tasks[i].priority > 0 && user_tasks[i].priority <= lowest_priority)
        {
            lowest_priority = user_tasks[i].priority;
            //next_task_index = i;
            current_task = user_tasks[i].task_handler;
        }
    }
}
