#include <stdint.h>
#include "inc/tm4c123gh6pm.h"
#include <stdio.h>
#include <stdlib.h>
#include "schedule.h"
#include "systick.h"



int main(){

    SYSCTL_RCGC2_R |= 0x00000020; /* enable clock to GPIOF at clock gating control register */



    GPIO_PORTF_LOCK_R = 0x4C4F434B; /* unlock commit register */
    GPIO_PORTF_CR_R = 0x01; /* make PORTF0 configurable */
    GPIO_PORTF_DIR_R = 0x0E; /* enable the GPIO pins for the LED (PF3, 21) as output */
    GPIO_PORTF_DEN_R = 0x1F; /* enable the GPIO pins for digital function*/
    GPIO_PORTF_PUR_R = 0x11; /* enable pull up for pin 4 */


    /*stack to store kernel related registers*/
    init_sched_stack(SCHED_STACK_START);


    /*user tasks with given priority*/
    create_task(idletask, 50); // Idle task with lowest priority
    create_task(task1_handler, 3);
    create_task(task2_handler, 1);
    create_task(task3_handler, 5);
    //create_task(task4_handler, 4);



    /*initialization of stacks*/
    init_tasks_stack();


    /*initializing systick timer*/
    init_systick_timer(TICK_HZ);


    /*switching stack pointer from MSP to PSP*/
    switch_sp_psp();


    /*launching scheduler*/
    launchScheduler();



     for(;;);
    return 0;
}

void task1_handler(){
    while(1){
        GPIO_PORTF_DATA_R = 0x08; // turn on  LED //green
        task_delay(250);
        GPIO_PORTF_DATA_R = 0x00; // turn off LED
        task_delay(250);
    }
}

void task2_handler() {
    while (1) {
        GPIO_PORTF_DATA_R = 0x04; // Turn on LED//blue
        task_delay(250);
        GPIO_PORTF_DATA_R = 0x00; // Turn off LED
        task_delay(250);
    }
}


void task3_handler(){
    while(1){
        GPIO_PORTF_DATA_R = 0x02; // turn on LED //red
        task_delay(250);
        GPIO_PORTF_DATA_R = 0x00; // turn off LED
        task_delay(250);
    }
}

void task4_handler(){
    while(1){
        GPIO_PORTF_DATA_R = 0x0E; // turn on LED //white
        task_delay(250);
        GPIO_PORTF_DATA_R = 0x00; // turn off LED
        task_delay(250);
    }
}

void idletask()
{
    while(1){
        GPIO_PORTF_DATA_R = 0x0D; // turn on LED //cyan
        task_delay(1000);
        GPIO_PORTF_DATA_R = 0x00; // turn off LED
        task_delay(1000);
    }
}

void delaycustom(int n)
{
    int i, j;
    for(i = 0 ; i < n; i++)
    {
        for(j = 0; j < 3180; j++)
        {
        }
    }
}









