//Transmitter

#include <stdbool.h>
#include <stdint.h>
#include <string.h>
#include <math.h>

#include "inc/tm4c123gh6pm.h"
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "inc/hw_can.h"
#include "inc/hw_ints.h"
#include "driverlib/can.h"
#include "driverlib/interrupt.h"
#include "driverlib/sysctl.h"
#include "driverlib/gpio.h"
#include "driverlib/uart.h"
#include "driverlib/pin_map.h"
#include "uartstdio.h"
#include <time.h>

void EnableInterrupts(void);
void DisableInterrupts(void);

#define PI 3.14159265359f

volatile bool rxFlag = 0; // msg recieved flag
volatile bool errFlag = 0; // transmission error flag
unsigned int sysClock; // clockspeed in hz
int msgsendflag = 0;
unsigned int count = 0,countH = 0; // loop counter
unsigned int countsync = 0,countHsync = 0; // sync counter
int sendcount;
int time1 = 0, time2 = 0,time3 = 0,time4 = 0;
int random_num;
int onewaytime,twowaytime;
int datavalid = 0;
int timeout = 2000;
int synlimit = 1000;
int countHlimit = 117;
int countHsynclimit = 117;
int nextdelay = 2000;     //in ms
int switchstatus = 0;
char val = 0;

void delay(unsigned int milliseconds)
{
    int i, j;
    for(i = 0 ; i < milliseconds; i++){
        if (UARTCharsAvail(UART1_BASE))
                {
            val = UARTCharGet(UART1_BASE);
                }
        for(j = 0; j < 3180; j++) {}   /* do nothing for 1 ms */
    }

}


// CAN interrupt handler
void CANIntHandler(void) {

    unsigned long status = CANIntStatus(CAN0_BASE, CAN_INT_STS_CAUSE); // read interrupt status

    if(status == CAN_INT_INTID_STATUS) { // controller status interrupt
        status = CANStatusGet(CAN0_BASE, CAN_STS_CONTROL);
        errFlag = 1;
    } else if(status == 1) { // msg object 1
        CANIntClear(CAN0_BASE, 1); // clear interrupt

        errFlag = 0; // clear any error flags
    }
    else if(status == 2) { // msg object 1
            CANIntClear(CAN0_BASE, 2); // clear interrupt

            rxFlag = 1;
            errFlag = 0; // clear any error flags
        }
    else { // should never happen
    //    UARTprintf("Unexpected CAN bus interrupt\n");
    }
}

int main(void) {

    srand(time(NULL));
    tCANMsgObject msgTx; // the CAN message object
    unsigned int msgDataTx; // the message data is four bytes long which we can allocate as an int32
    unsigned char *msgDataPtrTx = (unsigned char *)&msgDataTx; // make a pointer to msgData so we can access individual bytes

    tCANMsgObject msgRx; // the CAN msg object
    unsigned char msgDataRx[8]; // 4 byte buffer for rx message data

    // Run from crystal at 50Mhz
    SysCtlClockSet(SYSCTL_SYSDIV_4 | SYSCTL_USE_PLL | SYSCTL_XTAL_16MHZ | SYSCTL_OSC_MAIN);

    // Set up debugging UART
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_UART0);
    GPIOPinConfigure(GPIO_PA0_U0RX);
    GPIOPinConfigure(GPIO_PA1_U0TX);
    GPIOPinTypeUART(GPIO_PORTA_BASE, GPIO_PIN_0 | GPIO_PIN_1);
    UARTStdioConfig(0, 115200, SysCtlClockGet());

    // Set up CAN0
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOE);
    GPIOPinConfigure(GPIO_PE4_CAN0RX);
    GPIOPinConfigure(GPIO_PE5_CAN0TX);
    GPIOPinTypeCAN(GPIO_PORTE_BASE, GPIO_PIN_4 | GPIO_PIN_5);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_CAN0);
    CANInit(CAN0_BASE);
    CANBitRateSet(CAN0_BASE, SysCtlClockGet(), 500000);
    CANIntRegister(CAN0_BASE, CANIntHandler); // use dynamic vector table allocation
    CANIntEnable(CAN0_BASE, CAN_INT_MASTER | CAN_INT_ERROR | CAN_INT_STATUS);
    IntEnable(INT_CAN0);
    CANEnable(CAN0_BASE);

    // Set up bluetooth UART
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOC);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_UART1);
    GPIOPinConfigure(GPIO_PC4_U1RX);
    GPIOPinConfigure(GPIO_PC5_U1TX);
    GPIOPinTypeUART(GPIO_PORTC_BASE, GPIO_PIN_4 | GPIO_PIN_5);
    UARTConfigSetExpClk(UART1_BASE, SysCtlClockGet(), 9600,(UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE));

    //Set up Switch Interrupt
    SYSCTL_RCGC2_R |= 0x00000020;
    GPIO_PORTF_LOCK_R = 0x4C4F434B; /* unlock commit register */
    GPIO_PORTF_CR_R = 0x01;

    GPIO_PORTF_DIR_R = 0x0E;
    GPIO_PORTF_DEN_R = 0x1F;
    GPIO_PORTF_PUR_R = 0x11; /* enable pull up for pin 4 */

    GPIO_PORTF_IS_R &= ~0x11;       /*  PF is edge-sensitive */
    GPIO_PORTF_IBE_R &= ~0x11;      /*  PF is not both edges */
    GPIO_PORTF_IEV_R &= ~0x11;      /*  PF falling edge event */
    GPIO_PORTF_ICR_R = 0x11;        /*  Clear flag */
    GPIO_PORTF_IM_R |= 0x11;        /*  arm interrupt on PF */
    NVIC_PRI7_R = (NVIC_PRI7_R & 0xFF1FFFFF) | 0x00A00000; /*  priority 5 for Port F*/
    NVIC_EN0_R = 0x40000000;        /*  Enable interrupt 30 in NVIC */

    //Setting Systick interrupt
    EnableInterrupts();
    NVIC_ST_RELOAD_R = 500000;           //Load timer value
    NVIC_ST_CTRL_R = 7;                 //Enable SYSTICK interrupt
    NVIC_SYS_PRI3_R = (NVIC_SYS_PRI3_R & 0x0FFFFFFF) | 0x20000000; /*  priority 1 for SYSTICK*/



    // Set up msg object
    msgDataTx = 0;
    msgTx.ui32MsgID = 0;
    msgTx.ui32MsgIDMask = 0;
    msgTx.ui32Flags = MSG_OBJ_TX_INT_ENABLE;
    msgTx.ui32MsgLen = sizeof(msgDataPtrTx);
    msgTx.pui8MsgData = msgDataPtrTx;

    // Use ID and mask 0 to recieved messages with any CAN ID
    msgRx.ui32MsgID = 1;
    msgRx.ui32MsgIDMask = 0;
    msgRx.ui32Flags = MSG_OBJ_RX_INT_ENABLE | MSG_OBJ_USE_ID_FILTER;
    msgRx.ui32MsgLen = 8; // allow up to 8 bytes


    char uartin = 0;   // input from laptop GUI
    char gui_val[10]="";
    int onewayble = 10, twowayble = 10;
    int sendonewayble = 0,sendtwowayble = 128;
    int receivedswitch = 1;

    int start = 0;     //0 - Stop, 1 - Start
    int level = 2;     //0 - Beginner, 1 - Amateur, 2 - Professional
    int mode = 0;      //0 - Full, 1 - Top, 2 - Right, 3 - Bottom, 4 - Left, 5 - Diagonal1, 6 - Diagonal2

    while(1) {

     //Receive UART from bluetooth
        if (UARTCharsAvail(UART1_BASE))
                {
            val = UARTCharGet(UART1_BASE);
                }

        if (val == 1){
            start = 1;
        }
        else if(val == 2){
            start = 0;
        }
        else if(val == 11){
              level = 0;
               }
        else if(val == 12){
            level = 1;
               }
        else if(val == 13){
             level = 2;
             }
        else if(val == 21){
          mode = 0;
          }
        else if(val == 22){
                  mode = 5;
                  }

        else if(val == 23){
                  mode = 6;
                  }

        else if(val == 24){
                  mode = 1;
                  }

        else if(val == 25){
                  mode = 3;
                  }

        else if(val == 26){
                  mode = 4;
                  }
        else if(val == 27){
                  mode = 2;
        }

        // Receive uart for GUI

        if (UARTCharsAvail(UART0_BASE))
            {
                uartin = UARTCharGet(UART0_BASE);
                 if (uartin == '\n')
                {
                     memset(gui_val,'\0',sizeof(gui_val));

                }
                else
                {
                    strncat(gui_val, &uartin,1);
                }
            }

       // UARTprintf("Array values :%d\t%d\t%d\n",gui_val[0],gui_val[1],gui_val[2]);

       // UARTprintf("Received values start,level,mode :%d\t%d\t%d\n",start,level,mode);

        if (!strcmp(gui_val, "1") ){
            start = 1;
        }
        else if(!strcmp(gui_val, "2")){
            start = 0;
        }
        else if(!strcmp(gui_val, "31")){
              level = 0;
               }
        else if(!strcmp(gui_val, "32")){
            level = 1;
               }
        else if(!strcmp(gui_val, "33")){
             level = 2;
             }
        else if(!strcmp(gui_val, "41")){
        mode = 0;
        }
      else if(!strcmp(gui_val, "42")){
                mode = 5;
                }

      else if(!strcmp(gui_val, "43")){
                mode = 6;
                }

      else if(!strcmp(gui_val, "44")){
                mode = 1;
                }

      else if(!strcmp(gui_val, "45")){
                mode = 3;
                }

      else if(!strcmp(gui_val, "46")){
                mode = 4;
                }
      else if(!strcmp(gui_val, "47"))
      {
          mode = 2;
      }



        if (level == 2){
            nextdelay = 2000;
        }
        else if (level == 1){
            nextdelay = 4000;
        }
        if (level == 0){
                   nextdelay = 6000;
               }


        if (start == 0){
            GPIO_PORTF_DATA_R &= ~0x04;
        }


        if (msgsendflag == 0 && start == 1){

   ///     random_num = (rand() % 4) + 1;
        //     random_num = 2;
         //   random_num = (rand() % 2 == 0) ? 3 : 4;

//                       if (mode == 0){
//                           random_num = 3;
//                       }
//                       else if (mode == 1){
//                         random_num = 4;
//                     }
//                       else if (mode == 2){
//                           random_num = (rand() % 2 == 0) ? 3 : 4;
//                                            }

                     // random_num = (rand() % 2 == 0) ? 3 : 4;

          //  random_num = 4;

           if (mode == 0){
               random_num = (rand() % 3) + 1;
           }
           else if (mode == 1){
             random_num = (rand() % 2) + 1;
         }
           else if (mode == 2){
              random_num = (rand() % 2 == 0) ? 2 : 3;
              }
           else if (mode == 3){
              random_num = (rand() % 2 == 0) ? 3 : 4;
              }
           else if (mode == 4){
              random_num = (rand() % 2 == 0) ? 1 : 4;
              }
           else if (mode == 5){
              random_num = (rand() % 2 == 0) ? 1 : 3;
              }
           else if (mode == 6){
              random_num = (rand() % 2 == 0) ? 2 : 4;
              }


           if ((countHsync*255 + countsync) > synlimit){
           msgDataPtrTx[0] = 0;
           msgDataPtrTx[1] = count;
           msgDataPtrTx[2] = countH;
           msgDataPtrTx[3] = random_num;
           }
           else{
               count = 0;
               countH = 0;
               msgDataPtrTx[0] = 0;
               msgDataPtrTx[1] = 0;
               msgDataPtrTx[2] = 0;
               msgDataPtrTx[3] = 5;
           }
           receivedswitch = 0;

        //  UARTprintf("Send Data \t %d\t %d\t  %d\t  %d\n", msgDataPtrTx[0], msgDataPtrTx[1], msgDataPtrTx[2], msgDataPtrTx[3]); // write colour to UART for debugging
           CANMessageSet(CAN0_BASE, 1, &msgTx, MSG_OBJ_TYPE_TX); // send as msg object 1
           sendcount = countH*255 + count;
           if(errFlag) { // check for errors
            //         UARTprintf("CAN Bus Error  :%d\n",errFlag);
                 }

           delay(100);
           msgsendflag = 1;
           CANMessageSet(CAN0_BASE, 2, &msgRx, MSG_OBJ_TYPE_RX);

           datavalid = 0;
        }


        while((rxFlag==0  && start == 1) && (((countH*255 + count)-sendcount) < timeout)){
            if (UARTCharsAvail(UART1_BASE))
                    {
                val = UARTCharGet(UART1_BASE);
             //   UARTprintf("%d\n",val);
                    }

            if (UARTCharsAvail(UART0_BASE))
                {
                    uartin = UARTCharGet(UART0_BASE);
                     if (uartin == '\n')
                    {
                         gui_val[0] = '\0';

                    }
                    else
                    {
                        strncat(gui_val, &uartin,1);
                    }
                }
        }

        if (((countH*255 + count)-sendcount) < timeout){
            datavalid = 1;
        }
        else{
            datavalid = 0;
            rxFlag = 0;
          //  UARTprintf("CAN time out\n");
            msgsendflag = 0;
        }

        if (rxFlag == 1 && datavalid == 1 && start == 1){

            msgRx.pui8MsgData = msgDataRx; // set pointer to rx buffer
            CANMessageGet(CAN0_BASE, 2, &msgRx, 0); // read CAN message object 1 from CAN peripheral

            rxFlag = 0;

            if(msgRx.ui32Flags & MSG_OBJ_DATA_LOST) { // check msg flags for any lost messages
           //      UARTprintf("CAN message loss detected\n");
             }
         //   UARTprintf("Received \t %d\t %d\t %d\t %d\n", msgDataRx[0],msgDataRx[1],msgDataRx[2],msgDataRx[3]);


            if ((msgDataRx[0] == random_num) && (msgDataRx[3] == 0) && receivedswitch == 0){

               // UARTprintf("My data \t %d\t %d\t %d\t %d\n", msgDataRx[0],msgDataRx[1],msgDataRx[2],msgDataRx[3]);
                onewaytime = (msgDataRx[2]*255 + msgDataRx[1]) - sendcount;

                GPIO_PORTF_DATA_R |= 0x04;
                while((switchstatus==0) && (((countH*255 + count)-sendcount) < timeout)){
                    if (UARTCharsAvail(UART0_BASE))
                        {
                            uartin = UARTCharGet(UART0_BASE);
                             if (uartin == '\n')
                            {
                                 memset(gui_val,'\0',sizeof(gui_val));

                            }
                            else
                            {
                                strncat(gui_val, &uartin,1);
                            }
                        }
                }
                GPIO_PORTF_DATA_R &= ~0x04;
                receivedswitch = 1;
                twowaytime = (countH*255 + count) - sendcount;
                if (twowaytime < onewaytime){
                    onewaytime = twowaytime/2 + 1;
                }


               if (onewaytime > 0 && twowaytime >0){

                   sendonewayble = 0.128*(onewaytime-10);
                   sendtwowayble = 0.12828*(twowaytime) + 126.717;
                  // sendtwowayble = 0.12828*(onewaytime) + 126.717;

                   UARTCharPut(UART1_BASE,sendonewayble);
                   UARTCharPut(UART1_BASE,sendtwowayble);

              //     UARTprintf("Status\t %d\t %d\t %d\t %d\t %d\n", count,countH,onewaytime,twowaytime,random_num);
               }

               UARTprintf("%d,%d,%d,%d,%d\n", count,countH,onewaytime,twowaytime,random_num);
            }

            msgsendflag = 0;
            switchstatus = 0;

        }

        switchstatus = 0;
        if (start == 1){
            delay(nextdelay);
        }


     //   UARTprintf("GUI values :%d\t%d\t%d\n",start,level,mode);

//        UARTCharPut(UART1_BASE,75);
//        UARTCharPut(UART1_BASE,150);

    }

    return 0;
}

void SysTick_Handler(void)
{
    if (count < 255){
        count++;
    }
    else{
        count = 0;
        if (countH < countHlimit){
            countH = countH + 1;
        }
        else{
            countH = 0;
        }
    }


    if (countsync < 250){
        countsync++;
    }
    else{
        countsync = 0;
        if (countHsync < countHsynclimit){
            countHsync = countHsync + 1;
        }
        else{
            countHsync = 0;
        }
    }


}

void GPIOPortF_Handler(void)
{
    GPIO_PORTF_ICR_R |= 0x11;

    if (msgsendflag == 1){
        switchstatus = 1;
    }


}

/* global enable interrupts */
void inline EnableInterrupts(void)
{
    __asm  ("    CPSIE  I\n");
}

void DisableInterrupts(void)
{
    __asm ("    CPSID  I\n");
}
