/*
 * gpio.c
 *
 *  Created on: 31-May-2020
 *      Author: J. Shankarappa
 */

#include <stdint.h>
#include "inc/tm4c123gh6pm.h"

/**
 * Set up user LED and provide function for toggling it. This is for
 * use by the test programs
 */
void setup_led(void)
{
    volatile unsigned long delay;

    /* Initialize the GPIOs and Timers that drive the three LEDs. */
    SYSCTL_RCGC2_R |= 0x00000020;     /* activate clock for Port F */
    delay = SYSCTL_RCGC2_R;           /* allow time for clock to start */
    delay = delay;

    /* enable the GPIO pins for the LED (PF3, 2, 1) as output */
    GPIO_PORTF_DIR_R |= 0x0E;
    /* enable the GPIO pins for digital function */
    GPIO_PORTF_DEN_R |= 0x0E;
}

void toggle_led(uint8_t color)
{
    GPIO_PORTF_DATA_R ^= color;         /* toggle LED */
}

