#include <stdint.h>
#include <stdbool.h>
#include <./inc/tm4c123gh6pm.h>
#include <inc/hw_memmap.h>
#include <inc/hw_types.h>
#include <driverlib/gpio.h>
#include <driverlib/pin_map.h>
#include <driverlib/sysctl.h>
#include <driverlib/uart.h>
#include <string.h>
#include <stdlib.h>
#define BUFFER_SIZE 25
char BUFFER[BUFFER_SIZE];

void UART0_init(void);
void SysTickDelay(int);
void PORTF1_init(void);

int main(void){
  char val;
  unsigned int i, value;
  int command_flag;
  i = 0;
  UART0_init();
  PORTF1_init();
  int on_time=0;
  int off_time=0;
  GPIO_PORTF_DATA_R &= ~(0x02);
  int start=0;
  while(1){
    if (UARTCharsAvail(UART0_BASE)){
      val = UARTCharGet(UART0_BASE);
      UARTCharPut(UART0_BASE, val);
      if (val != 0x0D && i < BUFFER_SIZE){
        BUFFER[i] = val;
        i++;
        command_flag=0;
      }
      else{
        BUFFER[i] = '\0';
        i = 0;
        UARTCharPut(UART0_BASE, 0x0A);
        command_flag=1;
      }
    }
    char command[30];
    sscanf(BUFFER, "%s %d", command, &value);
    if(command_flag==1){
      if (strcmp(command, "on_time")==0){
        on_time = value;
      }
      else if (strcmp(command, "off_time")==0){
        off_time = value;
      }
      else if (strcmp(BUFFER, "start")==0){
          start=1;
      }
      else if (strcmp(BUFFER, "stop")==0){
          start=0;
          on_time=0;
          off_time=0;
      }
      else if (strcmp(BUFFER, "pause")==0){
          start=0;
      }
    }
    if((command_flag==1) && (start==1) && (on_time)){
      GPIO_PORTF_DATA_R |= 0x02;
      SysTickDelay(on_time);
      GPIO_PORTF_DATA_R &= ~(0x02);
      SysTickDelay(off_time);
    }
  }
}

void SysTickDelay(int delayus){
  while(delayus){
    NVIC_ST_CTRL_R = 0; /* disable SysTick during setup */
    NVIC_ST_RELOAD_R = 16-1; /* Reload Value goes here */
    NVIC_ST_CTRL_R |= 0x5; /* enable SysTick with core clock */
    while( (NVIC_ST_CTRL_R & (1<<16) ) == 0); /* Monitoring bit 16 to be set */
    NVIC_ST_CTRL_R = 0; /* Disabling SysTick Timer */
    delayus--;
  }
}

void PORTF1_init(void){
  SYSCTL_RCGC2_R = SYSCTL_RCGC2_GPIOF;
  GPIO_PORTF_DIR_R |= 0x02;
  GPIO_PORTF_DEN_R |= 0x02;
  GPIO_PORTF_AFSEL_R |= 0x00;
  GPIO_PORTF_DATA_R |= 0x02;
}

void UART0_init(void){
    SYSCTL_RCGC2_R |= 0x00000020;
    GPIO_PORTF_LOCK_R |= 0x4C4F434B;
    GPIO_PORTF_CR_R |= 0x11;
    GPIO_PORTF_DIR_R |= 0x0E;
    GPIO_PORTF_DEN_R |= 0x1F;
    GPIO_PORTF_PUR_R |= 0x11;
    SysCtlPeripheralEnable(SYSCTL_PERIPH_UART0);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);
    GPIOPinConfigure(GPIO_PA0_U0RX);
    GPIOPinConfigure(GPIO_PA1_U0TX);
    GPIOPinTypeUART(GPIO_PORTA_BASE, GPIO_PIN_0 | GPIO_PIN_1);
    UARTConfigSetExpClk(UART0_BASE, SysCtlClockGet(), 115200,(UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE));
}
