/*
 * can_api.h
 *
 *  Created on: 04-May-2023
 *      Author: jainv
 */

#ifndef CAN_API_H_
#define CAN_API_H_

//*****************************************************************************
//
// Message Identifiers and Objects
// RXID is set to 0 so all messages are received
//
//*****************************************************************************
#define CAN0RXID                0
#define RXOBJECT                1
#define CAN0TXID                2
#define TXOBJECT                2


extern uint32_t g_ui32RXMsgCount;
extern uint32_t g_ui32TXMsgCount;
extern bool g_bRXFlag;
extern uint32_t g_ui32ErrFlag;
extern tCANMsgObject g_sCAN0RxMessage;
extern tCANMsgObject g_sCAN0TxMessage;
extern uint8_t g_ui8TXMsgData;
extern uint8_t g_ui8RXMsgData;

void InitCAN0(void);
void CAN0IntHandler(void);
void CANErrorHandler(void);


#endif /* CAN_API_H_ */
