//*****************************************************************************
//
// can.c - Simple CAN example.
//
// Copyright (c) 2013-2017 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
// 
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
// 
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
// 
// This is part of revision 2.1.4.178 of the DK-TM4C123G Firmware Package.
//
//*****************************************************************************

#include <stdint.h>
#include <stdbool.h>
#include "inc/hw_can.h"
#include "inc/hw_ints.h"
#include "inc/hw_memmap.h"
#include "driverlib/fpu.h"
#include "driverlib/can.h"
#include "driverlib/gpio.h"
#include "driverlib/pin_map.h"
#include "driverlib/rom.h"
#include "driverlib/sysctl.h"
#include "driverlib/uart.h"
#include "utils/uartstdio.h"
#include "driverlib/interrupt.h"

#include "uart_api.h"
#include "can_api.h"

//*****************************************************************************
// Set up the system, initialize the UART and CAN.
//*****************************************************************************

void init_sys()
{
    ROM_FPULazyStackingEnable();
    ROM_SysCtlClockSet(SYSCTL_SYSDIV_4 | SYSCTL_USE_PLL | SYSCTL_XTAL_16MHZ | SYSCTL_OSC_MAIN);
    ConfigureUART();
    InitCAN0();
}

//*****************************************************************************
// Then poll the UART for data. If there is any data send it, if there is any
// thing received print it out to the UART. If there are errors call the error
// handling function.
//*****************************************************************************

void poll_uart()
{
    if(g_bRXFlag)
            {
                g_sCAN0RxMessage.pui8MsgData = (uint8_t *) &g_ui8RXMsgData;
                CANMessageGet(CAN0_BASE, RXOBJECT, &g_sCAN0RxMessage, 0);
                g_bRXFlag = 0;
                if(g_sCAN0RxMessage.ui32Flags & MSG_OBJ_DATA_LOST)
                {
                    UARTprintf("\nCAN message loss detected\n");
                }
            }
            else
            {
                if(g_ui32ErrFlag != 0)
                {
                    CANErrorHandler();
                }
                while(ROM_UARTCharsAvail(UART0_BASE))
                {
                    g_ui8TXMsgData = ROM_UARTCharGetNonBlocking(UART0_BASE);
                    CANMessageSet(CAN0_BASE, TXOBJECT, &g_sCAN0TxMessage, MSG_OBJ_TYPE_TX);
                }
            }
}

int main(void)
{
    init_sys();
    UARTprintf("\nCAN Transmitter\n");
    UARTprintf("Type characters to send over CAN\n\n");

    while(1)
    {
        poll_uart();
    }
}
