
import tkinter
from tkinter import *
import tkinter.ttk as ttk
import tkinter.filedialog as filedialog
#import tkFileDialog as filedialog
import math

import threading
import time
import os
import serial

serial_data = ''
serial_object = None
connection_status = 0

def delay_us(t):
    t = t * 1e-6
    time.sleep(t)
    #print "delay over"
    return

# NO    COMMANDS
# 1     send the app size
# 2     send the code
# 3     close the connection
# 4     send next chunk

def browsefile():
    global filepath
    global file
    global app_size
    global app_size_chunks
    global app_size_string
    global length
    filepath = filedialog.askopenfilename(filetypes = (("Template files", "*.type"), ("All files", "*")))
    # TODO - calculate file size and store it in global var
    file_stats = os.stat(filepath)
    app_size = file_stats.st_size
    print ("application size =",app_size)
    app_size_chunks = math.ceil(app_size / 32)
    print ("application chunksize=",app_size_chunks)
    app_size_chunks = int(app_size_chunks)
    print ("application chunksize=",app_size_chunks)
    app_size_string, length = size_as_string(app_size_chunks)
    print(length)
    print ("application chunksizehex=",app_size_string)
    file = open(filepath,"rb")
    print (filepath)
    return

def connect():
    # get the os name - windows or linux
    global connection_status
    global serial_object

    os_name = button_var.get()
    port    = port_entry.get()
    baud    = baud_entry.get()
    print ("OS -", os_name)

    try:
        if os_name == 2:
            serial_object = serial.Serial('/dev/tty' + str(port), baud)
        elif os_name == 1:
            serial_object = serial.Serial('COM' + str(port), baud)
        connection_status = 1
        print ("Device connection successfull.")
        delay_us(100)
        receive_command()
    except ValueError:
        print ("Enter Baud and Port")
    return

def receive_command():
    print ("receive_command function::")
    while connection_status == 1:
        recvd_comm = read_command()
        state_type(recvd_comm)
    return
def read_command():
    print ("reading command:")
    #print("Reading data:::")
    #recvd_comm= input()
    recvd_comm = serial_object.read(1).decode()
    print ("command=",recvd_comm)
    return recvd_comm

def state_type(recvd_comm):
    if recvd_comm == '1':
        print("in if 1")
        send_size()
    elif recvd_comm == '2':
        print("in if 2")
        send_app()
    elif recvd_comm == '3':
        print("in if 3")
        close_conn()
    else:
        print("else")
        close_conn()
    return

def send_size():
    print ("sending application size...")
    count = 0
    while count < 4:
        if count< length:
           delay_us(100)
           asize = (app_size_string[length-count-1])
           print ("asize=",asize)
           serial_object.write(asize.encode())
           count += 1
           print(count)
        else:
           delay_us(100)
           print("asize=", 0)
           serial_object.write('0'.encode('utf-8'))
           count += 1



    return


def size_as_string(app_size):
    size1 = hex(app_size).split('x')[-1]
    #print(size1)

    bytes_object = bytes(size1, "utf-8")
    ascii_string = bytes_object.decode("ASCII")
    #print ascii_string
    length = len(ascii_string)
    return ascii_string, length





def send_app_img():
    print ("sending application image...")
    sent_chunks = 0
    chunk_sent = 0
    chunk_size = 32
    #byte_count = 0

    while sent_chunks < app_size_chunks:
        byte_count = 0
        while byte_count < chunk_size:
            byte = file.read(1)
            if len(byte) != 0:
                delay_us(100)
                serial_object.write(byte)
            else:
                delay_us(100)
                byte = b'255';
                serial_object.write(byte)
            byte_count+=1

        #if sent_chunks != (app_size_chunks-1):
        recvd_comm = read_command()
            #recvd_comm = read_command()
        #else:
           # recvd_comm = '4'

        if recvd_comm == '4':
            chunk_sent = 1
            print ("chunk",sent_chunks,"sent")
        else:
            chunk_sent = 0
            print ("error in sending chunk",sent_chunks)
            break
        sent_chunks+=1
    return chunk_sent


def send_app():
    success = send_app_img()
    if success == 1:
        print ("application image sent successfully.")
    else:
        print ("error occurred in sending application image.")
        close_conn()
        disconnect()
    return

def close_conn():
    global connection_status
    print ("closing connection...")
    try:
        serial_object.close()
        connection_status = 0
    except AttributeError:
        print ("closed without Using it -_-")
    return


def disconnect():
    close_conn()
    print ("closing application...")
    gui.quit()
    return



# create gui object
gui = Tk()
gui.title("UART Configuration")
filename = ""

linebreak = 30
line = 0

if __name__ == "__main__":

    #frames
    #frame_1 = Frame(height = 285, width = 480, bd = 3, relief = 'groove').place(x = 7, y = 5)
    frame_2 = Frame(height = 480, width = 480, bd = 3, relief = 'groove').place(x = 7, y = 5)
    text = Text(width = 65, height = 5)

    # tool name at the top
    contact = Label(text = "UART INTERFACE").place(x = 150, y = line)
    line += linebreak
    line += linebreak
    #insert file browse option
    browsefile = Button(text = "BROWSE (.bin file)", command = browsefile).place(x = 20, y = line)
    file_path_entry = Entry(width = 30, text = filename)
    file_path_entry.place(x = 150, y = line)

    line += linebreak
    line += linebreak
    line += linebreak
    # label place -- port
    port   = Label(text = "PORT(COM)").place(x = 40, y = line)
    port_entry = Entry(width = 10)
    port_entry.place(x = 150, y = line)

    line += linebreak
    line += linebreak

    # label place -- baud rate
    baud   = Label(text = "BAUD RATE").place(x =40, y = line)
    # data entry for baud rate and port
    baud_entry = Entry(width = 10)
    baud_entry.place(x = 150, y = line)

    line += linebreak
    line += linebreak
    line += linebreak
    #radio button
    button_var = IntVar()
    radio_1 = Radiobutton(text = "Windows", variable = button_var, value = 1).place(x = 20, y = line)
    radio_2 = Radiobutton(text = "Linux", variable = button_var, value = 2).place(x = 150, y = line)

    line += linebreak
    line += linebreak
    line += linebreak
    # connect and disconnect buttons
    connect = Button(text = "CONNECT", command = connect).place(x = 20, y = line)
    disconnect = Button(text = "DISCONNECT", command = disconnect).place(x =250, y = line)

    #mainloop
    gui.geometry('500x500')
    gui.configure(bg = "black")
    gui.mainloop()



