/***uart.c***/
#include <stdint.h>
#include <stdlib.h>
#include "inc/tm4c123gh6pm.h"

#include "uart.h"
#include  <bl_interrupt.h>

void UART_INIT(int rx_int_en)
{

    SYSCTL_RCGCUART_R |= 1;          //Enabling clock and function for UART0
    SYSCTL_RCGCGPIO_R |=1;           //Enabling clock at PA0-PA1
    UART0_CTL_R |= 0;                //disable UART0 en pin only incase of error
    UART0_IBRD_R = 8;
    UART0_FBRD_R = 44;
    UART0_CC_R = 0;                   //Select the system clock as UART clock source by writing a 0 to UARTCC register of UART0.
    UART0_LCRH_R = 0x60;
    UART0_CTL_R = 0x301;

    if(rx_int_en)                     // uart0 recieve with interrupt
        EN_UART_INTR_HANDLER();       //enable_uart_interrupt_handler

    GPIO_PORTA_DEN_R |= 0x3;
    GPIO_PORTA_AFSEL_R |= 0x3;
    GPIO_PORTA_PCTL_R = ((GPIO_PORTA_PCTL_R & 0xFFFFFF00) + 0x11);
    GPIO_PORTA_AMSEL_R = 0x3;

}

void EN_UART_INTR_HANDLER()                     //enable_uart_interrupt_handler
{

    UART0_IM_R |= 0x10;                         // Set UART interrupt mask to handle only RX
    NVIC_PRI1_R = (NVIC_PRI1_R & 0xFFFF1FFF) | 0x0000A000; // Set interrupt priority & enable the same for UART0/*  priority 5 */
    NVIC_EN0_R |= 0x00000020;                   /*  Enable interrupt 5 in NVIC */
    INTR_EN();                                  /* Enable global Interrupt flag (I) */
    return ;
}


void UART_SND(uint8_t one_byte)
{
    while((UART0_FR_R & 0x20)!=0);  //checking for bit field 5 to check that
    UART0_DR_R = one_byte;          //any previous transmission has completed or not
}

void UART_SND_STR(unsigned char *temp)
{
    while(*temp!=0)
    {
        UART_SND(*temp);
        temp++;
    }
    UART_SND('\n');
}

unsigned char UART_RCV(void)
{
  while((UART0_FR_R & 0x10) != 0);
    return(UART0_DR_R&0xFF);
}

void UART_RCV_STR(unsigned char * temp)
{
    *temp = UART_RCV();
    while(*temp != "\0")
    {
        temp++;
        *temp = UART_RCV();
    }
}

void UART_DIS()                  // to disable UART interrupt
{
    NVIC_EN0_R &= ~0x00000020;   /*  Disable interrupt 5 in NVIC */
    UART0_CTL_R = 0;             // Disable UART0
    SYSCTL_RCGCGPIO_R &= ~0x01;  // Disable clock to PORTA
}
