/***systick_delay.c***/
#include <stdio.h>
#include <stdint.h>
#include "inc/tm4c123gh6pm.h"

#include "systick_delay.h"




#define CLK (16*1000000)
uint32_t T;

void SYSTICK_INIT(unsigned int T_DELAY)
{
    NVIC_ST_CTRL_R &= (1<<0);                         // disable the systick while configuring
    NVIC_ST_RELOAD_R = (CLK * T_DELAY * 0.001) - 1;   // value to be reloaded to generate delay (milli second)//-4;
    NVIC_ST_CURRENT_R = 0x00;                         // clear the current reg to clear the count flag in control reg
    NVIC_ST_CTRL_R |= 0x07;                           // set clk source(bit 2) and trigger the timer(bit 0)
    NVIC_SYS_PRI3_R = (NVIC_SYS_PRI3_R & 0x00FFFFFF) | 0xE0000000; // priority 7 lowest   // enable
}

void SYSTICK_HANDLER(void)
{
    T++;
}

void SYSTICK_DISABLE(void)
{
    NVIC_ST_CTRL_R = 0x00;                          //// disable the systick
}


