/***main.c***/

#include <stdio.h>
#include "inc/tm4c123gh6pm.h"
#include <inttypes.h>

#include   "bl_interrupt.h"
#include  "bootloader_library.h"
#include   "uart.h"
#include  "bl_memory_map.h"

#define  SW1            (GPIO_PORTF_DATA_R&(1<<4))
#define APPLICATION_START       (0x00010000)
#define BLUE_LED_ON     (GPIO_PORTF_DATA_R|=(1<<2))
#define RED_LED_ON      (GPIO_PORTF_DATA_R|=(1<<1))
#define GREEN_LED_ON    (GPIO_PORTF_DATA_R|=(1<<3))
#define BLUE_LED_OFF    (GPIO_PORTF_DATA_R&=(~(1<<2)))
#define RED_LED_OFF     (GPIO_PORTF_DATA_R&=(~(1<<1)))
#define GREEN_LED_OFF   (GPIO_PORTF_DATA_R&=(~(1<<3)))


#define APPLICATION_STARTING_ADDRESS  ((uint32_t)0x00020000)                       // the reserved for the application 192K Bytes

int main(void)
{
    printf("Bootloader program \n");
    uint32_t start_address;

    INIT();
    INIT_LED();



    if(!SW1)                                        // check for BOOTPIN
    {
        INTR_DIS();                                 // disable interupts and receive the image
        BLUE_LED_ON;

        UART_INIT(0);                                // indicate via led
                                                    // function to receive application image
        IMG_RCV();
        // wait for reset
    }
    //printf("Bootloader program \n");
    {                                                //else
                                                     // switch press karun thev done
        // check the flash address
        // if not 0xFF, then start app
        GREEN_LED_ON;

    }
    while(1);

    return 0;
}
