/***bootloader_library.c***/
#define TARGET_IS_TM4C123_RB2
#include <stdio.h>
#include <stdint.h>
#include <stdbool.h>
#include <string.h>
#include <stdlib.h>
#include "uart.h"

#include "bootloader_library.h"
#include "bl_interrupt.h"
#include "systick_delay.h"
#include "inc/tm4c123gh6pm.h"
#include "driverlib/rom.h"

#define RED_LED_ON      (GPIO_PORTF_DATA_R|=(1<<1))

#define APPLICATION_START      0x00020000

#define  APPLICATION_STARTING_ADDRESS  ((uint32_t)0x00020000)       //reserving application space of 128K Bytes

void INIT()
{
    BOOT_UPDATE();

}

void BOOT_UPDATE()
{                                                                // enable clock
    SYSCTL_RCGC2_R |= 0x00000020;             // configure a pin for boot update
                                              // PORT F PIN 0 ==> SW2 on board
    GPIO_PORTF_DIR_R = (GPIO_PORTF_DIR_R & 0xFFFFFFFE);      // direction enable
    GPIO_PORTF_DEN_R = (GPIO_PORTF_DEN_R & 0xFFFFFFFE) | 0x01;  //digital enable
}

void INIT_LED() /* Configure Port F for accessing the LEDs */
{
    SYSCTL_RCGC2_R |= 0x00000020;     // enable clock
    GPIO_PORTF_LOCK_R = 0x4C4F434B; /* 2) unlock GPIO Port F */
    GPIO_PORTF_CR_R = 0x1F; /* allow changes to PF4-0 */
    GPIO_PORTF_AMSEL_R = 0x00; /* 3) disable analog on PF */
    GPIO_PORTF_PCTL_R = 0x00000000; /* 4) PCTL GPIO on PF4-0 */

    GPIO_PORTF_DIR_R = 0x0E;          //direction enable
    GPIO_PORTF_DEN_R = 0x1F;          //digital enable
}

void DELAY(int n)
{
    int i, j;
    for (i = 0; i < n; i++)
        for (j = 0; j < 6360; j++)
        {
        } /* do nothing for 2 ms */
}

void IMG_RCV()                                  //receive_img()
{
    int appsize;
    int status;

    UART_SND('1');                               //application size
    appsize = RCV_SIZE();

    status = APP_RCV(appsize);                   // to receive application image

    if (status == -1)
    {
        while (1)
        {
        }
    }
    else
    {
        UART_SND('3');                  // closing the uart connection
        DELAY(100);
        UART_DIS();
    }
    return;
}
int RCV_SIZE()
{
    uint8_t BYTES[4];
    int array[4];

    BYTES[3] = UART_RCV(); // sending the application size LSB
    BYTES[2] = UART_RCV();
    BYTES[1] = UART_RCV();
    BYTES[0] = UART_RCV(); // sending the application size MSB

    int size = (int) strtol(BYTES, NULL, 16);
    return size;
}

int APP_RCV(int chunks)
{
    int recvd_chunks = 0;
    int bytecount;
    int chunksize = 32;
    int status = 0;
    uint8_t recvd_byte[32];
    uint32_t dest_address = APPLICATION_START;

    UART_SND('2');        // from uart interface start sending application image
    //DELAY(100);
    while (recvd_chunks < chunks)
    {
        status = -1;
        bytecount = 0;

        while (bytecount < chunksize)
        {
            recvd_byte[bytecount] = UART_RCV();

            bytecount++;

        }

        UART_SND('4');
        status = ROM_FlashProgram((uint32_t) recvd_byte, dest_address,
                                  chunksize);  // write this data to flash

        printf("status is: %d \n", status);
        if (status == -1)
        {

            break;   // error while writing the application to flash
        }

        dest_address += 0x20;              //increment addres
        recvd_chunks++;                    //incrementing the chunk number

    }
    return status;
}

