#include <stdint.h>
#include "inc/tm4c123gh6pm.h"

/* It is always best practice to define some macros for the signals*/

//#define  SW1        (GPIO_PORTF_DATA_R&(1<<4))
//#define  SW2        (GPIO_PORTF_DATA_R&(1<<0))
#define  LED_RED    (GPIO_PORTF_DATA_R=0x02)
#define  LED_BLUE   (GPIO_PORTF_DATA_R=0x04)
#define  LED_GREEN  (GPIO_PORTF_DATA_R=0x08)
#define  LED_WHITE  (GPIO_PORTF_DATA_R=0x0E)
#define  LED_DARK   (GPIO_PORTF_DATA_R=0x00)
#define  LED_YELLOW (GPIO_PORTF_DATA_R=0x0A)
#define  LED_SKYBLUE (GPIO_PORTF_DATA_R=0x0C)

void Init_PortF(void);

/* This function initializes the Switches and led connected to PortF */
void Init_PortF(void)
{
    volatile unsigned long delay;

    SYSCTL_RCGC2_R |= 0x00000020;     /* 1) activate clock for Port F */
    delay = SYSCTL_RCGC2_R;           /* allow time for clock to start */

    GPIO_PORTF_LOCK_R = 0x4C4F434B;   /* 2) unlock GPIO Port F */
    GPIO_PORTF_CR_R = 0x1F;           /* allow changes to PF4-0 */
    GPIO_PORTF_AMSEL_R = 0x00;        /* 3) disable analog on PF */
    GPIO_PORTF_PCTL_R = 0x00000000;   /* 4) PCTL GPIO on PF4-0 */
    GPIO_PORTF_DIR_R = 0x0E;          /* 5) PF4,PF0 in, PF3-1 out */
    GPIO_PORTF_AFSEL_R = 0x00;        /* 6) disable alt funct on PF7-0 */
    GPIO_PORTF_PUR_R = 0x11;          /* enable pull-up on PF0 and PF4 */ //always 1
    GPIO_PORTF_DEN_R = 0x1F;          /* 7) enable digital I/O on PF4-0 */
 }


int main()
{

    Init_PortF();                     /* Initializing port F */
    unsigned int SW1,SW2;

    while( 1 ) {
        SW1=GPIO_PORTF_DATA_R&(1<<4);
        SW2=GPIO_PORTF_DATA_R&(1<<0);
        if( (!SW1) && (SW2) ) {       /* when switch 1 pressed */
        LED_GREEN;                     /* Green led */
    } else if( (SW1) && (!SW2) ) {    /* when switch 2 pressed */
        LED_RED;                    /* blue led */
    } else if( (!SW1) && (!SW2) ) {   /* when both switches pressed simultaneously */
        LED_BLUE;                    /* red led */
    } else
        LED_WHITE;                      /* none of them pressed then red led */
    }
}
