#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>
#include <string.h>
#include <ctype.h>
#include "inc/tm4c123gh6pm.h"
#include "driverlib/gpio.h"
#include "driverlib/pin_map.h"
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "driverlib/sysctl.h"
#include "driverlib/i2c.h"
#include <driverlib/pin_map.h>
#include <driverlib/sysctl.h>
#include <driverlib/uart.h>
#include <string.h>
#include <math.h>
char a[] = {0x3F, 0x06, 0x5B, 0x4F, 0x66, 0x6D, 0x7D, 0x07, 0x7F, 0x6F};
char b[] = {0xBf,0x86,0xDB,0xCF,0xE6,0xED,0xFD,0x87,0xFF,0xEF};
char display[]={0x10,0x20,0x40,0x80};
int time = 0;
int ultra_distance = 0;
float SF_ultrasound = 0.5;

void HC_SR04_setup(void);
void send_trigger_pulse(void);
unsigned int calculate_distance(void);
void UART0_setup(void)
{
    SYSCTL_RCGCUART_R |= 0x01; // Enable UART0
    SYSCTL_RCGCGPIO_R |= 0x01; // Enable corresponding GPIO port (PORTA)
    // Set GPIO AFSEL bits
    // xxx... PA7 PA6 PA5 PA4 PA3 PA2 PA1 PA0
    //                                Tx  Rx
    GPIO_PORTA_AFSEL_R = 0x03;
    // PCTL is 32 bit register, 4 bits are used to select alternate functions of each GPIO pin
    GPIO_PORTA_PCTL_R = 0x00000011;
    GPIO_PORTA_DEN_R |= 0x03; // GPIO digital enable for PA0, PA1
    // clk = 16 MHz
    // Desired baud rate = clk / (16 * clk_div)
    // UARTIBRD and UARTFBRD
    // If Desired baud rate = XXX.YYY
    // then UARTIBRD = XXX and UARTFBRD = (0.YYY * 64) + 0.5
    // baud_rate = 115200
    UART0_IBRD_R = 8;
    UART0_FBRD_R = 44;
    // 0x60 for 8 data bits, 1 stop, 1 start
    UART0_LCRH_R = 0x60;
    UART0_CC_R = 0x0;
    UART0_CTL_R = 0x0301;
    GPIO_PORTA_AMSEL_R = 0;

    // Interrupt setup for UART0
//    UART0_IM_R |= 0x10;       // enable interrupt mask for receive
//    UART0_ICR_R = (0x010);    // clear interrupt if any
//    NVIC_PRI1_R |= 0x00006000;// priority = 3
//    NVIC_EN0_R |= 0x00000020; // enable interrupt for UART0 (IRQ number = 5)
}

void UART0_Transmit(char data)
{
    while((UART0_FR_R & (1<<5)) != 0)
    {
        // wait until Tx buffer full
    }
    UART0_DR_R = data; // send the byte
}

int time_value1 = 0;
int time_value2 = 1;

//LCD
#define CLEAR_DISPLAY     0x01
#define RETURNHOME        0x02
#define MOVECURSORRIGHT   0x06
#define MOVECURSORLIFT    0x08
#define SHIFTDISPLAYRIGHT 0x1C
#define SHIFTDISPLAYLEFT  0x18
#define CURSORBLINK       0x0F
#define CURSOROFF         0x0C
#define CURSORON          0x0E
#define FUNCTION_SET_4BIT 0x28
#define FUNCTION_SET_8BIT 0x38
#define ENTRY_MODE        0x06
#define FUNCTION_8_BIT    0x32
#define SET5X7FONTSIZE    0x20
#define FIRSTROW          0x80
#define SECONDROW         0xC0

#define RS                0x40
#define EN                0x80

#define FALSE 0


void delayMs(int n);
void LCD_init(void);
void LCD_String(char *str);
void LCD_Cmd(unsigned char command);
void delay_us(int n);
void initialize_ports(void);
void LCD_Write_Char(unsigned char data);
void EnableInterrupts(void);

volatile uint8_t rx_data;
int x=4400;
void enable_irq(void);
int adc_value=20;
int debounce=0;
int temp1;

void DisableInterrupts(void);
void EnableInterrupts(void);
void WaitForInterrupt(void);
void GPIOPortF_Init(void);
void GPIOPortF_Handler(void);
void GPIOPortE_Handler(void);
void GPIOPortC_Handler(void);

// Initial statuses
int door_status=0;
int obstruction_status=0;
int engine_status=0;
unsigned int acceleration=0;
int seatbelt_status=0;
char str1[32];
char gear='N';
unsigned int motor_speed=0;
int control_variable=0;

int ult_distance;

void SysTick_Wait(uint32_t delay)
{
      NVIC_ST_CTRL_R = 0;            /* (1) disable SysTick during setup */
      NVIC_ST_RELOAD_R = (15999*2*delay)-1;    /* (2) number of counts to wait */
      NVIC_ST_CURRENT_R = 0;         /* (3) any value written to CURRENT clears */
      NVIC_ST_CTRL_R |= 0x5;         /* (4) enable SysTick with core clock */

      while((NVIC_ST_CTRL_R&0x00010000)==0)
      {
         ;                          /* wait for COUNT flag */
      }
 }
void delay_us(int n)
{
    int i,j;
    for(i=0;i<n;i++)
        for(j=0;j<2;j++)
        {}
}

int belt = 0;      //0 - Safety belt OFF (PE0 & PC5), 1 - Safety belt ON (PE0 & PC4)

void GPIO_Key_Mat_Init(void)
{

    SYSCTL_RCGC2_R |= 0x00000014;     /* enable clock to GPIOE-C at clock gating control register */
    GPIO_PORTE_DIR_R |= 0x01;        /* 5) PF4,PF0 in, PF3-1 out */
    GPIO_PORTE_ODR_R |= 0x01;        /* enable pull-up on PF0 and PF4 */
    GPIO_PORTE_DEN_R |= 0x01;        /* 7) enable digital I/O on PF4-0 */
    GPIO_PORTC_DIR_R &= ~0xF0;        /* 5) PF4,PF0 in, PF3-1 out */
    GPIO_PORTC_PUR_R |= 0xF0;        /* enable pull-up on PF0 and PF4 */
    GPIO_PORTC_DEN_R |= 0xF0;        /* 7) enable digital I/O on PF4-0 */
    GPIO_PORTC_IS_R &= ~0xF0;       /*  PF4 and PF0 is edge-sensitive */
    GPIO_PORTC_IBE_R &= ~0xF0;      /*  PF4 and PF0 is not both edges */
    GPIO_PORTC_IEV_R &= ~0xF0;      /*  PF4 and PF0 falling edge event */
    GPIO_PORTC_ICR_R = 0xF0;        /*  Clear flag4 */
    GPIO_PORTC_IM_R |= 0xF0;        /*  arm interrupt on PF4 */
    NVIC_PRI0_R = (NVIC_PRI0_R & 0xFF1FFFFF) | 0x00C00000; /*  priority 5 */
    NVIC_EN0_R = 0x40000004;        /*  Enable interrupt 30 in NVIC */
    EnableInterrupts();             /* Enable global Interrupt flag (I) */
}

void adc_sample()
{
    ADC0_PSSI_R |= 8;
     while((ADC0_RIS_R & 8) == 0)  ;
                       acceleration = ADC0_SSFIFO3_R;
                       ADC0_ISC_R = 8;
   if(0< acceleration && 100>acceleration)
    {
       gear='R';
    }

   if(100< acceleration && 315>acceleration)
   {
       gear='N';
   }
   else if(315< acceleration && 1035>acceleration)
   {
       gear='1';
   }
   else if(1035< acceleration && 1460>acceleration)
   {
       gear='2';
   }
   else if(1460< acceleration && 2100>acceleration)
   {
       gear='3';
   }
   else if(2100< acceleration && 2830>acceleration)
   {
       gear='4';
    }
   else if(acceleration>2830)
   {
       gear='5';
   }
}

void LCD_Status_update()
{
  //  LCD_Cmd(0x01);    // clear LCD
   //GPIO_PORTA_DATA_R |= EN;        // GENERATE STROBE TO LATCH DATA this causes 7 segment to flicker
    LCD_Cmd(FIRSTROW);
    LCD_String("D:0 B:0");
    LCD_Cmd(FIRSTROW +8);
    LCD_String("E:0 G:");
    LCD_Cmd(FIRSTROW  +14);
    LCD_Write_Char(gear);
        if(engine_status==0)
        {
            LCD_Cmd(FIRSTROW +10);
           // delayMs(1);
            LCD_Write_Char('0');
       }
        else{
            LCD_Cmd(FIRSTROW +10);
           // delayMs(1);
            LCD_Write_Char('1');
        }
       if(door_status==0)
        {
           LCD_Cmd(FIRSTROW +2);
          // delayMs(1);
           LCD_Write_Char('0');
        }
       else
       {
           LCD_Cmd(FIRSTROW +2);
          // delayMs(1);
           LCD_Write_Char('1');
       }
       if(belt==0)
        {
           LCD_Cmd(FIRSTROW +6);
          // delayMs(1);
           LCD_Write_Char('0');
        }
       else
       {
           LCD_Cmd(FIRSTROW +6);
          // delayMs(1);
           LCD_Write_Char('1');
       }
}
void adc_initialise()
{
    /* enable clocks */
                                    SYSCTL_RCGCGPIO_R |= 0x30; /* enable clock to PE (AIN0 is on PE3) */
                                    SYSCTL_RCGCADC_R |= 1;     /* enable clock to ADC0 */
                                    /* initialize PE3 for AIN0 input  */
                                    GPIO_PORTE_AFSEL_R |= 8;   /* enable alternate function */
                                    GPIO_PORTE_DEN_R &= ~8;    /* disable digital function */
                                    GPIO_PORTE_AMSEL_R |= 8;   /* enable analog function */
                                   /* initialize ADC0 */
                                    ADC0_ACTSS_R &= ~8;        /* disable SS3 during configuration */
                                    ADC0_EMUX_R &= ~0xF000;    /* software trigger conversion */
                                    ADC0_SSMUX3_R = 0;         /* get input from channel 0 */
                                    ADC0_SSCTL3_R |= 6;        /* take one sample at a time, set flag at 1st sample */
                                    ADC0_ACTSS_R |= 8;         /* enable ADC0 sequencer 3 */
}
void pwm_initialise()
{
    /* Enable Peripheral Clocks */
       SYSCTL_RCGCPWM_R |= 2;       /* enable clock to PWM1 */
       SYSCTL_RCGCGPIO_R |= 0x10;   /* enable clock to PORTE */
       SYSCTL_RCC_R |= 0x100000; /* no pre-divide for PWM clock */
       SYSCTL_RCC_R |= 0x080000; /* no pre-divide for PWM clock */
       /* Enable port PF3 for PWM1 M1PWM7 */
       GPIO_PORTE_AFSEL_R = 0x20;      /* E port  uses alternate function */
       GPIO_PORTE_PCTL_R &= ~0x00F00000; /* make GPIO pin 5 is controlled */
       GPIO_PORTE_PCTL_R |= 0x00500000;
       GPIO_PORTE_DEN_R |= 0x20;       /* pin digital */
       PWM1_1_CTL_R = 0;            /* stop counter */
       PWM1_1_GENB_R = 0x0000008C;  /* M1PWM7 output set when reload, */
       /* clear when match PWMCMPA */
       PWM1_1_LOAD_R = 5000;       /* set load value for 1kHz (16MHz/16000) */
       PWM1_1_CMPA_R = 4999;       /* set duty cycle to min */
       PWM1_1_CTL_R = 1;            /* start timer */
       PWM1_ENABLE_R = 0x08;        /* start PWM1 ch7 */
}
int ch = 4;
void status()
{
    if(engine_status==0)
           {
               GPIO_PORTF_DATA_R =0x0;
               error_message(3);
           }
           if(engine_status==1 && belt==0 && door_status==0 )
           {
               error_message(0);
               GPIO_PORTF_DATA_R =0x02;
               GPIO_PORTA_DATA_R ^=0x04;

           }
           if(engine_status==1 && belt==0 && door_status==1 )
             {
                 error_message(1);
                 GPIO_PORTF_DATA_R =0x02;
                 GPIO_PORTA_DATA_R ^=0x04;

             }
           if(engine_status==1 && belt==1 && door_status==0 )
             {
                 error_message(2);
                 GPIO_PORTF_DATA_R ^=0x02;
                 GPIO_PORTA_DATA_R ^=0x04;

             }
           if(engine_status==1 && belt==1 && door_status==1 )
                   {
                       error_message(3);
                      // GPIO_PORTF_DATA_R ^=0x02;
                   }

}
void error_message(int n)
{if(n==0)
{
    LCD_Cmd(SECONDROW);
    LCD_String(" D & B Alarm ");

}
else if(n==1)
{        LCD_Cmd(SECONDROW);
    LCD_String("  B Alarm    ");
}
else if(n==2)
{        LCD_Cmd(SECONDROW);
    LCD_String("  D Alarm    ");
}
else if(n==3)
{
    LCD_Cmd(SECONDROW);
           LCD_String("             ");
           GPIO_PORTF_DATA_R =0x00;
           GPIO_PORTA_DATA_R &=~0x04;
}
 }


int main(void)
{
        EnableInterrupts();
        pwm_initialise();

        SYSCTL_RCGC2_R |= 0x00000023; /* enable clock to GPIOF */
        GPIO_PORTF_PUR_R = 0x11; /* enable pull up for pin 4 and pin 0 */
        GPIO_PORTF_LOCK_R = 0x4C4F434B; /* unlock commit register */
        GPIO_PORTF_CR_R = 0x01; /* make PORTF0 configurable */
        GPIO_PORTF_DIR_R = 0x0E; /* set PORTF1 and PortF3 pin as output (LED) pin */
               /* and PORTF0 as input, SW2 is on PORTF0 */
        GPIO_PORTF_DEN_R = 0x1F; /* set PORTF pins 1,0,4,3 as digital pins */
        char buffer[32] = {0}; // Initialize buffer with zeros
        // Port B settings
           GPIO_PORTB_AMSEL_R = 0x00;
           GPIO_PORTB_PCTL_R = 0x00;
           GPIO_PORTB_DIR_R = 0xFF;
           GPIO_PORTB_AFSEL_R = 0x00;
           GPIO_PORTB_DEN_R = 0xFF;
         // Port A settings
           GPIO_PORTA_AMSEL_R = 0x00;
           GPIO_PORTA_PCTL_R = 0x00;
           GPIO_PORTA_DIR_R = 0xFF;
           GPIO_PORTA_AFSEL_R = 0x00;
           GPIO_PORTA_DEN_R = 0xFF;
         // Port E1 for Person detection
           SYSCTL_RCGC2_R |= 0x0000010; // Enable the clock for Port E
         // Wait for the clock to stabilize
         // Set Port E pin 1 as input
                      GPIO_PORTE_DIR_R &= ~(0x02);
                      // Enable digital functionality on Port E pin 2 for motor direction
                      GPIO_PORTE_DEN_R |= (0x02);
                      GPIO_PORTE_DIR_R &= ~(0x02); // make PE5 as PWM output
                      GPIO_PORTE_DIR_R |= (0x10); // set E4 as output
                      GPIO_PORTE_DEN_R |= (0x10);  //enable digital function
          // enable Port D0 for motor direction control
                      SYSCTL_RCGC2_R |= 0x0000008; // Enable the clock for Port D
                      GPIO_PORTD_DIR_R |= (0x01); // set D1 as output
                      GPIO_PORTD_DEN_R |= (0x01);  //enable digital function
                      GPIO_PORTA_DIR_R |= (0x04); // set D3 as output
                      GPIO_PORTA_DEN_R |= (0x04);  //enable digital function
           /* enable clocks */
                                SYSCTL_RCGCGPIO_R |= 0x30; /* enable clock to PE (AIN0 is on PE3) */
                                SYSCTL_RCGCADC_R |= 1;     /* enable clock to ADC0 */
                                /* initialize PE3 for AIN0 input  */
                                GPIO_PORTE_AFSEL_R |= 8;   /* enable alternate function */
                                GPIO_PORTE_DEN_R &= ~8;    /* disable digital function */
                                GPIO_PORTE_AMSEL_R |= 8;   /* enable analog function */
                                /* initialize ADC0 */
                                ADC0_ACTSS_R &= ~8;        /* disable SS3 during configuration */
                                ADC0_EMUX_R &= ~0xF000;    /* software trigger conversion */
                                ADC0_SSMUX3_R = 0;         /* get input from channel 0 */
                                ADC0_SSCTL3_R |= 6;        /* take one sample at a time, set flag at 1st sample */
                                ADC0_ACTSS_R |= 8;         /* enable ADC0 sequencer 3 */
                                char str[10]; // make sure the string is large enough to hold the converted integer
           GPIO_PORTF_IS_R &= ~0x11;       /*  PF is edge-sensitive */
           GPIO_PORTF_IBE_R &= ~0x11;      /*  PF is not both edges */
            GPIO_PORTF_IEV_R &= ~0x11;      /*  PF falling edge event */
           GPIO_PORTF_ICR_R = 0x11;        /*  Clear flag */
           GPIO_PORTF_IM_R |= 0x11;        /*  arm interrupt on PF */
           NVIC_PRI7_R = (NVIC_PRI7_R & 0xFF1FFFFF) | 0x00A00000; /*  priority 5 for Port F*/
           NVIC_EN0_R = 0x40000000;        /*  Enable interrupt 30 in NVIC */
           NVIC_ST_RELOAD_R = 64000;           //Load timer value
            NVIC_ST_CTRL_R = 7;                 //Enable SYSTICK interrupt
          NVIC_SYS_PRI3_R = (NVIC_SYS_PRI3_R & 0x0FFFFFFF) | 0x20000000; /*  priority 1 for SYSTICK*/
           EnableInterrupts();                  /* global enable interrupt */
           GPIO_Key_Mat_Init();               /* initialize GPIO Port C interrupt */
           LCD_init();
           LCD_Cmd(0x01);    // clear LCD
             LCD_Cmd(FIRSTROW);
             LCD_String("D:0 B:0");
             LCD_Cmd(FIRSTROW +8);
             LCD_String("E:0 G:");
             //engine_status = 0;
             UART0_setup();
                     HC_SR04_setup();
                     unsigned int distance = 0;
    while(1)
    {

        send_trigger_pulse();

        delayMs(100);
        distance = calculate_distance();
        UART0_Transmit(48+((distance/100000)));
        UART0_Transmit(48+((distance%100000)/10000));
        UART0_Transmit(48+((distance%10000)/1000));
        UART0_Transmit(48+((distance%1000)/100));
        UART0_Transmit(48+((distance%100)/10));
        UART0_Transmit(48+(distance%10));
        UART0_Transmit(' ');

        SysTick_Wait(0.5);
        LCD_Status_update();
        adc_sample();
        status();
        //error_message(ch);
        if(engine_status==1 && distance <50 && gear == 'R' )
        {
            GPIO_PORTF_DATA_R =0x02;
            GPIO_PORTA_DATA_R ^=0x04;
        }

        if( engine_status==1 && door_status == 1 )
        {
        if(gear=='N')
        {
       GPIO_PORTF_DATA_R =0x00; // glow green
       PWM1_1_CMPA_R = 4950;

     }
   else if(gear=='1')
     {
       GPIO_PORTF_DATA_R =0x08; // glow green
         PWM1_1_CMPA_R = 4900;

     }

   else if(gear=='2')
     {
       GPIO_PORTF_DATA_R =0x08; // glow green
         PWM1_1_CMPA_R = 4700;
     }

   else if(gear=='3')
     {
       GPIO_PORTF_DATA_R =0x08; // glow green
       PWM1_1_CMPA_R = 4600;
     }

   else if(gear=='4')
     {
       GPIO_PORTF_DATA_R =0x08; // glow green
         PWM1_1_CMPA_R = 4500;
     }

   else if(gear=='5')
     {
       GPIO_PORTF_DATA_R =0x08; // glow green
       PWM1_1_CMPA_R = 4400;
     }

    }

    }
}

void initialize_ports(void)
{
    SYSCTL_RCGC2_R |= 0x0000003B;
    SYSCTL_RCGCGPIO_R |= 0x3B;   /* enable clock */
    SYSCTL_RCGCSSI_R |= 2;       /* enable clock to SSI1 */
    //PWM Settings
    SYSCTL_RCGCPWM_R |= 2;       /* enable clock to PWM1 */
    SYSCTL_RCC_R |= 0x100000; /* no pre-divide for PWM clock */
    SYSCTL_RCC_R |= 0x080000; /* no pre-divide for PWM clock */
    PWM1_1_CTL_R = 0;            /* stop counter */
    PWM1_1_GENB_R = 0x0000008C;  /* M1PWM7 output set when reload, */                                /* clear when match PWMCMPA */
    PWM1_1_LOAD_R = 12500;       /* set load value for 1kHz (16MHz/16000) */
    PWM1_1_CMPA_R = 12500;       /* set duty cycle to min */
    PWM1_1_CTL_R = 1;            /* start timer */
    PWM1_ENABLE_R = 0x08;        /* start PWM1 ch7 */
    //ADC Settings
     SYSCTL_RCGCADC_R |= 1;     /* enable clock to ADC0 */
     GPIO_PORTE_AFSEL_R |= 8;   /* enable alternate function */
     GPIO_PORTE_DEN_R &= ~8;    /* disable digital function */
     GPIO_PORTE_AMSEL_R |= 8;   /* enable analog function */
     ADC0_ACTSS_R &= ~8;        /* disable SS3 during configuration */
     ADC0_EMUX_R &= ~0xF000;    /* software trigger conversion */
     ADC0_SSMUX3_R = 0;         /* get input from channel 0 */
     ADC0_SSCTL3_R |= 6;        /* take one sample at a time, set flag at 1st sample */
     ADC0_ACTSS_R |= 8;         /* enable ADC0 sequencer 3 */
    //Port B settings
    GPIO_PORTB_AMSEL_R = 0x00;
    GPIO_PORTB_PCTL_R = 0x00;
    GPIO_PORTB_DIR_R = 0xFF;
    GPIO_PORTB_AFSEL_R = 0x00;
    GPIO_PORTB_DEN_R = 0xFF;
    //Port A settings
    GPIO_PORTA_AMSEL_R = 0x00;
    GPIO_PORTA_PCTL_R = 0x00;
    GPIO_PORTA_DIR_R = 0xFF;
    GPIO_PORTA_AFSEL_R = 0x00;
    GPIO_PORTA_DEN_R = 0xFF;
    //Port F settings
    GPIO_PORTF_LOCK_R = 0x4C4F434B; /* unlock commit register */
    GPIO_PORTF_CR_R = 0x01;
    GPIO_PORTF_DIR_R = 0x0E;
    GPIO_PORTF_DEN_R = 0x1F;
    GPIO_PORTF_PUR_R = 0x11; /* enable pull up for pin 4 */
    GPIO_PORTF_IS_R &= ~0x11;       /*  PF is edge-sensitive */
    GPIO_PORTF_IBE_R &= ~0x11;      /*  PF is not both edges */
    GPIO_PORTF_IEV_R &= ~0x11;      /*  PF falling edge event */
    GPIO_PORTF_ICR_R = 0x11;        /*  Clear flag */
    GPIO_PORTF_IM_R |= 0x11;        /*  arm interrupt on PF */
    //Interrupt settings
    NVIC_PRI7_R = (NVIC_PRI7_R & 0xFF1FFFFF) | 0x00A00000; /*  priority 5 for Port F*/
    NVIC_EN0_R = 0x40000000;        /*  Enable interrupt 30 in NVIC */
    NVIC_ST_RELOAD_R = 64000;           //Load timer value
    NVIC_ST_CTRL_R = 7;                 //Enable SYSTICK interrupt
    NVIC_SYS_PRI3_R = (NVIC_SYS_PRI3_R & 0x0FFFFFFF) | 0x20000000; /*  priority 1 for SYSTICK*/
}
void LCD_init(void)
{
    LCD_Cmd(FUNCTION_SET_8BIT);     // Select 8-bit Mode of LCD
    LCD_Cmd(MOVECURSORRIGHT);       // shift cursor right
    LCD_Cmd(0x38);          // for using 2 lines and 5X7 matrix of LCD
        LCD_Cmd(0x0C);          // turn display ON, cursor OFF
        LCD_Cmd(0x01);          // clear LCD screen
        LCD_Cmd(0x80);          // bring cursor to position 1 of line 1
}
void delayMs(int n)
{
    for(int i = 0 ; i < n; i++)
        for(int j = 0; j < 3180; j++) {}   /* do nothing for 1 ms */
}


void LCD_Write_Char(unsigned char data)
{
    unsigned int portB, portA;
    portA = GPIO_PORTA_DATA_R;      // reduce flicker in 7_Seg Display
    portB = GPIO_PORTB_DATA_R;
    GPIO_PORTA_DATA_R |= RS;        //set RS =1 to write data
    GPIO_PORTB_DATA_R = data;
    GPIO_PORTA_DATA_R |= EN;        // GENERATE STROBE TO LATCH DATA
    delay_us(0);
    GPIO_PORTA_DATA_R &= ~(EN);
//    GPIO_PORTA_DATA_R = portA;
//    GPIO_PORTB_DATA_R = portB;
    GPIO_PORTA_DATA_R &=~0x10;
    GPIO_PORTA_DATA_R &=~0x20;
      GPIO_PORTA_DATA_R &=~0x40;
    //  GPIO_PORTA_DATA_R &=~0x80;
    delay_us(40);
}

void LCD_String(char *str) /* Send string to LCD function */
{
    int i;
    for(i=0;str[i]!=0;i++)  /* Send each char of string till the NULL */
    {
        LCD_Write_Char(str[i]);  /* Call LCD data write */
    }
}

void LCD_Cmd(unsigned char command)
{
    unsigned int portB, portA;
    portA = GPIO_PORTA_DATA_R;         // reduce flicker in 7_Seg Display
    portB = GPIO_PORTB_DATA_R;
    GPIO_PORTA_DATA_R &=~0x10;
    GPIO_PORTA_DATA_R &=~0x20;
    GPIO_PORTA_DATA_R &=~0x40;
    GPIO_PORTA_DATA_R &=~0x80;
    GPIO_PORTA_DATA_R &= ~(RS);        //set RS = 0 to write command
    GPIO_PORTB_DATA_R = command;
    GPIO_PORTA_DATA_R |= EN;        // GENERATE STROBE TO LATCH DATA
    delay_us(0);
    GPIO_PORTA_DATA_R &= ~(EN);
    GPIO_PORTA_DATA_R &=~0x10;
    GPIO_PORTA_DATA_R &=~0x20;
    GPIO_PORTA_DATA_R &=~0x40;
    GPIO_PORTA_DATA_R &=~0x80;
//    GPIO_PORTA_DATA_R = portA;
//    GPIO_PORTB_DATA_R = portB;
    if (command < 4)
        delayMs(2);         /* 2ms delay for commands 1 and 2 */
    else
        delay_us(40);        /* 40us delay for other commands */
}

void GPIOPortC_Handler(void)
{
    int j;
    delayMs(1);
    GPIO_PORTE_DATA_R &= 0xFE;
    for(j = 0; j < 10; j++) {}
    if ((~GPIO_PORTC_DATA_R & 0x10) == 0x10){
        belt = 1;
    }
    if ((~GPIO_PORTC_DATA_R & 0x20) == 0x20){
          belt = 0;
      }
    GPIO_PORTE_DATA_R = 0x00;
    GPIO_PORTC_ICR_R = 0xF0;        /* clear PF4_0 int */
}

void GPIOPortE_Handler(void)
{
    GPIO_PORTE_ICR_R = 0x04;
    time = time + 1;
    int i,j;
    for(i=0;i<10;i++)
        for(j=0;j<2;j++)
        {}
}

void HC_SR04_setup(void)
{
    // NOTE : PD0 and PD1 are internally connected to PB6 and PB7 respectively by in Tiva Launchpad Board
    // Avoid using these set of pins together.
    SYSCTL_RCGCGPIO_R |= 0x08;      // Enable clock to GPIO PORTD
    GPIO_PORTD_DIR_R |= 0x04;       // Set PD0 as output (trigger) and PD1 as input (echo)
    GPIO_PORTD_DEN_R |= 0x0C;       // Enable bit 0 and 1 of PORTD
    GPIO_PORTD_AFSEL_R = 0x08;      // Set alternate function WTIMER2CCP1
    GPIO_PORTD_PCTL_R &= ~0x0000F000;
    GPIO_PORTD_PCTL_R |= 0x00007000;// PORTD bit 1 selected for alternate function
    // Set up timer WT2CCP1
    SYSCTL_RCGCWTIMER_R |= 8;       // Enable clock to to timer 2
    WTIMER3_CTL_R &= ~0x0100;       // Disable timer during setup
    WTIMER3_CFG_R = 0x00000004;     // 32 bit mode
    WTIMER3_TBILR_R = (608000);   // Timer LOAD REG value = 38 ms
    // Configure TIMER_B
    // bits 1:0 = [11] Capture Mode
    // bit 2    = 1    Capture Mode - Edge Time
    // bit 3    = 0    Capture Mode enabled
    // bit 4    = 0    Count down
    WTIMER3_TBMR_R = 0x07;          // Configure TIMER_B
    WTIMER3_CTL_R |= 0x0C00;        // Detect both edges
    WTIMER3_CTL_R |= 0x0100;         // Enable Timer
    WTIMER3_ICR_R = 0x0400;         // Clear timeout and event interrupt flags
    WTIMER3_IMR_R |= 0x0400;        // Unmask interrupt for capture event mode

    NVIC_EN3_R |= 0x00000020;       // NVIC enabled (IRQ number = 100)
}
void send_trigger_pulse(void)
{
    GPIO_PORTD_DATA_R = 0x00;
    delay_us(10);
    GPIO_PORTD_DATA_R = 0x04;
    delay_us(10);
    GPIO_PORTD_DATA_R = 0x00;
}

unsigned int calculate_distance(void)
{
    unsigned int distance;
    int time;
    if(time_value1 < time_value2)
    {
        time = time_value1 + (608000) - time_value2;
    }
    else
    {
        time = time_value1 - time_value2;
    }
    time = time/(16*2);
    distance = 34000*time/1000000;
    return distance;
}

void WTIMER3_Handler(void)
{
    if((WTIMER3_MIS_R & 0x0400) && (GPIO_PORTD_DATA_R & 0x08))
    {
        time_value1 = WTIMER3_TBR_R;
    }
    if((WTIMER3_MIS_R & 0x0400) && !(GPIO_PORTD_DATA_R & 0x08))
    {
        time_value2 = (WTIMER3_TBR_R);
    }
    WTIMER3_ICR_R = 0x0400 ;
}


void GPIOPortF_Handler(void)
{
    if (GPIO_PORTF_MIS_R & 0x10) /* check if interrupt causes by PF4/SW1*/
        {
                      if(door_status==1)
                      {
                          door_status=0;
                      }
                      else
                      {
                          door_status=1;
                      }
          GPIO_PORTF_DATA_R  |= (1<<3);
          GPIO_PORTF_ICR_R  |= 0x10; /* clear the interrupt flag */
         }
        else if (GPIO_PORTF_MIS_R & 0x01) /* check if interrupt causes by PF0/SW2 */
        {
                            if( engine_status==1)
                                {
                                    engine_status=0;
                                }
                            else
                              {
                                    engine_status=1;
                                }

         //GPIO_PORTF_DATA_R  &= ~0x08;
         GPIO_PORTF_ICR_R  |= 0x01; /* clear the interrupt flag */
        }
}

/* global enable interrupts */
void EnableInterrupts(void)
{
    __asm  ("    CPSIE  I\n");
}

void DisableInterrupts(void)
{
    __asm ("    CPSID  I\n");
}
