#include <stdlib.h>
#include <stdint.h>
#include <stdbool.h>
#include <./inc/tm4c123gh6pm.h>
#include <inc/hw_memmap.h>
#include <inc/hw_types.h>
#include <driverlib/gpio.h>
#include <driverlib/pin_map.h>
#include <driverlib/sysctl.h>
#include <driverlib/uart.h>
#include<string.h>
#define BUFFER_SIZE 25

char BUFFER[BUFFER_SIZE];

unsigned long on_time = 0;
unsigned long time_period = 0;
char snum[20];
float duty;
int result=0;
float avg=0;
float avg_volt = 0;
int N=0;
int count = 0;
int i = 0;

void UART0_init(void);
void ADC0_init(void);
void LCD_Initialization(void);
void SysTickDelay(int);
int Timer0ACapture_PulseWidth(void);
int Timer0ACapture_OffWidth(void);



void ADC0_init(void){
    SYSCTL_RCGCGPIO_R |= 0x10; /* enable clock to PE (AIN0 is on PE3) */
    SYSCTL_RCGCADC_R |= 1;     /* enable clock to ADC0 */
    /* initialize PE3 for AIN0 input  */
     GPIO_PORTE_AFSEL_R |= 8;   /* enable alternate function */
     GPIO_PORTE_DEN_R &= ~8;    /* disable digital function */
    GPIO_PORTE_AMSEL_R |= 8;   /* enable analog function */
     GPIO_PORTE_PDR_R |= 8;
    /* initialize ADC0 */
    ADC0_ACTSS_R &= ~8;        /* disable SS3 during configuration */
    ADC0_EMUX_R &= ~0xF000;    /* software trigger conversion */
    ADC0_SSMUX3_R = 0;         /* get input from channel 0 */
    ADC0_SSCTL3_R |= 6;        /* take one sample at a time, set flag at 1st sample */
    ADC0_ACTSS_R |= 8;         /* enable ADC0 sequencer 3 */
}

void UART0_init(void){
    SYSCTL_RCGC2_R |= 0x00000020;
    GPIO_PORTF_LOCK_R |= 0x4C4F434B;
    GPIO_PORTF_CR_R |= 0x11;
    GPIO_PORTF_DIR_R |= 0x0E;
    GPIO_PORTF_DEN_R |= 0x1F;
    GPIO_PORTF_PUR_R |= 0x11;
    SysCtlPeripheralEnable(SYSCTL_PERIPH_UART0);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);
    GPIOPinConfigure(GPIO_PA0_U0RX);
    GPIOPinConfigure(GPIO_PA1_U0TX);
    GPIOPinTypeUART(GPIO_PORTA_BASE, GPIO_PIN_0 | GPIO_PIN_1);
    UARTConfigSetExpClk(UART0_BASE, SysCtlClockGet(), 115200,(UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE));
}

void DisableInterrupts(void)
{
    __asm ("    CPSID  I\n");
}


void SysTickDelay(int delayMs){
    int delay = delayMs*16000;
    NVIC_ST_CTRL_R = 0; /* disable SysTick during setup */
    NVIC_ST_RELOAD_R = delay-1; /* Reload Value goes here */
    NVIC_ST_CTRL_R |= 0x5; /* enable SysTick with core clock */
    while( (NVIC_ST_CTRL_R & (1<<16) ) == 0); /* Monitoring bit 16 to be set */
    NVIC_ST_CTRL_R = 0; /* Disabling SysTick Timer */
}

void LCD_Initialization(void){
    // enable GPIO ports A, B and F
    SYSCTL_RCGC2_R |= 0x00000023;

    // set ports A and B as outputs
    GPIO_PORTA_DIR_R |= 0xFF;
    GPIO_PORTA_DEN_R |= 0xFF;
    GPIO_PORTB_DIR_R |= 0xFF;
    GPIO_PORTB_DEN_R |= 0xFF;

    /* enable clocks */
    SYSCTL_RCGCGPIO_R |= 0x10; /* enable clock to PE (AIN0 is on PE3) */
    SYSCTL_RCGCADC_R |= 1; /* enable clock to ADC0 */

    SysTickDelay(200);
    GPIO_PORTB_DATA_R = 0x30;
    GPIO_PORTA_DATA_R = 0x80;
    SysTickDelay(1);
    GPIO_PORTA_DATA_R = 0x00;
    SysTickDelay(10);
    GPIO_PORTB_DATA_R = 0x30;
    GPIO_PORTA_DATA_R = 0x80;
    SysTickDelay(1);
    GPIO_PORTA_DATA_R = 0x00;

    SysTickDelay(1);
    GPIO_PORTB_DATA_R = 0x30;
    GPIO_PORTA_DATA_R = 0x80;
    SysTickDelay(1);
    GPIO_PORTA_DATA_R = 0x00;
    SysTickDelay(1);

    GPIO_PORTB_DATA_R = 0x38;
    GPIO_PORTA_DATA_R = 0x80;
    SysTickDelay(1);
    GPIO_PORTA_DATA_R = 0x00;
    SysTickDelay(1);

    GPIO_PORTB_DATA_R = 0x01;
    GPIO_PORTA_DATA_R = 0x80;
    SysTickDelay(1);
    GPIO_PORTA_DATA_R = 0x00;
    SysTickDelay(5);

    GPIO_PORTB_DATA_R = 0x06;
    GPIO_PORTA_DATA_R = 0x80;
    SysTickDelay(1);
    GPIO_PORTA_DATA_R = 0x00;
    SysTickDelay(1);
    GPIO_PORTB_DATA_R = 0x0C;
    GPIO_PORTA_DATA_R = 0x80;
    SysTickDelay(1);
    GPIO_PORTA_DATA_R = 0x00;

}

void writeStringLCD(char s[], int line)
{
if (line == 1)
{
    GPIO_PORTB_DATA_R = 0x80;
    GPIO_PORTA_DATA_R = 0x80;
    SysTickDelay(3);
    GPIO_PORTA_DATA_R = 0x00;
    SysTickDelay(3);
}
else
{
    GPIO_PORTB_DATA_R = 0xC0;
    GPIO_PORTA_DATA_R = 0x80;
    SysTickDelay(3);
    GPIO_PORTA_DATA_R = 0x00;
    SysTickDelay(3);
}



int i = 0;
while (s[i] != '\0')
{
    GPIO_PORTB_DATA_R = s[i];
    GPIO_PORTA_DATA_R = 0xC0;
    SysTickDelay(3);
    GPIO_PORTA_DATA_R = 0x40;
    SysTickDelay(3);
    i++;
}
}


void ClearLCD(){
    GPIO_PORTB_DATA_R = 0x01;
    InstrEnablePulse();
}


void InstrEnablePulse(){
    GPIO_PORTA_DATA_R = 0x80;
    SysTickDelay(5);
    GPIO_PORTA_DATA_R = 0x00;
    SysTickDelay(5);
}

void DataEnablePulse(){
    GPIO_PORTA_DATA_R = 0xC0;
    SysTickDelay(3);
    GPIO_PORTA_DATA_R = 0x40;
    SysTickDelay(3);
}

int Timer0ACapture_PulseWidth(void)
{
    int risingEdge, fallingEdge;
    while(1)
    {
    TIMER1_ICR_R = 4;            /* clear timer0A capture flag */
    while((TIMER1_RIS_R & (1<<2)) == 0) ;    /* wait till captured */
      if(GPIO_PORTF_DATA_R & (1<<2)) /*check if rising edge occurs */
        {
    risingEdge = TIMER1_TAR_R;     /* save the timestamp */
    TIMER1_ICR_R = 4;            /* clear timer0A capture flag */
    /* detect falling edge */
    while((TIMER1_RIS_R & (1<<2)) == 0) ;    /* wait till captured */
    fallingEdge = TIMER1_TAR_R;     /* save the timestamp */

    return (fallingEdge - risingEdge) & 0x00FFFFFF; /* return the time difference */
        }
    }
}

int Timer0ACapture_OffWidth(void)
{
    int risingEdge, risingEdge_next;
    while(1)
    {
    TIMER1_ICR_R = 4;            /* clear timer0A capture flag */
    while((TIMER1_RIS_R & (1<<2)) == 0) ;    /* wait till captured */
      if(GPIO_PORTF_DATA_R & (1<<2)) /*check if falling edge occurs */
        {
            risingEdge = TIMER1_TAR_R;     /* save the timestamp */
            TIMER1_ICR_R = 4;            /* clear timer0A capture flag */
            while((TIMER1_RIS_R & (1<<2)) == 0) ;
            TIMER1_ICR_R = 4;            /* clear timer0A capture flag */
            while((TIMER1_RIS_R & (1<<2)) == 0) ;

            if(GPIO_PORTF_DATA_R & (1<<2)) /*check if falling edge occurs */
            {
                risingEdge_next = TIMER1_TAR_R;     /* save the timestamp */
            }

            return (risingEdge_next - risingEdge) & 0x00FFFFFF; /* return the time difference */
        }
    }
}

int PWM_timer(int start, int command_flag){
    if((start==1) && (command_flag==1)){
         on_time = Timer0ACapture_PulseWidth();

         time_period = Timer0ACapture_OffWidth();

         duty = ((float)on_time/((float)time_period))*3.3;

         //itoa(duty, snum, 10);
         gcvt(duty, 5, snum);

         ClearLCD();
         writeStringLCD("Timer Mode (V)",1);
         writeStringLCD(snum,2);

         SysTickDelay(500);

    }
}

int PWM_ADC(int start, int command_flag){
    if((start==1) && (command_flag==1)){
        ADC0_PSSI_R |= 8;      /* start a conversion sequence 3 */
        while((ADC0_RIS_R & 8) == 0);         /* wait for conversion complete */
        result = ADC0_SSFIFO3_R; /* read conversion result */

        if(result < 1300){
            result = 0;
        }



        ADC0_ISC_R = 8;        /* clear completion flag */


        avg=(N*avg+(float)result)/(N+1);
        N++;

        avg_volt = avg*3.3/4096;
        gcvt(avg_volt,5, snum);

        count++;

        if(count == 1000){
            ClearLCD();
            writeStringLCD("ADC Mode (V)",1);
            writeStringLCD(snum,2);
            count = 0;
        }
    }
}

int main(){

    UART0_init();
    ADC0_init();
    SYSCTL_RCGC2_R = SYSCTL_RCGC2_GPIOF;

    GPIO_PORTF_DIR_R = 0x06;
    GPIO_PORTF_DEN_R = 0x06;
    GPIO_PORTF_AFSEL_R = 0x00;


    DisableInterrupts();

    //SystemInit();
    SYSCTL_RCGCTIMER_R |= 2;  /* enable clock to Timer Block 1 */
    SYSCTL_RCGCGPIO_R |= 32;      /* enable clock to PORTF */
    GPIO_PORTF_DIR_R &= ~(1<<2);        /* make PF2 an input pin */
    GPIO_PORTF_DEN_R |= (1<<2);         /* make PF2 as digital pin */
    GPIO_PORTF_AFSEL_R |= (1<<2);       /* use PF2 alternate function */
    GPIO_PORTF_PCTL_R &= ~0x00000F00;  /* configure PF2 for T0CCP0 */
    GPIO_PORTF_PCTL_R |= 0x000000700;
    TIMER1_CTL_R &= ~(1<<0);           /* disable timer0A during setup */
    TIMER1_CFG_R = 4; /* Timer0A in 16-bit timer mode */
    TIMER1_TAMR_R = 0x17; /* Timer0A enable up-count, capture mod, input edge time mode*/
    TIMER1_CTL_R |= (1<<3)|(1<<2);   /* capture rising and falling edges on PF2 pin */
    TIMER1_CTL_R |= (1<<0);   /* enable Timer0A */




    LCD_Initialization();
    ClearLCD();
    writeStringLCD("Average voltage  ",1);
    writeStringLCD("of PWM waveform ",2);


    DisableInterrupts();
  //  float duty;

    int start=0;



    char val;
    int ADC = 0;
    int Timer = 0;
    int command_flag=0;
    while(1){

        if (UARTCharsAvail(UART0_BASE)){
          val = UARTCharGet(UART0_BASE);
          UARTCharPut(UART0_BASE, val);
          if (val != 0x0D && i < BUFFER_SIZE){
            BUFFER[i] = val;
            i++;
            command_flag=0;
          }
          else{
            BUFFER[i] = '\0';
            i = 0;
            UARTCharPut(UART0_BASE, 0x0A);
            command_flag=1;
          }
        }


        if(command_flag==1){
          if (strcmp(BUFFER, "start")==0){
              start=1;
          }
          else if (strcmp(BUFFER, "stop")==0){
              start=0;
              N=0;
              ClearLCD();
          }
          else if (strcmp(BUFFER, "pause")==0){
              start=0;
          }
         else if (strcmp(BUFFER, "ADC")==0){
              ADC =1;
              Timer = 0;
          }
          else if (strcmp(BUFFER, "Timer")==0){
              ADC = 0;
              Timer = 1;
          }
        }


        if(ADC == 1){
            PWM_ADC(start, command_flag);
        }
        else if(Timer == 1){
            PWM_timer(start, command_flag);
        }




        }
    return 0;
}

