#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>
#include <string.h>
#include <ctype.h>
#include "inc/tm4c123gh6pm.h"
#include "driverlib/gpio.h"
#include "driverlib/pin_map.h"
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "driverlib/sysctl.h"
#include "driverlib/i2c.h"
#include <driverlib/pin_map.h>
#include <driverlib/sysctl.h>
#include <driverlib/uart.h>
#include <string.h>
#include <math.h>







#define RS 0x40    // PA6
#define E  0x80    // PA7







void delayMs(int n);
void LCD_command(unsigned char command);
void LCD_data(unsigned char data);
void LCD_setup();







int current_sense=0;
int adc_value1=0;
void delayMs(int n);
unsigned char rx_data ;







void LDC_setup()
{
    SYSCTL_RCGCGPIO_R |= 0x03;    // Enable clock to Port A and Port B







    // Port A Initialization
    GPIO_PORTA_DEN_R |= 0xC0;    // Set PA6 and PA7 as digital
    GPIO_PORTA_DIR_R |= 0xC0;    // Set PA6 and PA7 as output
    GPIO_PORTA_DATA_R &= ~E;     // Set E to low initially







    // Port B Initialization
    GPIO_PORTB_DEN_R |= 0xFF;    // Set PB0-PB7 as digital
    GPIO_PORTB_DIR_R |= 0xFF;    // Set PB0-PB7 as output
   delayMs(20);                 // Wait for LCD to power up
    // LCD Initialization
    LCD_command(0x30);           // Wake up
    delayMs(5);
    LCD_command(0x30);           // Wake up #2
    delayMs(1);
    LCD_command(0x30);           // Wake up #3
    delayMs(1);
    LCD_command(0x38);           // Function set: 8-bit, 2-line, 5x7 dots
    //LCD_command(0x08);
    LCD_command(0x06);           // Entry mode set: auto-increment
    LCD_command(0x0F);           // Display control: display on, cursor on, blink on
    LCD_command(0x01);           // Clear display
    delayMs(2);







}







void LCD_command(unsigned char command)
{
    GPIO_PORTA_DATA_R &= ~RS;     // Set RS to 0 for command
    GPIO_PORTB_DATA_R = command;  // Send command to data pins
    GPIO_PORTA_DATA_R |= E;      // Pulse E pin high
    delayMs(1);
    GPIO_PORTA_DATA_R &= ~E;     // Pulse E pin low
    delayMs(2);
}







void LCD_data(unsigned char data)
{
    GPIO_PORTA_DATA_R |= RS;     // Set RS to 1 for data
    GPIO_PORTB_DATA_R = data;    // Send data to data pins
    GPIO_PORTA_DATA_R |= E;      // Pulse E pin high
    delayMs(1);
    GPIO_PORTA_DATA_R &= ~E;     // Pulse E pin low
    delayMs(2);
}







void delayMs(int n)
{
    int i, j;
    for(i = 0 ; i < n ; i++)
        for(j = 0 ; j < 3180 ; j++)
            {}  // Do nothing for 1 ms
}








void adc_initialise()
{
    /* enable clocks */







                                    SYSCTL_RCGCGPIO_R |= 0x30; /* enable clock to PE (AIN0 is on PE3) */







                                    SYSCTL_RCGCADC_R |= 1;     /* enable clock to ADC0 */








                                    /* initialize PE3 for AIN0 input  */







                                    GPIO_PORTE_AFSEL_R |= 8;   /* enable alternate function */







                                    GPIO_PORTE_DEN_R &= ~8;    /* disable digital function */







                                    GPIO_PORTE_AMSEL_R |= 8;   /* enable analog function */








                                    /* initialize ADC0 */







                                    ADC0_ACTSS_R &= ~8;        /* disable SS3 during configuration */







                                    ADC0_EMUX_R &= ~0xF000;    /* software trigger conversion */







                                    ADC0_SSMUX3_R = 0;         /* get input from channel 0 */







                                    ADC0_SSCTL3_R |= 6;        /* take one sample at a time, set flag at 1st sample */







                                    ADC0_ACTSS_R |= 8;         /* enable ADC0 sequencer 3 */
}








void pwm_initialise()
{







    /* Enable Peripheral Clocks */







       SYSCTL_RCGCPWM_R |= 2;       /* enable clock to PWM1 */







       SYSCTL_RCGCGPIO_R |= 0x10;   /* enable clock to PORTE */







       SYSCTL_RCC_R &= ~0x00100000; /* no pre-divide for PWM clock */
//       SYSCTL_RCC_R |= 0x080000; /* no pre-divide for PWM clock */











       /* Enable port PF3 for PWM1 M1PWM7 */







       GPIO_PORTE_AFSEL_R = 0x20;      /* E port  uses alternate function */







       GPIO_PORTE_PCTL_R &= ~0x00F00000; /* make GPIO pin 5 is controlled */







       GPIO_PORTE_PCTL_R |= 0x00500000;







       GPIO_PORTE_DEN_R |= 0x20;       /* pin digital */











       PWM1_1_CTL_R = 0;            /* stop counter */







       PWM1_1_GENB_R = 0x0000008C;  /* M1PWM7 output set when reload, */







                                    /* clear when match PWMCMPA */







       PWM1_1_LOAD_R = 4096;       /* set load value for 1kHz (16MHz/16000) */







       PWM1_1_CMPA_R = 4095;       /* set duty cycle to min */







       PWM1_1_CTL_R = 1;            /* start timer */







       PWM1_ENABLE_R = 0x08;        /* start PWM1 ch7 */







}







//void ADC0SS3_Handler(void){
//
//
//    current_sense = ADC0_SSFIFO3_R; /* read adc coversion result from SS3 FIFO*/
//    ADC0_ISC_R = 8;          /* clear coversion clear flag bit*/
//    ADC0_PSSI_R |= (1<<3);        /* Enable SS3 conversion or start sampling data from AN0 */
//    //adcvalue();
//}







void adc_sample()
{







    ADC0_PSSI_R |= 8;




                       while((ADC0_RIS_R & 8) == 0)  ;







                       current_sense = ADC0_SSFIFO3_R;
                       //delayMs(10);
                       //delayMs(100);
                       ADC0_ISC_R = 8;
 }







int main()
{
 float adc_real = 0;
 int adc_real_1 = 0;
 //float temp_set = 0.8;
 adc_initialise();
 pwm_initialise();
 LDC_setup();
 LCD_data('V');
 LCD_data('=');

while(1)
    {
      adc_sample();

      LCD_command(0x82);
//     delayMs(100);
      //ADC_Transmitter(current_sense);
      //ADC_Transmitter('\n');
      adc_value1 = current_sense;
      //ADC_Transmit
      adc_real=((float)adc_value1*5)/4096;
      adc_real_1=adc_real*2;
      LCD_data(48+(((int)(adc_real_1)%10)));
      LCD_command(0x83);

    if (adc_value1<2048)
    {
        PWM1_1_CMPA_R=0;
    }
    else
    {
        PWM1_1_CMPA_R=adc_value1-2048;
        delayMs(20);
    }

    }
}
