#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include <stdbool.h>
#include <math.h>
#include "inc/tm4c123gh6pm.h"
#include "inc/hw_types.h"
#include "inc/hw_memmap.h"
#include "driverlib/sysctl.h"
#include "driverlib/pin_map.h"
#include "driverlib/debug.h"
#include "driverlib/gpio.h"
#include "driverlib/flash.h"
#include "driverlib/eeprom.h"
#include "Jumpy.h"


int sw1, sw2, loc, dol_loc, up, over, jump_count, HS, reload, delay_val, valid, dol, f, dol_count, eat, welcome;
unsigned char score_string[5]={'0'};
unsigned char HS_string[5];
float num,incr;

uint32_t pui32Read[2];
uint32_t score_rom[2]={200,200};
uint32_t score;
uint32_t init_rom[2]={0,0};

int main(void)
{
    // variable initialization
    sw1=0; sw2=0; loc=15; up=0; over=0; jump_count = 0, num = 1, incr=0.5, score=0;
    dol_loc=11, dol_count=0;

    GPIO_init();
    Systick_init();
    Custom_char_init();
    LCD_init();
    welcome_msg();

    while(1)
    {
        if(sw1==1)      // first switch
        {
            ready_msg();
            smile_init();             // start with smile state
            welcome=0;
            sw1 = 0;
            break;
        }
    }

    // check for switch
    eat = 0;
    while (1)
    {
        if(sw1==1)
        {
            go_up();   // jump to nervous state
            sw1=0;

            if (loc<4)  // cactus skipped
                score=score+0.5/incr;

            if ((dol_loc<4) && (dol_loc>1)) // dollar collected
            {
                collect_dollar();
                score=score+5*0.5/incr;
            }

            go_down();      // come back to smile state
            print_score();
            increase_speed();
        }
        else if((loc==3) && (up!=1))     // collision
        {
            collision();    // goes to sad state
            break;                  // game over
        }
    }
    Calculate_highest();
    Disp_gameover();
    while(1)
    {
        if(sw1==1)
        {
            Clear_memory(); // Clear highest score
        }
    }

}



// FUNCTIONS
void delay(int n)                   // n milisecond
{
    int i, j;
    for(i = 0 ; i < n; i++)
           for(j = 0; j < 1600; j++)
           {}
}


void lcd_data(unsigned char data)
{
    GPIO_PORTB_DATA_R = data;
    GPIO_PORTA_DATA_R |= 0x60;
    GPIO_PORTA_DATA_R &= ~0x80;
    delay(2);
    GPIO_PORTA_DATA_R |= 0x80;
}

void lcd_cmd(unsigned char cmd)
{
    GPIO_PORTB_DATA_R = cmd;
    GPIO_PORTA_DATA_R &= ~0x60;
    GPIO_PORTA_DATA_R &= ~0x80;
    delay(2);
    GPIO_PORTA_DATA_R |= 0x80;
}

void lcd_write(const char *str)
{
    /* Writing a string to LCD */
    int length=strlen(str);
    for(int i=0;i<length && i<16;i++)
        lcd_data(str[i]);
}


void SysTick_Handler(void)
{
    if(welcome==0)
    {
    if((loc>=-1) && (over==0))
    {
        dol_count = dol_count+1;
        lcd_cmd(0xC0+loc+1);        // clear previous
        lcd_write(" ");
        delay(5);
        lcd_cmd(0xC0+loc);
        lcd_data(CAC);
        delay(5);

        loc=loc-1;
        if (loc<-1)
        {
            loc=15;
            lcd_cmd(0xC0);
            lcd_write(" ");
            delay(5);
        }
    }
    if ((dol_count%2 == 0) && (over==0) )
    {
    if((dol_loc>=-1))
    {

            lcd_cmd(0x80+dol_loc+1);        // clear previous
            lcd_write(" ");
            delay(5);

            if(eat==0)
            {
                lcd_cmd(0x80+dol_loc);
                lcd_write("$");
                delay(5);
            }

            dol_loc=dol_loc-1;
            if (dol_loc<-1)
            {
                dol_loc=11;
                lcd_cmd(0x80);
                lcd_write(" ");
                delay(5);
                eat=0;
            }
    }
    }
    }
}

void GPIOPortF_Handler(void)
{
    if ((GPIO_PORTF_MIS_R && 0x10) == 1) /* check if interrupt causes by PF4/SW1*/
        {
          sw1 = 1;
          delay(10);

          GPIO_PORTF_ICR_R  |= 0x10; /* clear the interrupt flag */
         }

}

void GPIO_init(void)
{
        SYSCTL_RCGC2_R |= 0x23;
        GPIO_PORTA_CR_R = 0xC0;         // make PORT A6, A7 configurable
        GPIO_PORTB_CR_R = 0xFF;         // make PORTB configurable
        GPIO_PORTA_DEN_R = 0xC0;
        GPIO_PORTA_DIR_R = 0xC0;
        GPIO_PORTB_DEN_R = 0xFF;
        GPIO_PORTB_DIR_R = 0xFF;

        GPIO_PORTA_DEN_R |= 0xF0;
        GPIO_PORTA_DIR_R |= 0xF0;

        GPIO_PORTF_DEN_R = 0x10;
        GPIO_PORTF_DIR_R = 0x00;
        GPIO_PORTF_PUR_R = 0x10;
        GPIO_PORTF_IS_R  &= ~(1<<4)|~(1<<0);        /* make bit 4, 0 edge sensitive */
        GPIO_PORTF_IBE_R &=~(1<<4)|~(1<<0);         /* trigger is controlled by IEV */
        GPIO_PORTF_IEV_R &= ~(1<<4)|~(1<<0);        /* falling edge trigger */
        GPIO_PORTF_ICR_R |= (1<<4)|(1<<0);          /* clear any prior interrupt */
        GPIO_PORTF_IM_R  |= (1<<4)|(1<<0);          /* unmask interrupt */
        NVIC_PRI7_R  = 3 << 5;     /* set interrupt priority to 3 */
        NVIC_EN0_R |= (1<<30);  /* enable IRQ30 (D30 of ISER[0]) */
}

void Systick_init(void)
{
        NVIC_ST_CTRL_R = 0;            /* (1) disable SysTick during setup */
        NVIC_ST_RELOAD_R = 16000000-1; // one second delay relaod value
        NVIC_ST_CTRL_R |= 7 ; // enable counter, interrupt and select system bus clock
        NVIC_ST_CURRENT_R  = 0; //initialize current value register
}

void Custom_char_init()
{
    // CUSTOM CHARACTER DATA STORED IN SGRAM
        lcd_cmd(0x0+0x40); lcd_data(0x00);
        // cactus
        lcd_cmd(0x0+0x40); lcd_data(0x04);
        lcd_cmd(0x1+0x40); lcd_data(0x14);
        lcd_cmd(0x2+0x40); lcd_data(0x15);
        lcd_cmd(0x3+0x40); lcd_data(0x15);
        lcd_cmd(0x4+0x40); lcd_data(0x1D);
        lcd_cmd(0x5+0x40); lcd_data(0x07);
        lcd_cmd(0x6+0x40); lcd_data(0x04);
        lcd_cmd(0x7+0x40); lcd_data(0x0E);
        // smile
        lcd_cmd(0x0+0x48); lcd_data(0x00);
        lcd_cmd(0x1+0x48); lcd_data(0x1B);
        lcd_cmd(0x2+0x48); lcd_data(0x1B);
        lcd_cmd(0x3+0x48); lcd_data(0x00);
        lcd_cmd(0x4+0x48); lcd_data(0x1F);
        lcd_cmd(0x5+0x48); lcd_data(0x11);
        lcd_cmd(0x6+0x48); lcd_data(0x0E);
        lcd_cmd(0x7+0x48); lcd_data(0x00);
        // nervous
        lcd_cmd(0x0+0x50); lcd_data(0x00);
        lcd_cmd(0x1+0x50); lcd_data(0x00);
        lcd_cmd(0x2+0x50); lcd_data(0x1B);
        lcd_cmd(0x3+0x50); lcd_data(0x1B);
        lcd_cmd(0x4+0x50); lcd_data(0x00);
        lcd_cmd(0x5+0x50); lcd_data(0x00);
        lcd_cmd(0x6+0x50); lcd_data(0x1F);
        lcd_cmd(0x7+0x50); lcd_data(0x00);
        // sad
        lcd_cmd(0x0+0x58); lcd_data(0x00);
        lcd_cmd(0x1+0x58); lcd_data(0x1B);
        lcd_cmd(0x2+0x58); lcd_data(0x1B);
        lcd_cmd(0x3+0x58); lcd_data(0x00);
        lcd_cmd(0x4+0x58); lcd_data(0x0E);
        lcd_cmd(0x5+0x58); lcd_data(0x11);
        lcd_cmd(0x6+0x58); lcd_data(0x11);
        lcd_cmd(0x7+0x58); lcd_data(0x00);

}

void LCD_init(void)
{
    lcd_cmd(0x38);
    lcd_cmd(0x06);
    lcd_cmd(0x0C);
    lcd_cmd(0x01);
    delay(10);
}

void welcome_msg(void)
{
    lcd_cmd(0x80);
    lcd_write("WELCOME TO JUMPY");
    lcd_cmd(0xC0);
    lcd_write("Press 1 to Start");
    welcome=1;
}

void ready_msg(void)
{
    lcd_cmd(0x01);
    delay(20);
    lcd_cmd(0x80);
    lcd_write("   Get Ready!   ");
    delay(10);
    lcd_cmd(0xC0);
    lcd_write("Game starts in 3");
    delay(1000);
    lcd_cmd(0xCF);
    lcd_write("2");
    delay(1000);
    lcd_cmd(0xCF);
    lcd_write("1");
    delay(1000);
    lcd_cmd(0x01);
    delay(1000);
    lcd_cmd(0x80);
    lcd_write("   --- GO ---   ");
    delay(1000);
    lcd_cmd(0x01);
    delay(1000);
}

void smile_init()
{
    lcd_cmd(0xC0+0x04);
    lcd_data(SMILE);
    delay(5);
}

void go_up(void)
{
    delay_val = MAX(180*(1+13/num),350);             //(2500/num) for num=1, (2500/num)*2 for num>=15
    lcd_cmd(0xC0+0x04);
    lcd_write(" ");         // clears smile
    delay(5);

    lcd_cmd(0x80+0x04);     // jump
    lcd_data(NERVOUS);
    delay(delay_val);

    up = 1;
}

void collect_dollar(void)
{
    eat = 1;
    lcd_cmd(0x80);
    lcd_write("     ");
    delay(5);
}

void go_down()
{
    lcd_cmd(0x80+0x04);
    lcd_write(" ");         // clears nervous
    delay(5);
    lcd_cmd(0xC0+0x04);
    lcd_data(SMILE);        // down
    delay(5);
    up = 0;
}

void print_score(void)
{
    itoa(score,score_string,10);
    lcd_cmd(0x80+0x0D);
    lcd_write(score_string);
    delay(5);
}

void increase_speed()
{
    incr=MAX(((74-4*num)/140),0.1);
    num = num + incr;       // increment = 0.5 for num=1, 0.1 for num>=15
    reload = 16000000/num-1;                // integer
    NVIC_ST_RELOAD_R = reload; // one second delay relaod value
}

void collision(void)
{
    over = 1;
    lcd_cmd(0xC0+0x04);
    lcd_data(SAD);
    delay(5);
}

void Calculate_highest(void)
{
    score_rom[0]=score;
    SysCtlClockSet(SYSCTL_SYSDIV_5|SYSCTL_USE_PLL|SYSCTL_XTAL_16MHZ|SYSCTL_OSC_MAIN);
    SysCtlDelay(20000000);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_EEPROM0);
    EEPROMInit();
    EEPROMRead(pui32Read, 0x0, sizeof(pui32Read));
    if(score_rom[0]>pui32Read[0])
    {
        EEPROMProgram(score_rom, 0x0, sizeof(score_rom));
        lcd_cmd(0x01);
        delay(10);
        lcd_cmd(0x80);
        lcd_write("Congratulations!");
        delay(2000);
        lcd_cmd(0xC0);
        lcd_write("*New High Score*");
        delay(6000);
    }
    EEPROMRead(pui32Read, 0x0, sizeof(pui32Read));
    itoa(pui32Read[0],HS_string,10);
}

void Disp_gameover(void)
{
    lcd_cmd(0x01);
    lcd_cmd(0x80);
    lcd_write("  GAME OVER! ");
    lcd_data(SAD);
    lcd_cmd(0xC0);
    lcd_write("Sc:");
    lcd_write(score_string);
    lcd_cmd(0xC0+0x08);
    lcd_write("HS:");
    lcd_write(HS_string);
    delay(1000);
}

void Clear_memory(void)
{
    init_rom[0]=0;
    SysCtlClockSet(SYSCTL_SYSDIV_5|SYSCTL_USE_PLL|SYSCTL_XTAL_16MHZ|SYSCTL_OSC_MAIN);
    SysCtlDelay(20000000);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_EEPROM0);
    EEPROMInit();
    EEPROMMassErase();
    EEPROMProgram(init_rom, 0x0, sizeof(init_rom));
    lcd_cmd(0x01);
    delay(50);
    lcd_cmd(0x80);
    lcd_write(" Highest score ");
    delay(10);
    lcd_cmd(0xC0);
    lcd_write("    Cleared!    ");
    delay(10);
}
