#ifndef __SCA_H__
#define __SCA_H__

#include <stdint.h>

#define SCA_TX_KEYWORD  "SCA_TX:"
#define SCA_RX_KEYWORD  "SCA_RX:"

// Indicate data type in the buffer
enum sca_data_type{
    SCA_UINT32,
    SCA_UINT16,
    SCA_UINT8,
    SCA_CHAR
};

// Stores data for inputs and measurements
struct sca_data {
    uint8_t*            data;
    enum sca_data_type  type;
    uint32_t            count;
    uint32_t            len_bytes;
};

struct sca_context {
    // Buffer for inputs and output measurements
    struct sca_data     inputs;
    struct sca_data     meas;
    uint32_t            time;

    // Indices of next input, output in buffer
    uint32_t            input_idx;
    uint32_t            meas_idx;

    // Keywords for the UART communication (change in case the user needs to change it)
    char*               tx_keyword;
    uint32_t            tx_keyword_len;
    char*               rx_keyword;
    uint32_t            rx_keyword_len;

    uint8_t             rx_flag;

    // Callback functions
    void (*uart_tx_callback)(char*, int len);
};

void sca_init(
    struct sca_context* ctx,
    uint8_t* inp_buf,
    uint32_t inp_buf_len,
    enum sca_data_type inp_dtype,
    uint8_t* meas_buf,
    uint32_t meas_buf_len,
    enum sca_data_type meas_dtype
);

void sca_reset(struct sca_context* ctx);

void sca_add_input(struct sca_context* ctx, uint32_t inp);

void sca_add_meas(struct sca_context* ctx, uint32_t inp);

void sca_set_meas_string(struct sca_context* ctx, char* inp, uint32_t len);

uint8_t sca_rx_parse(struct sca_context* ctx, char* str, uint32_t strlen);

uint8_t sca_check_received(struct sca_context* ctx);

uint8_t sca_check_input_available(struct sca_context* ctx);

uint32_t sca_get_next_inp(struct sca_context* ctx);

uint32_t sca_set_time(struct sca_context* ctx, uint32_t time);

void sca_tx(struct sca_context* ctx);

#endif
