#include <string.h>
#include <inc/tm4c129encpdt.h>

#include "sca.h"

void init_gpio();

void init_uart();

void init_timer();

void uart_log(const char* inp, int len);

uint32_t get_timer_val();

char    key[100]    = "password";
int     key_len     = -1;

int check_pass1(char *inp, char inp_len){
    if(key_len == -1)
        return -1;

    if(key_len != inp_len){
        return 0;
    }
    else{
        for(int i=0; i<key_len; i++)
            if(key[i] != inp[i])
                return 0;
    }
    return -1;
}

int check_pass2(char *inp, char inp_len){
    if(key_len == -1)
        return 0;

    uint8_t flag = -1;

    for(int i=0; i<key_len; i++)
        if(key[i] != inp[i])
            flag = 0;
        else
            flag = -1;

    return flag;
}

int check_pass3(char *inp, char inp_len){
    if(key_len == -1)
        return 0;

    uint8_t flag = -1;

    for(int i=0; i<key_len; i++)
        flag = (flag && (inp[i] == key[i]));

    return flag;
}

int check_pass4(char *inp, char inp_len){
    if(key_len == -1)
        return 0;

    uint8_t flag = -1;

    for(int i=0; i<key_len; i++)
        flag = (flag & (inp[i] == key[i]));

    return flag;
}

char str[50];
int idx = 0;

int main(void) {
    key_len = strlen(key);

    init_gpio();
    init_uart();
    init_timer();

    while(1) {
        GPIO_PORTA_AHB_DATA_R |= 0x40;              // Turn LED ON
        for(int i = 0; i < 100; i++);

        uint8_t flag = check_pass1(str, idx);

        GPIO_PORTA_AHB_DATA_R &= ~0x40;             // Turn LED OFF
        for(int i = 0; i < 100; i++);
    }

	return 0;
}

int keyset_parse(char* uart_buf, int uart_idx) {
    const char* keyset_command = "KEY:";
    int keyset_command_len = strlen(keyset_command);

    int idx = 0;

    while(idx < keyset_command_len && idx < uart_idx)
        if(uart_buf[idx] == keyset_command[idx])
            idx++;
        else
            return 0;

    for(int i = 0; i < 100; i++)
        key[i] = 0;

    while(idx < uart_idx) {
        key[idx - keyset_command_len] = uart_buf[idx];
        idx++;
    }

    key_len = uart_idx - keyset_command_len;

    const char* log_line = "Key was set.\n";
    uart_log(log_line, strlen(log_line));

    return 1;
}

void UART0_Int_Handler() {
    static char    uart_buf[100];       // String received from UART
    static short   uart_idx = 0;        // UART index
    char ch_rd;

    if(UART0_FR_R & 0x40)
        ch_rd = UART0_DR_R;
    else
        return;

    if(ch_rd == '\r') {
        int flag = keyset_parse(uart_buf, uart_idx);

        if(!flag) {
            int i = 0;
            for(i = 0; i < uart_idx && i < 50; i++)
                str[i] = uart_buf[i];
            for(;i < 50; i++)
                str[i] = 0;
            idx = uart_idx;
        }

        while(UART0_FR_R & 0x20);
        UART0_DR_R = '\n';

        while(UART0_FR_R & 0x20);
        UART0_DR_R = '\r';

        uart_idx = 0;
    }
    else {
        if(uart_idx >= 100)
            return;

        while(UART0_FR_R & 0x20);
        UART0_DR_R = ch_rd;

        uart_buf[uart_idx] = ch_rd;
        uart_idx++;
    }
}

void init_gpio() {
    SYSCTL_RCGCGPIO_R   |= 1;               // Enable PORTA clock

    GPIO_PORTA_AHB_AFSEL_R  = 0x00;
    GPIO_PORTA_AHB_DIR_R    = 0x40;
    GPIO_PORTA_AHB_DEN_R    = 0x40;
    GPIO_PORTA_AHB_ODR_R    = 0x00;
}

void init_uart() {
    SYSCTL_RCGCUART_R   |= 1;               // Enable UART0 clock
    SYSCTL_RCGCGPIO_R   |= 1;               // Enable PORTA clock

    for(int i = 0; i < 100; i++);

    UART0_CTL_R         = 0;

    GPIO_PORTA_AHB_AFSEL_R  |= 0x03;            // Set PA0, PA1 to alternate functions
    GPIO_PORTA_AHB_DEN_R    |= 0x03;            // Set PA0, PA1 to digital
    GPIO_PORTA_AHB_AMSEL_R  = 0;
    GPIO_PORTA_AHB_PCTL_R   |= 0x0011;          // Set PA0 to U0Rx, PA1 to U0Tx functions

    UART0_IBRD_R        = 8;                // Integer part of clock divider    = 8 (115200 baud)
    UART0_FBRD_R        = 44;               // Fractional part of clock divider = 0.6805 * 64 + 0.5 = 44.055 (115200 baud)

    UART0_CC_R          = 0;                // Use system clock

    UART0_LCRH_R        = 0x60;             // Line control : 1 stop bit, no interrupt, no parity, no FIFO

    UART0_CTL_R         = 0x0301;           // Enable UART Tx and Rx

    UART0_IM_R          = 0x10;             // Enable interrupt on rx
    NVIC_PRI1_R = (NVIC_PRI7_R & 0xFFFF1FFF) | 0x0000A000;  // Priority level 5
    NVIC_EN0_R  = NVIC_EN0_R | 0x00000020;
}

void init_timer() {
    SYSCTL_RCGCTIMER_R = 1;                         // Enable clock to Timer0
    for(int i = 0; i < 100; i++);

    TIMER0_CTL_R    = 0;                            // Disable timer
    TIMER0_CFG_R    = 0;                            // 32-bit mode,
    TIMER0_TAMR_R   = 0x00000011;                   // One-shot mode
    TIMER0_TAILR_R  = 0xFFFFFFFF;                   // Max count
    TIMER0_TAV_R    = 0;
}

void uart_send_byte(char inp) {
    while(UART0_FR_R & 0x20);
    UART0_DR_R = inp;
    while(UART0_FR_R & 0x20);
}

void uart_log(const char* inp, int len) {
    int idx = 0;
    while(inp[idx] != '\0' && idx < len) {
        uart_send_byte(inp[idx++]);
    }
}
