#include "declarations.h"

void Init_SSI0(void)
{
    SYSCTL_RCGCSSI_R |= 0x01;  // activate SSI0
    SYSCTL_RCGCGPIO_R |= 0x01; // activate port A

    SSI0_CR1_R &= ~SSI_CR1_SSE;           // disable SSI//This bit must be cleared before any control registers are reprogrammed
    SSI0_CR1_R &= ~SSI_CR1_MS;            // master mode//The SSI is configured as a master

    SSI0_CR0_R &= ~(SSI_CR0_SCR_M |       // SCR = 0 (1.6 Mbps data rate)
                    SSI_CR0_SPH |         // SPH = 0
                    SSI_CR0_SPO);         // SPO = 0 ; FRF = Freescale format ; DSS = 16-bit data//0xffff003f

    SSI0_CR0_R = (SSI0_CR0_R & ~SSI_CR0_FRF_M) + SSI_CR0_FRF_MOTO;//0xffff000f//selecting free scale format
    SSI0_CR0_R = (SSI0_CR0_R & ~SSI_CR0_DSS_M) + SSI_CR0_DSS_16;// 0xffff000f//selecting data width
    SSI0_CPSR_R = (SSI0_CPSR_R & ~SSI_CPSR_CPSDVSR_M) + 10;// clock divider for 1.6 MHz SSIClk (assumes 16 MHz PLL)
    SSI0_CR1_R |= SSI_CR1_SSE;            // enable SSI
    //programmed SSI0 to Free scale format, 16bit transfer, 0 polarity and 0 phase, clock speed 1.6MHz
}

void SSI0_Write(uint16_t data)
{
    DisableInterrupts();
    GPIO_PORTA_DATA_R &= ~0x08; /* assert SS low */ //0000 1000 //choosing SSI0

    while ((SSI0_SR_R & 2) == 0); /* wait until FIFO not full */

    SSI0_DR_R = data; /* transmit high byte */

    while (SSI0_SR_R & 0x10); /* wait until transmit complete */

    GPIO_PORTA_DATA_R |= 0x08; /* keep SS idle high */
    EnableInterrupts();
}

void DisableInterrupts(void)
{
    __asm ("CPSID  I\n");
}


void EnableInterrupts(void)
{
    __asm ("CPSIE  I\n");
}

