#include "declarations.h"


//Function to set the display status based on commands from UART/Keypad
void set_display_status(char *buffer1)
{
    PortF_SW1_INTR = 0;
    UART_INTR_flag=0;
    Keypad_INTR_flag=0;
    write('\n');

    if(SCROLL_LEFT)
    {
        scroll_flag = 1;
    }
    else if(SCROLL_RIGHT)
    {
        scroll_flag = 2;
    }
    else if(SCROLL_OFF)
    {
        scroll_flag = 0;
    }
    else if(SWITCH_STRING)
    {
        indx++;
        if(indx>=6)
            indx=0;
        encode_char();
    }
    else if(INCREASE_BRIGHTNESS)
    {
        intensity += 5;
        if (intensity >= 0xf)
            intensity = 0xf;
        uint16_t data = 0x0a00 | intensity;
        SSI0_Write(data);
    }
    else if(DECREASE_BRIGHTNESS)
    {
        intensity -= 5;
        if (intensity >= 0x0f)
            intensity = 0;
        uint16_t data = 0x0a00 | intensity;
        SSI0_Write(data);
    }
    else if(DECREASE_SPEED)
    {
            speed+=10;
    }
    else if(INCREASE_SPEED)
    {
        speed-=10;
        if(speed<=0)
            speed=3;
    }
    else if(GET_DATA)
    {
        strncpy(string[indx],&buffer1[5],strlen(buffer1)-5);
        encode_char();
    }
    else if(BLINK_ON)
    {
        blink_flag = 1;
    }
    else if(BLINK_OFF)
    {
        blink_flag = 0;
    }

    input = '0';buffer1[0] = 'x';
}
