#include "declarations.h"

void scroll_data(void)
{
    int n = strlen(string[indx]);

    uint8_t array1[n];
    unsigned char savedcarry, carry;
    for (int j = 0; j < 8; j++)             //For all the 8 rows
    {
        for (int i = 0; i < n; i++)
        {
            int temp = n*j + i;             //get indices of first row
            array1[i] = encoded_data[temp]; //copy original first row data
        }

        //Left shift the data
        if(scroll_flag == 1)
         {
            carry = array1[n - 1] & 1;          //Save the right most bit of last character

            // loop through the array1 applying bit shift
            for (int i = 0; i < n; i++)
            {
                savedcarry = array1[i] & 1;        //Save the right most bit of current character
                array1[i] = array1[i] >> 1;        // right shift
                if (carry)
                {
                    array1[i] |= (unsigned char) 0x80; //Update the left most bit of current character
                }
                carry = savedcarry;                //Save the right most bit of current character
            }
        }

        //Right shift the data
        if(scroll_flag == 2)
        {
            carry = array1[0] & 0x80;             //Save the left most bit of first character

            // loop through the array1 applying bit shift
            for (int i = n-1; i >= 0; i--)
            {
                savedcarry = array1[i] & 0x80;    // save the left most bit
                array1[i] = array1[i] << 1;       // left shift
                if (carry)
                {
                    array1[i] |= (unsigned char) 0x01; //Update the left most bit of current character
                }
                carry = savedcarry;               //Save the right most bit of current character
            }
        }


        //Updated the shifted data
        for (int i = 0; i < n; i++)
        {
            int temp = n*j + i;
            encoded_data[temp] = array1[i];
        }
    }
}

