#include <stdio.h>
#include <stdint.h>
#include "tm4c123gh6pm.h"
#include "declarations.h"


char buffer[100] , scroll_flag=0xff;
char string[6][100] = { "Hai$","Welcome to E3-257:Embedded Systems Design-1    ","DESE","IISc","OK +","Bye^"};

uint8_t encoded_data[80] , intensity=0x0f;
char val;
int indx = 0, speed=20, input;
int PortF_SW1_INTR=0 , PortF_SW2_INTR=0 , UART_INTR_flag=0 , Keypad_INTR_flag = 0 , blink_flag=0;

int main(void)
{
    //Initialization of UART0
    Init_UART0();

    //Initialization of Ports C, E, F
    Init_PortF();
    init_ports_ACE();

    //Initialization of SSI0
    Init_SSI0();

    //Initialization of Dot Matrix display
    Init_Dot_Matrix();

    //encoding given characters
    encode_char();

    //Valid UART commands used here
    display("Enter one of the commands:");
    display("1. scroll left");
    display("2. scroll right");
    display("3. scroll off");
    display("4. dim");
    display("5. bright");
    display("6. change");
    display("7. inc speed");
    display("8. dec speed");
    display("9. blink on");
    display("10. blink off");
    display("\n\r");

    while (1)
    {
        if(PortF_SW2_INTR == 1)
        {
            PortF_SW2_INTR = 0;
            uint16_t data = 0x0a00 | intensity;//If Port F interrupts used to change brightness
            SSI0_Write(data);
        }

        if( (PortF_SW1_INTR==1) | (UART_INTR_flag == 1) | (Keypad_INTR_flag == 1))
            set_display_status(buffer); //If UART or Keypad OR PortF_SW1 is used

        scroll_data();                  //Update the encoded data (if data scrolled)
        write_led_data();               //Write data onto the display
    }
}
