#include <stdio.h>
#include <stdint.h>
#include "tm4c123gh6pm.h"
#include <string.h>

/* Macros to detect keypad key press  */
#define  ROW_1        (GPIO_PORTE_DATA_R = 0xFE)
#define  ROW_2        (GPIO_PORTE_DATA_R = 0xFD)
#define  ROW_3        (GPIO_PORTE_DATA_R = 0xFB)
#define  ROW_4        (GPIO_PORTE_DATA_R = 0xF7)
#define  COL_1        (GPIO_PORTC_DATA_R & (1<<4))
#define  COL_2        (GPIO_PORTC_DATA_R & (1<<5))
#define  COL_3        (GPIO_PORTC_DATA_R & (1<<6))
#define  COL_4        (GPIO_PORTC_DATA_R & (1<<7))

/*Macros to set the display status */
#define  SCROLL_LEFT            !strcmp(buffer1,"scroll left") | (input == 'L')
#define  SCROLL_RIGHT           !strcmp(buffer1,"scroll right") | (input == 'R')
#define  SCROLL_OFF             !strcmp(buffer1,"scroll off")  | (input == 'N')
#define  SWITCH_STRING          !strcmp(buffer1,"change")  | (input == 'C') | (PortF_SW1_INTR == 1)
#define  INCREASE_BRIGHTNESS    !strcmp(buffer1,"bright") | (input == 'B')
#define  DECREASE_BRIGHTNESS    !strcmp(buffer1,"dim") | (input == 'D')
#define  DECREASE_SPEED         !strcmp(buffer1,"dec speed") | (input == 'd')
#define  INCREASE_SPEED         !strcmp(buffer1,"inc speed") | (input == 'i')
#define  BLINK_ON               !strcmp(buffer1,"blink on") | (input == 'O')
#define  BLINK_OFF              !strcmp(buffer1,"blink off") | (input == 'F')
#define  GET_DATA               strstr(buffer1,"data")
#define  KEY_PRESSED             (input=='C')|(input=='B')|(input=='D')|(input=='L')|(input=='R')|\
                                (input=='N')|(input=='i')|(input=='d')|(input=='O')|(input == 'F')

/*Functions Used*/
void Init_SSI0(void);
void Init_Dot_Matrix(void);
void Init_UART0(void);
void init_ports_ACE(void);
void Init_PortF(void);


void WaitForInterrupt(void);
void DisableInterrupts(void);
void EnableInterrupts(void);


void UART0_Handler(void);
void GPIOPortC_Handler(void);
void GPIOPortF_Handler(void);


void delay_us(unsigned int n);
void delayms(int n);


void SSI0_Write(uint16_t data);
void encode_char(void);
void scroll_data(void);
void write_led_data();

unsigned char scan_keypad(void);
void write(char val);
void display(char a[30]);
void set_display_status(char *buffer1);


/*Variables Used*/
uint8_t encoded_data[80],intensity;

char scroll_flag, val;
char buffer[100],string[6][100];

int PortF_SW1_INTR , PortF_SW2_INTR , UART_INTR_flag , Keypad_INTR_flag  , blink_flag;
int speed, indx, i,input;

unsigned const char key[4][4];
char spl_chars[17];
unsigned char capital_alpha[26][8] , small_alpha[26][8] , space_char[8] , numbers[10][8] , special_char[17][8];
