#include "declarations.h"


void Init_UART0(void)
{
    SYSCTL_RCGCUART_R |= 0x00000001;      /* 1) Clock Enable for UART0*/
    SYSCTL_RCGCGPIO_R |= 0x00000001;      /* 2) activate clock for Port A */
    UART0_CTL_R |= 0x00000001;            /* 3) enabling UART */
    UART0_IBRD_R = 0x08;                  /* 4) IBRD = 08*/
    UART0_FBRD_R = 0x2C;                  /* 5) FBRD = 44*/
    UART0_LCRH_R = 0x60;                  /* 6) 1 stop bit, no FIFO, no interrupt, no parity, and 8-bit data size*/
    UART0_CTL_R |= 0x00000301;            /* 7) Enable Tx and Rx in UART0*/
    GPIO_PORTA_DEN_R |= 0x03;             /* 8) Enable digital I/O on PA1-0 */
    GPIO_PORTA_AMSEL_R = 0x00;            /* 9) Disable analog on PA */
    GPIO_PORTA_AFSEL_R = 0x03;            /*10) Enable alternate function on PA1-0 */
    GPIO_PORTA_PCTL_R = 0x00000011;       /*11) UART select number on PA1-0 */

    //Interrupt Enabling
    NVIC_EN0_R|=0x00000020;                 /*12)Enabling Interrupt for UART0*/
    NVIC_PRI1_R|=0x0000A000;              /*13)Priority 5 for UART console*/
    UART0_ICR_R = 0x00000010;
    UART0_IM_R|=0x00000010;               /*14)Enabling Interrupt for RXIM*/
 }

i=0;

//Function to write a character to the data register
void write(char val)
{
    while((UART0_FR_R&(1<<5))!=0); //Write data only when data register is empty
    UART0_DR_R=val;
}

//Function to display a string of maximum size 30, used for user interface
void display(char a[30])
{
    write('\r');
    write('\n');
    int x=0;
    while(a[x]!='\0')
    {
        write(a[x]);
        x++;
    }
}

//UART0 interrupt handler
void UART0_Handler(void)
{
    UART0_ICR_R = 0x00000010;
    val=UART0_DR_R;

    write(val);
    if(val ==13)
    {
        buffer[i] = '\0';
        UART_INTR_flag=1;i=0;
        if(!strcmp(buffer,"blink off"))
           blink_flag = 0;
    }
    else
    {
        buffer[i] = val;
        i++;
    }

    if(val == 8)    //Backspace
    {
        if(i > 0)
        {
            i--;
        }
        else
        {
            display("buffer empty\n\rstart again!");i=0;
        }
    }
}
