#include "declarations.h"

void Init_PortF(void)
{

    SYSCTL_RCGC2_R |= 0x0000003F; /* 1) activate clock for PortF */
    GPIO_PORTF_LOCK_R = 0x4C4F434B; /* 2) unlock GPIO PortF */
    GPIO_PORTF_CR_R = 0x1F; /* allow changes to PF4-0 */ //make port F configurable
    GPIO_PORTF_AMSEL_R = 0x00; /* 3) disable analog on PF */
    GPIO_PORTF_PCTL_R = 0x00000000; /* 4) PCTL GPIO on PF4-0 */
    GPIO_PORTF_DIR_R = 0x0E; /* 5) PF4,PF0 in, PF3-1 out */
    GPIO_PORTF_AFSEL_R = 0x00; /* 6) disable alt funct on PF7-0 */
    GPIO_PORTF_PUR_R = 0x11; /* enable pull-up on PF0 and PF4 */
    GPIO_PORTF_DEN_R = 0x1F; /* 7) enable digital I/O on PF4-0 */

    GPIO_PORTF_IS_R &= ~0x11; /*  PF4 is edge-sensitive */ //0 for edge sensitive
    GPIO_PORTF_IBE_R &= ~0x11; /*  PF4 is not both edges */ //
    GPIO_PORTF_IEV_R &= ~0x11; /*  PF4 falling edge event */ //0 for falling edge
    GPIO_PORTF_ICR_R = 0x11; /*  Clear flag4 */
    GPIO_PORTF_IM_R |= 0x11; /*  arm interrupt on PF4 */ //unmask interrupt
    NVIC_PRI7_R = (NVIC_PRI7_R & 0xFF1FFFFF) | 0x00600000; /*  priority 3 */
    NVIC_EN0_R = 0x40000000; /*  Enable interrupt 30 in NVIC */
}


void GPIOPortF_Handler(void)
{
    if ((GPIO_PORTF_MIS_R & 0x10))
    {
        GPIO_PORTF_ICR_R = 0x10;
        indx++;
        if (indx == 6)
        {
            indx = 0;
        }
        PortF_SW2_INTR=1;
    }
    else if ((GPIO_PORTF_MIS_R & 0x01))
    {
        GPIO_PORTF_ICR_R = 0x01;
        intensity += 5;
        if (intensity > 0xf)
            intensity = 0;
        PortF_SW1_INTR=1;
    }
}
