#include "declarations.h"

void init_ports_ACE()
{

    SYSCTL_RCGC2_R |= 0x0000003F; /* 1) activate clock to all Ports*/

    //Initialize Port A    (configure PA2,3,5 as SSI)
    GPIO_PORTA_AFSEL_R |= 0x2C;           // enable alt funct on PA2,3,5//clk cs dataout
    GPIO_PORTA_DEN_R |= 0x2C;             // enable digital I/O on PA2,3,5 ;
    GPIO_PORTA_PCTL_R = (GPIO_PORTA_PCTL_R & 0xFF0F00FF) + 0x00202200;
    GPIO_PORTA_AMSEL_R = 0;               // disable analog functionality on PA

    //Initialize Port C   (Keypad Column access)
    GPIO_PORTC_DIR_R &= ~0xF0;        /* 5) PF4,PF0 in, PF3-1 out */
    GPIO_PORTC_PUR_R = 0xF0;        /* enable pull-up on PF0 and PF4 */
    GPIO_PORTC_DEN_R = 0xF0;        /* 7) enable digital I/O on PF4-0 */
    GPIO_PORTC_DR8R_R = 0xF0;

    GPIO_PORTC_IS_R &= ~0xF0; /* PC7 to PC4 is edge-sensitive */
    GPIO_PORTC_IBE_R &= ~0xF0; /* PC7 to PC4 is not both edges */
    GPIO_PORTC_IEV_R &= ~0xF0; /* PC7 to PC4 falling edge event */
    GPIO_PORTC_ICR_R = 0xF0; /* Clear PC7 to PC4 */
    GPIO_PORTC_IM_R |= 0xF0; /* arm interrupt on PC4 to PC4 */
    NVIC_PRI0_R |= (NVIC_PRI0_R & 0xFF1FFFFF) | 0x00E00000; /* priority 4 */
    NVIC_EN0_R |= 0x00000004; /* Enable interrupt 2 in NVIC */


    //Initialize Port E   (Keypad Row access)
    GPIO_PORTE_DIR_R |=0x0F;
    GPIO_PORTE_DEN_R |=0x0F;
    GPIO_PORTE_ODR_R |= 0x0F; //enabling open drain configuration
    GPIO_PORTE_DATA_R |= 0x00;
}



void GPIOPortC_Handler(void)
{
  volatile int readback;
  input = scan_keypad(); /* read the keypad */

  GPIO_PORTE_DATA_R &= 0xF0;

  GPIO_PORTC_ICR_R = 0xF0; /* clear PC7 to PC4 int */
  if(KEY_PRESSED)
      Keypad_INTR_flag=1;
  if(input == 'F')
      blink_flag =0;

  readback = GPIO_PORTC_ICR_R; /* a read to force clearing of interrupt flag */
  readback = readback;
}

