/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PImage;

public class ImageManager {
    private static HashMap<String, PImage> textures = new HashMap();

    public static PImage loadImage(PApplet pApplet, String string) {
        if (textures.containsKey(string)) {
            return textures.get(string);
        }
        PImage pImage = pApplet.loadImage(string);
        if (pImage != null) {
            textures.put(string, pImage);
        } else {
            System.out.println("Unable to load image from file '" + string + "'");
        }
        return pImage;
    }

    public static PImage[] loadImage(PApplet pApplet, String[] stringArray) {
        PImage[] pImageArray = new PImage[stringArray.length];
        for (int i = 0; i < pImageArray.length; ++i) {
            pImageArray[i] = ImageManager.loadImage(pApplet, stringArray[i]);
        }
        return pImageArray;
    }

    public static PImage[][] makeTiles2D(PApplet pApplet, PImage pImage, int n, int n2) {
        PImage[][] pImageArray = new PImage[n][n2];
        int n3 = pImage.width / n;
        int n4 = pImage.height / n2;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                pImageArray[j][i] = pApplet.createImage(n3, n4, 2);
                pImageArray[j][i].copy(pImage, j * n3, i * n4, n3, n4, 0, 0, n3, n4);
            }
        }
        return pImageArray;
    }

    public static PImage[] makeTiles1D(PApplet pApplet, PImage pImage, int n, int n2) {
        PImage[] pImageArray = new PImage[n * n2];
        int n3 = pImage.width / n;
        int n4 = pImage.height / n2;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                pImageArray[n5] = pApplet.createImage(n3, n4, 2);
                pImageArray[n5].copy(pImage, j * n3, i * n4, n3, n4, 0, 0, n3, n4);
                ++n5;
            }
        }
        return pImageArray;
    }
}

