/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.GConstants;
import processing.core.PImage;

abstract class HotSpot
implements GConstants,
Comparable<HotSpot> {
    public final Integer id;
    public float x;
    public float y;

    public abstract boolean contains(float var1, float var2);

    protected HotSpot(int n) {
        this.id = Math.abs(n);
    }

    public void adjust(Object ... objectArray) {
    }

    @Override
    public int compareTo(HotSpot hotSpot) {
        return this.id.compareTo(hotSpot.id);
    }

    static class HSalpha
    extends HotSpot {
        private PImage image = null;
        private int offX;
        private int offY;

        protected HSalpha(int n, float f, float f2, PImage pImage, int n2) {
            super(n);
            this.image = pImage;
            this.x = f;
            this.y = f2;
            if (n2 == 3) {
                this.offX = -pImage.width / 2;
                this.offY = -pImage.height / 2;
            } else {
                this.offY = 0;
                this.offX = 0;
            }
        }

        @Override
        public void adjust(Object ... objectArray) {
            switch (objectArray.length) {
                case 3: {
                    this.image = (PImage)objectArray[2];
                }
                case 2: {
                    this.y = Float.valueOf(objectArray[1].toString()).floatValue();
                }
                case 1: {
                    this.x = Float.valueOf(objectArray[0].toString()).floatValue();
                }
            }
        }

        @Override
        public boolean contains(float f, float f2) {
            int n;
            int n2;
            float f3;
            return this.image != null && (f3 = (float)(this.image.get(n2 = Math.round(f - this.x) - this.offX, n = Math.round(f2 - this.y) - this.offY) >> 24 & 0xFF)) > 48.0f;
        }

        public String toString() {
            return "HS alpha [" + this.x + ", " + this.y + "]";
        }
    }

    static class HSmask
    extends HotSpot {
        private PImage mask = null;

        protected HSmask(int n, PImage pImage) {
            super(n);
            this.mask = pImage;
        }

        @Override
        public boolean contains(float f, float f2) {
            int n;
            float f3;
            return this.mask != null && (f3 = (float)((n = this.mask.get((int)f, (int)f2)) >> 24 & 0xFF)) > 0.0f && (n & 0xFFFFFF) == 0;
        }

        public String toString() {
            return "HS mask [" + this.x + ", " + this.y + "]";
        }
    }

    static class HScircle
    extends HotSpot {
        public float r;
        public float r2;

        public HScircle(int n, float f, float f2, float f3) {
            super(n);
            this.x = f;
            this.y = f2;
            this.r = f3;
            this.r2 = f3 * f3;
        }

        @Override
        public boolean contains(float f, float f2) {
            return (f - this.x) * (f - this.x) + (f2 - this.y) * (f2 - this.y) <= this.r2;
        }

        @Override
        public void adjust(Object ... objectArray) {
            switch (objectArray.length) {
                case 3: {
                    this.r = Float.valueOf(objectArray[2].toString()).floatValue();
                    this.r2 = this.r * this.r;
                }
                case 2: {
                    this.y = Float.valueOf(objectArray[1].toString()).floatValue();
                }
                case 1: {
                    this.x = Float.valueOf(objectArray[0].toString()).floatValue();
                }
            }
        }

        public String toString() {
            return "HS circle [" + this.x + ", " + this.y + "]  radius = " + this.r;
        }
    }

    static class HSarc
    extends HotSpot {
        public float sa;
        public float ea;
        public float r;
        public float r2;

        public HSarc(int n, float f, float f2, float f3, float f4, float f5) {
            super(n);
            this.x = f;
            this.y = f2;
            this.r = f3;
            this.r2 = f3 * f3;
            this.sa = f4;
            this.ea = f5;
        }

        @Override
        public boolean contains(float f, float f2) {
            if ((f - this.x) * (f - this.x) + (f2 - this.y) * (f2 - this.y) > this.r2) {
                return false;
            }
            float f3 = (float)Math.toDegrees(Math.atan2(f2 - this.y, f - this.x));
            if (f3 < 0.0f) {
                f3 += 360.0f;
            }
            if (f3 < this.sa) {
                f3 += 360.0f;
            }
            return f3 >= this.sa && f3 <= this.ea;
        }
    }

    static class HSrect
    extends HotSpot {
        public float w;
        public float h;

        public HSrect(int n, float f, float f2, float f3, float f4) {
            super(n);
            this.x = f;
            this.y = f2;
            this.w = f3;
            this.h = f4;
        }

        @Override
        public boolean contains(float f, float f2) {
            return f >= this.x && f2 >= this.y && f <= this.x + this.w && f2 <= this.y + this.h;
        }

        public String toString() {
            return "XY[ " + this.x + ", " + this.y + "]  WH[ " + this.w + ", " + this.h + "]";
        }
    }
}

