/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GAbstractControl;
import g4p_controls.GAbstractView;
import g4p_controls.GControlMode;
import peasy.PeasyCam;
import processing.core.PApplet;
import processing.core.PVector;
import processing.event.MouseEvent;

public class GViewPeasyCam
extends GAbstractView {
    protected PeasyCam pcam;

    public GViewPeasyCam(PApplet pApplet, float f, float f2, float f3, float f4, float f5) {
        this(pApplet, f, f2, f3, f4, new PVector(), f5);
    }

    public GViewPeasyCam(PApplet pApplet, float f, float f2, float f3, float f4, PVector pVector, float f5) {
        super(pApplet, f, f2, f3, f4);
        this.view = this.winApp.createGraphics((int)this.width, (int)this.height, "processing.opengl.PGraphics3D");
        this.is3D = true;
        this.pcam = new PeasyCam(pApplet, this.view, (double)pVector.x, (double)pVector.y, (double)pVector.z, (double)f5);
        this.pcam.setViewport((int)this.x, (int)this.y, (int)this.width, (int)this.height);
        this.view.beginDraw();
        this.view.background(0, 48.0f);
        this.view.endDraw();
        this.registeredMethods = 3;
        this.cursorOver = 1;
        G4P.registerControl(this);
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        boolean bl = this.isOver = this.currSpot >= 0;
        if (this.viewListener == null) {
            return;
        }
        if (this.isOver || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getAction()) {
            case 6: {
                if (!this.isOver) break;
                this.isOver = true;
                this.pisOver = true;
                this.viewListener.processEvent(this.convertEvent(mouseEvent, 6, this.ox, this.oy));
                break;
            }
            case 7: {
                if (!this.isOver) break;
                this.isOver = false;
                this.pisOver = false;
                this.viewListener.processEvent(this.convertEvent(mouseEvent, 7, this.ox, this.oy));
                break;
            }
            case 3: {
                if (!this.isOver) break;
                this.viewListener.processEvent(this.convertEvent(mouseEvent, 3, this.ox, this.oy));
                break;
            }
            case 4: 
            case 5: {
                if (this.pisOver == this.isOver) break;
                this.pisOver = this.isOver;
                if (this.isOver) {
                    this.viewListener.processEvent(this.convertEvent(mouseEvent, 6, this.ox, this.oy));
                    break;
                }
                this.viewListener.processEvent(this.convertEvent(mouseEvent, 7, this.ox, this.oy));
            }
        }
    }

    @Override
    public PeasyCam getPeasyCam() {
        return this.pcam;
    }

    @Override
    public void moveTo(float f, float f2) {
        this.moveTo(f, f2, G4P.control_mode);
    }

    @Override
    public void moveTo(float f, float f2, GControlMode gControlMode) {
        GAbstractControl gAbstractControl = this.parent;
        if (gAbstractControl != null) {
            f -= gAbstractControl.width / 2.0f;
            f2 -= gAbstractControl.height / 2.0f;
        }
        switch (gControlMode) {
            case CORNER: 
            case CORNERS: {
                this.cx += f - this.x;
                this.cy += f2 - this.y;
                this.x = this.cx - this.width / 2.0f;
                this.y = this.cy - this.height / 2.0f;
                break;
            }
            case CENTER: {
                this.cx = f;
                this.cy = f2;
                this.x = this.cx - this.width / 2.0f;
                this.y = this.cy - this.height / 2.0f;
            }
        }
        this.pcam.setViewport((int)this.x, (int)this.y, (int)this.width, (int)this.height);
    }

    @Override
    public void setRotation(float f) {
    }

    @Override
    public void setRotation(float f, GControlMode gControlMode) {
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.pcam.setActive(bl);
    }

    @Override
    public void setAlpha(int n) {
        if (this.alphaLevel != (n = Math.abs(n) % 256)) {
            this.alphaLevel = n;
            this.available = this.alphaLevel >= 128;
            this.pcam.setActive(this.available);
            this.bufferInvalid = true;
        }
    }

    @Override
    public void setAlpha(int n, boolean bl) {
        this.setAlpha(n);
    }
}

