/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GAbstractControl;
import g4p_controls.GClip;
import g4p_controls.GControlMode;
import g4p_controls.GEditableTextControl;
import g4p_controls.GEvent;
import g4p_controls.GScrollbar;
import g4p_controls.HotSpot;
import g4p_controls.StyledString;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.util.LinkedList;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.event.KeyEvent;
import processing.event.MouseEvent;

public class GTextField
extends GEditableTextControl {
    private boolean showAsValid = true;
    private boolean valid = false;
    private float floatLow = -3.4028235E38f;
    private float floatHigh = Float.MAX_VALUE;
    private float floatInvalid = 0.0f;
    private float floatValue = 0.0f;
    private int intLow = Integer.MIN_VALUE;
    private int intHigh = Integer.MAX_VALUE;
    private int intInvalid = 0;
    private int intValue = 0;
    private int filter = -1;

    public GTextField(PApplet pApplet, float f, float f2, float f3, float f4) {
        this(pApplet, f, f2, f3, f4, 0);
    }

    public GTextField(PApplet pApplet, float f, float f2, float f3, float f4, int n) {
        super(pApplet, f, f2, f3, f4, n);
        this.children = new LinkedList();
        this.ty = 2.0f;
        this.tx = 2.0f;
        this.tw = this.width - 4.0f;
        this.th = this.height - (float)((this.scrollbarPolicy & 2) != 0 ? 11 : 0);
        this.wrapWidth = Integer.MAX_VALUE;
        this.gpTextDisplayArea = new GeneralPath();
        this.gpTextDisplayArea.moveTo(0.0f, 0.0f);
        this.gpTextDisplayArea.lineTo(0.0f, this.th);
        this.gpTextDisplayArea.lineTo(this.tw, this.th);
        this.gpTextDisplayArea.lineTo(this.tw, 0.0f);
        this.gpTextDisplayArea.closePath();
        this.hotspots = new HotSpot[]{new HotSpot.HSrect(1, this.tx, this.ty, this.tw, this.th), new HotSpot.HSrect(9, 0.0f, 0.0f, this.width, this.height)};
        G4P.pushStyle();
        G4P.showMessages = false;
        this.z = 0;
        G4P.control_mode = GControlMode.CORNER;
        if ((this.scrollbarPolicy & 2) != 0) {
            this.hsb = new GScrollbar(pApplet, 0.0f, 0.0f, this.tw, 10.0f);
            this.addControl(this.hsb, this.tx, this.ty + this.th - this.hsb.halfHeight + 2.0f, 0.0f);
            this.hsb.addEventHandler(this, "hsbEventHandler");
            this.hsb.setAutoHide(this.autoHide);
        }
        G4P.popStyle();
        this.setText("");
        this.createEventHandler(G4P.sketchWindow, "handleTextEvents", new Class[]{GEditableTextControl.class, GEvent.class}, new String[]{"textcontrol", "event"});
        this.registeredMethods = 15;
        this.localFont = G4P.inputFont;
        this.bufferInvalid = true;
        G4P.registerControl(this);
    }

    @Override
    public void setStyledText(StyledString styledString) {
        this.cancelSelection();
        this.stext = styledString.convertToSingleLineText();
        this.stext.getLines(this.buffer.g2);
        if (this.stext.getNbrLines() > 0) {
            this.endTLHI.tli = this.stext.getLines(this.buffer.g2).getFirst();
            this.endTLHI.thi = this.endTLHI.tli.layout.getNextLeftHit(1);
            this.startTLHI.copyFrom(this.endTLHI);
            this.calculateCaretPos(this.endTLHI);
            this.keepCursorInView = true;
        }
        this.pty = 0.0f;
        this.ptx = 0.0f;
        if (this.hsb != null) {
            if (this.stext.getMaxLineLength() < this.tw) {
                this.hsb.setValue(0.0f, 1.0f);
            } else {
                this.hsb.setValue(0.0f, this.tw / this.stext.getMaxLineLength());
            }
        }
        this.testValidity(this.stext.getPlainText());
        this.bufferInvalid = true;
    }

    @Override
    public void setText(String string) {
        if (string != null) {
            this.cancelSelection();
            this.stext.setText(string, Integer.MAX_VALUE);
            this.setScrollbarValues(0.0f, 0.0f);
            this.bufferInvalid = true;
            this.testValidity(this.stext.getPlainText());
        }
    }

    public void setNumeric(int n, int n2, int n3) {
        this.filter = 0;
        this.intLow = Math.min(n, n2);
        this.intHigh = Math.max(n, n2);
        this.intInvalid = n3;
        this.testValidity(this.stext.getPlainText());
    }

    public void setNumeric(float f, float f2, float f3) {
        this.filter = 1;
        this.floatLow = Math.min(f, f2);
        this.floatHigh = Math.max(f, f2);
        this.floatInvalid = f3;
        this.testValidity(this.stext.getPlainText());
    }

    public void setNumericType(int ... nArray) {
        int n = nArray == null || nArray.length == 0 ? -1 : nArray[0];
        switch (n) {
            case 0: {
                this.filter = 0;
                this.intLow = Integer.MIN_VALUE;
                this.intHigh = Integer.MAX_VALUE;
                this.intInvalid = 0;
                break;
            }
            case 1: 
            case 2: {
                this.filter = 1;
                this.floatLow = -3.4028235E38f;
                this.floatHigh = Float.MAX_VALUE;
                this.floatInvalid = 0.0f;
                break;
            }
            default: {
                this.filter = -1;
            }
        }
        this.testValidity(this.stext.getPlainText());
    }

    public int getValueI() {
        return this.valid ? this.intValue : this.intInvalid;
    }

    public float getValueF() {
        return this.valid ? this.floatValue : this.floatInvalid;
    }

    public boolean isValid() {
        return this.valid;
    }

    protected void cancelSelection() {
        this.startTLHI.cancelInfo();
        this.endTLHI.cancelInfo();
    }

    public void appendText(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        if (this.stext.insertCharacters(string, this.stext.length()) == 0) {
            return;
        }
        LinkedList<StyledString.TextLayoutInfo> linkedList = this.stext.getLines(this.buffer.g2);
        this.endTLHI.tli = linkedList.getLast();
        this.endTLHI.thi = this.endTLHI.tli.layout.getNextRightHit(this.endTLHI.tli.nbrChars - 1);
        this.startTLHI.copyFrom(this.endTLHI);
        this.calculateCaretPos(this.endTLHI);
        if (this.hsb != null) {
            float f = linkedList.getLast().layout.getVisibleAdvance();
            float f2 = this.stext.getMaxLineLength();
            float f3 = Math.min(1.0f, this.tw / f2);
            if (this.caretX < this.tw) {
                this.hsb.setValue(0.0f, f3);
            } else {
                this.hsb.setValue(f / f2, f3);
            }
            this.keepCursorInView = true;
        }
        this.bufferInvalid = true;
    }

    @Override
    public PGraphics getSnapshot() {
        this.updateBuffer();
        PGraphics pGraphics = this.winApp.createGraphics(this.buffer.width, this.buffer.height, "processing.awt.PGraphicsJava2D");
        pGraphics.beginDraw();
        pGraphics.image((PImage)this.buffer, 0.0f, 0.0f);
        if (this.hsb != null) {
            pGraphics.pushMatrix();
            pGraphics.translate(this.hsb.getX(), this.hsb.getY() - this.hsb.halfHeight + 4.0f);
            pGraphics.image((PImage)this.hsb.getBuffer(), 0.0f, 0.0f);
            pGraphics.popMatrix();
        }
        pGraphics.endDraw();
        return pGraphics;
    }

    @Override
    public void pre() {
        if (this.keepCursorInView) {
            boolean bl = false;
            float f = this.caretX - this.tw + 2.0f;
            if (this.endTLHI != null) {
                if (this.ptx > this.caretX) {
                    this.ptx -= this.getScrollAmount();
                    if (this.ptx < 0.0f) {
                        this.ptx = 0.0f;
                    }
                    bl = true;
                } else if (this.ptx < f) {
                    this.ptx += this.getScrollAmount();
                    if (this.ptx > f) {
                        this.ptx = f;
                    }
                    bl = true;
                }
                if (this.ptx > 0.0f && this.endTLHI.tli.layout.getAdvance() - this.ptx < this.tw - 2.0f) {
                    this.ptx = Math.max(0.0f, this.endTLHI.tli.layout.getAdvance() - this.tw - 2.0f);
                    bl = true;
                }
                if (bl && this.hsb != null) {
                    this.hsb.setValue(this.ptx / (this.stext.getMaxLineLength() + 4.0f));
                }
            }
            if (bl) {
                this.bufferInvalid = true;
            } else {
                this.keepCursorInView = false;
            }
        }
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.ox -= this.tx;
        this.oy -= this.ty;
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        if (this.currSpot == 1 || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getAction()) {
            case 1: {
                if (this.currSpot == 1) {
                    if (focusIsWith != this && this.z >= this.focusObjectZ()) {
                        this.keepCursorInView = true;
                        this.takeFocus();
                    }
                    this.dragging = false;
                    if (this.stext.getPlainText().equals("")) {
                        this.stext.setText(" ");
                    }
                    if (this.stext.getPlainText().equals(" ")) {
                        LinkedList<StyledString.TextLayoutInfo> linkedList = this.stext.getLines(this.buffer.g2);
                        this.startTLHI = new StyledString.TextLayoutHitInfo(linkedList.getFirst(), null);
                        this.startTLHI.thi = this.startTLHI.tli.layout.getNextLeftHit(1);
                        this.endTLHI = new StyledString.TextLayoutHitInfo(linkedList.getLast(), null);
                        int n = this.endTLHI.tli.layout.getCharacterCount();
                        this.endTLHI.thi = this.startTLHI.tli.layout.getNextRightHit(n - 1);
                    } else {
                        this.endTLHI = this.stext.calculateFromXY(this.buffer.g2, this.ox + this.ptx, this.oy + this.pty);
                        this.startTLHI = new StyledString.TextLayoutHitInfo(this.endTLHI);
                    }
                    this.calculateCaretPos(this.endTLHI);
                    this.bufferInvalid = true;
                    break;
                }
                if (focusIsWith != this) break;
                this.loseFocus(this.parent);
                break;
            }
            case 2: {
                this.dragging = false;
                this.bufferInvalid = true;
                break;
            }
            case 4: {
                if (focusIsWith != this) break;
                this.keepCursorInView = true;
                this.dragging = true;
                this.endTLHI = this.stext.calculateFromXY(this.buffer.g2, this.ox + this.ptx, this.oy + this.pty);
                this.calculateCaretPos(this.endTLHI);
                this.fireEvent(new Object[]{this, GEvent.SELECTION_CHANGED});
                this.bufferInvalid = true;
            }
        }
    }

    @Override
    public void keyEvent(KeyEvent keyEvent) {
        if (!(this.visible && this.enabled && this.textEditEnabled && this.available)) {
            return;
        }
        if (focusIsWith == this && this.endTLHI != null) {
            char c = keyEvent.getKey();
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getAction();
            boolean bl = keyEvent.isShiftDown();
            boolean bl2 = keyEvent.isControlDown();
            this.textChanged = false;
            this.keepCursorInView = true;
            int n3 = this.pos;
            int n4 = this.nbr;
            this.endChar = this.endTLHI.tli.startCharIndex + this.endTLHI.thi.getInsertionIndex();
            this.startChar = this.startTLHI != null ? this.startTLHI.tli.startCharIndex + this.startTLHI.thi.getInsertionIndex() : this.endChar;
            this.pos = this.endChar;
            this.nbr = 0;
            this.adjust = 0;
            if (this.endChar != this.startChar) {
                if (this.startChar < this.endChar) {
                    this.pos = this.startChar;
                    this.nbr = this.endChar - this.pos;
                } else if (this.startChar > this.endChar) {
                    this.pos = this.endChar;
                    this.nbr = this.startChar - this.pos;
                }
            }
            if (n3 >= 0 && (n3 != this.pos || n4 != this.nbr)) {
                this.fireEvent(new Object[]{this, GEvent.SELECTION_CHANGED});
            }
            if (n2 == 1) {
                this.keyPressedProcess(n, c, bl, bl2);
                this.setScrollbarValues(this.ptx, this.pty);
            } else if (n2 == 3) {
                this.keyTypedProcess(n, c, bl, bl2);
                this.setScrollbarValues(this.ptx, this.pty);
            }
            if (this.textChanged) {
                this.changeText();
                this.testValidity(this.stext.getPlainText());
                this.fireEvent(new Object[]{this, GEvent.CHANGED});
            }
        }
    }

    protected void testValidity(String string) {
        switch (this.filter) {
            case 0: {
                try {
                    this.intValue = Integer.parseInt(string);
                    this.valid = this.intValue >= this.intLow && this.intValue <= this.intHigh;
                }
                catch (NumberFormatException numberFormatException) {
                    this.valid = false;
                }
                break;
            }
            case 1: 
            case 2: {
                try {
                    this.floatValue = Float.parseFloat(string);
                    this.valid = this.floatValue >= this.floatLow && this.floatValue <= this.floatHigh;
                }
                catch (NullPointerException | NumberFormatException runtimeException) {
                    this.valid = false;
                }
                break;
            }
            default: {
                this.valid = true;
            }
        }
        this.showAsValid = this.valid || string.length() == 0 || string.equals(" ");
    }

    @Override
    public void hsbEventHandler(GScrollbar gScrollbar, GEvent gEvent) {
        this.keepCursorInView = false;
        this.ptx = this.hsb.getValue() * (this.stext.getMaxLineLength() + 4.0f);
        this.bufferInvalid = true;
    }

    @Override
    protected void keyPressedProcess(int n, char c, boolean bl, boolean bl2) {
        this.ksm.logKey(1);
        boolean bl3 = true;
        switch (n) {
            case 37: {
                this.moveCaretLeft(this.endTLHI);
                break;
            }
            case 39: {
                this.moveCaretRight(this.endTLHI);
                break;
            }
            case 36: {
                this.moveCaretStartOfLine(this.endTLHI);
                break;
            }
            case 35: {
                this.moveCaretEndOfLine(this.endTLHI);
                break;
            }
            case 65: {
                if (bl2) {
                    this.moveCaretStartOfLine(this.startTLHI);
                    this.moveCaretEndOfLine(this.endTLHI);
                    bl = true;
                    break;
                }
                bl3 = false;
                break;
            }
            case 67: {
                if (bl2) {
                    GClip.copy(this.getSelectedText());
                }
                bl3 = false;
                break;
            }
            case 86: {
                if (bl2) {
                    String string = GClip.paste();
                    string.replaceAll("\n", "");
                    if (string.length() <= 0) break;
                    this.ksm.logKey(string.length());
                    if (this.hasSelection()) {
                        this.stext.deleteCharacters(this.pos, this.nbr);
                    }
                    this.stext.insertCharacters(string, this.pos);
                    this.adjust = string.length();
                    this.textChanged = true;
                    break;
                }
                bl3 = false;
                break;
            }
            default: {
                bl3 = false;
            }
        }
        this.calculateCaretPos(this.endTLHI);
        if (bl3) {
            if (!bl) {
                this.startTLHI.copyFrom(this.endTLHI);
            }
            this.bufferInvalid = true;
        }
    }

    @Override
    protected void keyTypedProcess(int n, char c, boolean bl, boolean bl2) {
        this.ksm.logKey(1);
        char c2 = c;
        if (this.isDisplayable(c2)) {
            if (this.hasSelection()) {
                this.stext.deleteCharacters(this.pos, this.nbr);
            }
            this.stext.insertCharacters("" + c, this.pos);
            this.adjust = 1;
            this.textChanged = true;
        } else if (c == '\b') {
            if (this.hasSelection()) {
                this.stext.deleteCharacters(this.pos, this.nbr);
                this.adjust = 0;
                this.textChanged = true;
            } else if (this.stext.deleteCharacters(this.pos - 1, 1)) {
                this.adjust = -1;
                this.textChanged = true;
            }
        } else if (c == '\u007f') {
            if (this.hasSelection()) {
                this.stext.deleteCharacters(this.pos, this.nbr);
                this.adjust = 0;
                this.textChanged = true;
            } else if (this.stext.deleteCharacters(this.pos, 1)) {
                this.adjust = 0;
                this.textChanged = true;
            }
        } else if (c == '\n' || c == '\r') {
            this.fireEvent(new Object[]{this, GEvent.ENTERED});
            if (this.tabManager != null && this.tabManager.nextControl(this)) {
                this.startTLHI.copyFrom(this.endTLHI);
                return;
            }
        } else if (c == '\t' && this.tabManager != null) {
            boolean bl3;
            boolean bl4 = bl3 = bl ? this.tabManager.prevControl(this) : this.tabManager.nextControl(this);
            if (bl3) {
                this.startTLHI.copyFrom(this.endTLHI);
                return;
            }
        }
        if (this.stext.length() == 0) {
            this.stext.insertCharacters(" ", 0);
            ++this.adjust;
            this.textChanged = true;
        }
    }

    @Override
    protected boolean changeText() {
        if (!super.changeText()) {
            return false;
        }
        this.startTLHI.copyFrom(this.endTLHI);
        return true;
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        this.updateBuffer();
        this.winApp.pushStyle();
        this.winApp.pushMatrix();
        this.winApp.translate(this.cx, this.cy);
        this.winApp.rotate(this.rotAngle);
        this.winApp.pushMatrix();
        this.winApp.translate(-this.halfWidth, -this.halfHeight);
        this.winApp.imageMode(0);
        if (this.alphaLevel < 255) {
            this.winApp.tint(255, (float)this.alphaLevel);
        }
        this.winApp.image((PImage)this.buffer, 0.0f, 0.0f);
        if (focusIsWith == this && this.showCaret && this.endTLHI.tli != null) {
            Object object = this.endTLHI.tli.layout.getCaretInfo(this.endTLHI.thi);
            float f = -this.ptx + object[0];
            float f2 = -this.pty + this.endTLHI.tli.yPosInPara;
            float f3 = f2 - object[3] + object[5];
            if (f >= 0.0f && f <= this.tw && f2 >= 0.0f && f3 <= this.th) {
                this.winApp.strokeWeight(1.5f);
                this.winApp.stroke(this.valid ? this.palette[12].getRGB() : this.palette[14].getRGB());
                this.winApp.line(this.tx + f, this.ty + Math.max(0.0f, f2), this.tx + f, this.ty + Math.min(this.th, f3));
            }
        }
        this.winApp.popMatrix();
        if (this.children != null) {
            for (GAbstractControl gAbstractControl : this.children) {
                gAbstractControl.draw();
            }
        }
        this.winApp.popMatrix();
        this.winApp.popStyle();
    }

    @Override
    protected void updateBuffer() {
        if (this.bufferInvalid) {
            boolean bl;
            this.bufferInvalid = false;
            this.buffer.beginDraw();
            Graphics2D graphics2D = this.buffer.g2;
            graphics2D.setFont(this.localFont);
            LinkedList<StyledString.TextLayoutInfo> linkedList = this.stext.getLines(graphics2D);
            boolean bl2 = bl = this.promptText != null && !this.hasFocus() && (linkedList.isEmpty() || this.stext.getPlainText().equals("") || this.stext.getPlainText().equals(" "));
            if (bl) {
                linkedList = this.promptText.getLines(graphics2D);
            }
            if (this.opaque) {
                this.buffer.background(this.palette[6].getRGB());
            } else {
                this.buffer.background(this.buffer.color(255, 0));
            }
            this.buffer.translate(this.tx, this.ty);
            this.buffer.noStroke();
            this.buffer.fill(this.showAsValid ? this.palette[7].getRGB() : this.palette[2].getRGB());
            this.buffer.rect(-1.0f, -1.0f, this.tw + 2.0f, this.th + 2.0f);
            graphics2D.setClip(this.gpTextDisplayArea);
            this.buffer.translate(-this.ptx, -this.pty);
            if (this.hasFocus() && this.stext.getPlainText().equals(" ")) {
                linkedList = this.stext.getLines(this.buffer.g2);
                this.startTLHI = new StyledString.TextLayoutHitInfo(linkedList.getFirst(), null);
                this.startTLHI.thi = this.startTLHI.tli.layout.getNextLeftHit(1);
                this.endTLHI = new StyledString.TextLayoutHitInfo(linkedList.getLast(), null);
                int n = this.endTLHI.tli.layout.getCharacterCount();
                this.endTLHI.thi = this.startTLHI.tli.layout.getNextRightHit(n - 1);
            }
            StyledString.TextLayoutHitInfo textLayoutHitInfo = null;
            StyledString.TextLayoutHitInfo textLayoutHitInfo2 = null;
            if (this.hasSelection()) {
                if (this.endTLHI.compareTo(this.startTLHI) == -1) {
                    textLayoutHitInfo = this.endTLHI;
                    textLayoutHitInfo2 = this.startTLHI;
                } else {
                    textLayoutHitInfo = this.startTLHI;
                    textLayoutHitInfo2 = this.endTLHI;
                }
            }
            for (StyledString.TextLayoutInfo textLayoutInfo : linkedList) {
                TextLayout textLayout = textLayoutInfo.layout;
                this.buffer.translate(0.0f, textLayout.getAscent());
                if (!bl && this.hasSelection() && textLayoutInfo.compareTo(textLayoutHitInfo.tli) >= 0 && textLayoutInfo.compareTo(textLayoutHitInfo2.tli) <= 0) {
                    int n = textLayoutHitInfo.thi.getInsertionIndex();
                    int n2 = textLayoutHitInfo2.thi.getInsertionIndex();
                    graphics2D.setColor(this.palette[14]);
                    Shape shape = textLayout.getLogicalHighlightShape(n, n2);
                    graphics2D.fill(shape);
                }
                graphics2D.setColor(this.showAsValid ? this.palette[2] : this.palette[7]);
                textLayoutInfo.layout.draw(graphics2D, 0.0f, 0.0f);
                this.buffer.translate(0.0f, textLayout.getDescent() + textLayout.getLeading());
            }
            graphics2D.setClip(null);
            this.buffer.endDraw();
        }
    }
}

