/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GEvent;
import g4p_controls.GValueControl2D;
import g4p_controls.HotSpot;
import processing.core.PApplet;
import processing.core.PImage;
import processing.event.MouseEvent;

public class GSlider2D
extends GValueControl2D {
    static int DBORDER = 1;
    static int LBORDER = 3;
    static int BACK = 6;
    static int TBORDER = 15;
    static int TOFF = 3;
    static int TOVER = 11;
    static int TDOWN = 14;
    static int TDRAG = 15;
    static final float THUMB_SIZE = 10.0f;
    static final float HALF_THUMB_SIZE = 5.0f;
    static final float BORDER_WIDTH = 2.0f;
    protected float dragWidth;
    protected float dragHeight;
    protected float dragD;
    protected int downHotSpot = -1;
    protected int status = 0;
    protected float startXlimit = 0.0f;
    protected float endXlimit = 1.0f;
    protected float startYlimit = 0.0f;
    protected float endYlimit = 1.0f;

    public GSlider2D(PApplet pApplet, float f, float f2, float f3, float f4) {
        super(pApplet, f, f2, f3, f4);
        this.makeBuffer();
        if (this.width < 40.0f || this.height < 40.0f) {
            this.resize(PApplet.max((int)Math.round(this.width), (int)40), PApplet.max((int)Math.round(this.height), (int)40));
        }
        this.dragWidth = this.width - 10.0f - 4.0f;
        this.dragHeight = this.height - 10.0f - 4.0f;
        this.dragD = 7.0f;
        this.hotspots = new HotSpot[]{new HotSpot.HSrect(THUMB_SPOT, this.dragD - 5.0f + this.parametricPosX * this.dragWidth, this.dragD - 5.0f + this.parametricPosY * this.dragHeight, 10.0f, 10.0f), new HotSpot.HSrect(TRACK_SPOT, this.dragD, this.dragD, this.dragWidth, this.dragHeight)};
        this.z = 24;
        epsilon = 0.98f / PApplet.max((float)this.dragWidth, (float)this.dragHeight);
        this.opaque = true;
        this.createEventHandler(G4P.sketchWindow, "handleSlider2DEvents", new Class[]{GSlider2D.class, GEvent.class}, new String[]{"slider2d", "event"});
        this.registeredMethods = 7;
        this.cursorOver = 12;
        G4P.registerControl(this);
    }

    @Override
    protected void updateDueToValueChanging() {
        this.hotspots[0].x = this.dragD - 5.0f + this.parametricPosX * this.dragWidth;
        this.hotspots[0].y = this.dragD - 5.0f + this.parametricPosY * this.dragHeight;
    }

    public void setEasing(float f) {
        this.easing = f < 1.0f ? 1.0f : f;
    }

    public void setXlimits(int n, int n2) {
        this.startXlimit = n;
        this.endXlimit = n2;
        this.setEpsilon();
        this.valueType = 0;
        this.bufferInvalid = true;
    }

    public void setLimitsX(int n, int n2, int n3) {
        this.startXlimit = n2;
        this.endXlimit = n3;
        this.valueType = 0;
        this.setEpsilon();
        this.bufferInvalid = true;
        this.setValueX(n);
        this.updateDueToValueChanging();
    }

    public void setLimitsX(float f, float f2) {
        this.startXlimit = f;
        this.endXlimit = f2;
        if (this.valueType == 0) {
            this.valueType = 1;
            this.setPrecision(1);
        }
        this.setEpsilon();
        this.bufferInvalid = true;
    }

    public void setLimitsX(float f, float f2, float f3) {
        this.startXlimit = f2;
        this.endXlimit = f3;
        f = PApplet.constrain((float)f, (float)f2, (float)f3);
        if (this.valueType == 0) {
            this.valueType = 1;
            this.setPrecision(1);
        }
        this.setEpsilon();
        this.bufferInvalid = true;
        this.setValueX(f);
        this.updateDueToValueChanging();
    }

    public void setLimitsY(int n, int n2) {
        this.startYlimit = n;
        this.endYlimit = n2;
        this.setEpsilon();
        this.valueType = 0;
        this.bufferInvalid = true;
    }

    public void setLimitsY(int n, int n2, int n3) {
        this.startYlimit = n2;
        this.endYlimit = n3;
        this.valueType = 0;
        this.setEpsilon();
        this.bufferInvalid = true;
        this.setValueY(n);
        this.updateDueToValueChanging();
    }

    public void setLimitsY(float f, float f2) {
        this.startYlimit = f;
        this.endYlimit = f2;
        if (this.valueType == 0) {
            this.valueType = 1;
            this.setPrecision(1);
        }
        this.setEpsilon();
        this.bufferInvalid = true;
    }

    public void setLimitsY(float f, float f2, float f3) {
        this.startYlimit = f2;
        this.endYlimit = f3;
        f = PApplet.constrain((float)f, (float)f2, (float)f3);
        if (this.valueType == 0) {
            this.valueType = 1;
            this.setPrecision(1);
        }
        this.setEpsilon();
        this.bufferInvalid = true;
        this.setValueY(f);
        this.updateDueToValueChanging();
    }

    public void setValueX(float f) {
        if (this.valueType == 0) {
            f = Math.round(f);
        }
        float f2 = (f - this.startXlimit) / (this.endXlimit - this.startXlimit);
        this.parametricTargetX = f2 = PApplet.constrain((float)f2, (float)0.0f, (float)1.0f);
    }

    public void setValueY(float f) {
        if (this.valueType == 0) {
            f = Math.round(f);
        }
        float f2 = (f - this.startYlimit) / (this.endYlimit - this.startYlimit);
        this.parametricTargetY = f2 = PApplet.constrain((float)f2, (float)0.0f, (float)1.0f);
    }

    public void setValueXY(float f, float f2) {
        this.setValueX(f);
        this.setValueY(f2);
    }

    public float getValueXF() {
        return this.startXlimit + (this.endXlimit - this.startXlimit) * this.parametricPosX;
    }

    public int getValueXI() {
        return Math.round(this.getValueXF());
    }

    public String getValueXS() {
        return this.getNumericDisplayString(this.getValueXF());
    }

    public float getValueYF() {
        return this.startYlimit + (this.endYlimit - this.startYlimit) * this.parametricPosY;
    }

    public int getValueYI() {
        return Math.round(this.getValueYF());
    }

    public String getValueYS() {
        return this.getNumericDisplayString(this.getValueYF());
    }

    protected String getNumericDisplayString(float f) {
        String string = "";
        switch (this.valueType) {
            case 0: {
                string = String.format("%d", Math.round(f));
                break;
            }
            case 1: {
                string = String.format("%." + this.precision + "f", Float.valueOf(f));
                break;
            }
            case 2: {
                string = String.format("%." + this.precision + "e", Float.valueOf(f));
            }
        }
        return string.trim();
    }

    public void setPrecision(int n) {
        if ((n = PApplet.constrain((int)n, (int)1, (int)5)) < 1) {
            n = 1;
        }
        if (n != this.precision) {
            this.precision = n;
            this.setEpsilon();
            this.bufferInvalid = true;
        }
    }

    public void setNumberFormat(int n, int n2) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.valueType = n;
                break;
            }
            default: {
                this.valueType = 1;
            }
        }
        this.setPrecision(n2);
        this.bufferInvalid = true;
    }

    public void setNumberFormat(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.valueType = n;
                break;
            }
            default: {
                this.valueType = 1;
            }
        }
        this.bufferInvalid = true;
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        this.ox -= this.dragD;
        this.oy -= this.dragD;
        if (this.currSpot >= 0 || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getAction()) {
            case 1: {
                if (focusIsWith == this || this.currSpot <= -1 || this.z < this.focusObjectZ()) break;
                this.downHotSpot = this.currSpot;
                this.status = this.downHotSpot == THUMB_SPOT ? 2 : 0;
                this.offsetH = this.ox - this.parametricPosX * this.dragWidth;
                this.offsetV = this.oy - this.parametricPosY * this.dragHeight;
                this.takeFocus();
                this.bufferInvalid = true;
                this.fireEvent(new Object[]{this, GEvent.PRESSED});
                break;
            }
            case 3: {
                if (focusIsWith != this) break;
                this.parametricTargetX = this.ox / this.dragWidth;
                this.parametricTargetY = this.oy / this.dragHeight;
                this.dragging = false;
                this.status = 0;
                this.loseFocus(this.parent);
                this.bufferInvalid = true;
                this.fireEvent(new Object[]{this, GEvent.CLICKED});
                break;
            }
            case 2: {
                if (focusIsWith != this || !this.dragging) break;
                this.dragging = false;
                if (this.downHotSpot == THUMB_SPOT) {
                    this.mouseUpdateTargets();
                }
                this.status = 0;
                this.bufferInvalid = true;
                this.loseFocus(this.parent);
                this.fireEvent(new Object[]{this, GEvent.RELEASED});
                break;
            }
            case 4: {
                if (focusIsWith != this) break;
                this.status = 3;
                this.dragging = true;
                if (this.downHotSpot != THUMB_SPOT) break;
                this.mouseUpdateTargets();
                this.bufferInvalid = true;
                break;
            }
            case 5: {
                int n = this.status;
                this.status = this.currSpot == THUMB_SPOT ? 1 : 0;
                if (n == this.status) break;
                this.bufferInvalid = true;
            }
        }
    }

    private void mouseUpdateTargets() {
        this.parametricTargetX = this.ox / this.dragWidth;
        if (this.parametricTargetX < 0.0f) {
            this.parametricTargetX = 0.0f;
            this.offsetH = 0.0f;
        } else if (this.parametricTargetX > 1.0f) {
            this.parametricTargetX = 1.0f;
            this.offsetH = 0.0f;
        }
        this.parametricTargetY = this.oy / this.dragHeight;
        if (this.parametricTargetY < 0.0f) {
            this.parametricTargetY = 0.0f;
            this.offsetV = 0.0f;
        } else if (this.parametricTargetY > 1.0f) {
            this.parametricTargetY = 1.0f;
            this.offsetV = 0.0f;
        }
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        this.updateBuffer();
        this.winApp.pushStyle();
        this.winApp.pushMatrix();
        this.winApp.translate(this.cx, this.cy);
        this.winApp.rotate(this.rotAngle);
        this.winApp.pushMatrix();
        this.winApp.translate(-this.halfWidth, -this.halfHeight);
        this.winApp.imageMode(0);
        if (this.alphaLevel < 255) {
            this.winApp.tint(255, (float)this.alphaLevel);
        }
        this.winApp.image((PImage)this.buffer, 0.0f, 0.0f);
        this.winApp.popMatrix();
        this.winApp.popMatrix();
        this.winApp.popStyle();
    }

    @Override
    protected void updateBuffer() {
        if (this.bufferInvalid) {
            this.bufferInvalid = false;
            this.buffer.beginDraw();
            this.buffer.ellipseMode(3);
            this.buffer.rectMode(3);
            if (this.opaque) {
                this.buffer.background(this.palette[BACK].getRGB());
            } else {
                this.buffer.background(this.buffer.color(255, 0));
            }
            this.buffer.pushMatrix();
            float f = this.dragD + this.parametricPosX * this.dragWidth;
            float f2 = this.dragD + this.parametricPosY * this.dragHeight;
            this.buffer.stroke(this.palette[TBORDER].getRGB());
            this.buffer.strokeWeight(1.0f);
            this.buffer.line(0.0f, f2, this.width, f2);
            this.buffer.line(f, 0.0f, f, this.height);
            switch (this.status) {
                case 0: {
                    this.buffer.fill(this.palette[TOFF].getRGB());
                    break;
                }
                case 1: {
                    this.buffer.fill(this.palette[TOVER].getRGB());
                    break;
                }
                case 2: {
                    this.buffer.fill(this.palette[TDOWN].getRGB());
                    break;
                }
                case 3: {
                    this.buffer.fill(this.palette[TDRAG].getRGB());
                }
            }
            this.buffer.rect(f, f2, 10.0f, 10.0f);
            this.buffer.rectMode(1);
            this.buffer.noFill();
            this.buffer.stroke(this.palette[LBORDER].getRGB());
            this.buffer.strokeWeight(2.0f);
            this.buffer.rect(0.0f, 0.0f, this.width - 1.0f, this.height - 1.0f);
            this.buffer.stroke(this.palette[DBORDER].getRGB());
            this.buffer.strokeWeight(1.0f);
            this.buffer.rect(1.0f, 1.0f, this.width - 1.0f, this.height - 1.0f);
            this.buffer.popMatrix();
            this.buffer.endDraw();
        }
    }
}

