/*
 * Decompiled with CFR 0.152.
 */
package g4p_controls;

import g4p_controls.G4P;
import g4p_controls.GEvent;
import g4p_controls.GValueControl;
import g4p_controls.StyledString;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import processing.core.PApplet;
import processing.core.PImage;
import processing.event.MouseEvent;

public abstract class GLinearTrackControl
extends GValueControl {
    protected static float TINSET = 2.0f;
    protected static int THUMB_SPOT = 1;
    protected static int TRACK_SPOT = 2;
    protected float trackWidth;
    protected float trackLength;
    protected float trackDisplayLength;
    protected float trackOffset;
    protected int textOrientation = 0;
    protected int downHotSpot = -1;
    protected int status = 0;
    protected StyledString[] labels;
    protected boolean labelsInvalid = true;
    protected Font localFont = G4P.sliderFont;

    public GLinearTrackControl(PApplet pApplet, float f, float f2, float f3, float f4) {
        super(pApplet, f, f2, f3, f4);
    }

    public void setTextOrientation(int n) {
        switch (n) {
            case -1: 
            case 0: 
            case 1: {
                this.textOrientation = n;
                break;
            }
            default: {
                this.textOrientation = 0;
            }
        }
        this.bufferInvalid = true;
    }

    public void setTickLabels(String[] stringArray) {
        if (stringArray == null || stringArray.length < 2) {
            return;
        }
        for (String string : stringArray) {
            if (string != null && string.length() != 0) continue;
            return;
        }
        this.labels = new StyledString[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.labels[i] = new StyledString(stringArray[i]);
        }
        this.setStickToTicks(true);
        this.setNbrTicks(this.labels.length);
        this.startLimit = 0.0f;
        this.endLimit = this.nbrTicks - 1;
        this.valueType = 0;
        this.showLimits = false;
        this.showValue = false;
        this.bufferInvalid = true;
    }

    @Override
    public void setShowTicks(boolean bl) {
        super.setShowTicks(bl);
        float f = this.calcTrackOffset();
        if (f != this.trackOffset) {
            this.trackOffset = f;
            this.bufferInvalid = true;
        }
        this.bufferInvalid = true;
    }

    protected float calcTrackOffset() {
        return this.showTicks ? this.trackWidth + 2.0f : this.trackWidth / 2.0f + 2.0f;
    }

    public void setTrackOffset(float f) {
        this.trackOffset = f;
    }

    public float getTrackOffset() {
        return this.trackOffset;
    }

    @Override
    public String getValueS() {
        int n = Math.round(this.startLimit + (this.endLimit - this.startLimit) * this.parametricTarget);
        return this.labels == null ? this.getNumericDisplayString(this.getValueF()) : this.labels[n].getPlainText();
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        this.ox -= this.width / 2.0f;
        this.ox /= this.trackLength;
        if (this.currSpot >= 0 || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getAction()) {
            case 1: {
                if (focusIsWith == this || this.currSpot <= -1 || this.z < this.focusObjectZ()) break;
                this.downHotSpot = this.currSpot;
                this.status = this.downHotSpot == THUMB_SPOT ? 2 : 0;
                this.offset = this.ox + 0.5f - this.parametricPos;
                this.takeFocus();
                this.bufferInvalid = true;
                this.fireEvent(new Object[]{this, GEvent.PRESSED});
                break;
            }
            case 3: {
                if (focusIsWith != this) break;
                this.parametricTarget = this.ox + 0.5f;
                this.parametricTarget = this.calcParametricTarget(this.parametricTarget);
                this.dragging = false;
                this.status = 0;
                this.loseFocus(this.parent);
                this.bufferInvalid = true;
                this.fireEvent(new Object[]{this, GEvent.CLICKED});
                break;
            }
            case 8: {
                if (this.currSpot <= -1 || this.z < this.focusObjectZ()) break;
                this.parametricTarget = this.calcParametricTarget(this.parametricTarget + (float)mouseEvent.getCount() * this.wheelDelta * (float)G4P.wheelForSlider);
                break;
            }
            case 2: {
                if (focusIsWith != this) break;
                if (this.dragging) {
                    this.dragging = false;
                    if (this.downHotSpot == THUMB_SPOT) {
                        this.parametricTarget = this.ox - this.offset + 0.5f;
                        if (this.parametricTarget < 0.0f || this.parametricTarget > 1.0f) {
                            this.offset = 0.0f;
                        }
                        this.parametricTarget = this.calcParametricTarget(this.parametricTarget);
                    }
                }
                this.status = 0;
                this.bufferInvalid = true;
                this.loseFocus(this.parent);
                this.fireEvent(new Object[]{this, GEvent.RELEASED});
                break;
            }
            case 4: {
                if (focusIsWith != this) break;
                this.status = 3;
                this.dragging = true;
                if (this.downHotSpot != THUMB_SPOT) break;
                this.parametricTarget = this.ox - this.offset + 0.5f;
                if (this.parametricTarget < 0.0f) {
                    this.parametricTarget = 0.0f;
                    this.offset = 0.0f;
                } else if (this.parametricTarget > 1.0f) {
                    this.parametricTarget = 1.0f;
                    this.offset = 0.0f;
                }
                this.bufferInvalid = true;
                break;
            }
            case 5: {
                int n = this.status;
                this.status = this.currSpot == THUMB_SPOT ? 1 : 0;
                if (n == this.status) break;
                this.bufferInvalid = true;
            }
        }
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        this.updateBuffer();
        this.winApp.pushStyle();
        this.winApp.pushMatrix();
        this.winApp.translate(this.cx, this.cy);
        this.winApp.rotate(this.rotAngle);
        this.winApp.pushMatrix();
        this.winApp.translate(-this.halfWidth, -this.halfHeight);
        this.winApp.imageMode(0);
        if (this.alphaLevel < 255) {
            this.winApp.tint(255, (float)this.alphaLevel);
        }
        this.winApp.image((PImage)this.buffer, 0.0f, 0.0f);
        this.winApp.popMatrix();
        this.winApp.popMatrix();
        this.winApp.popStyle();
    }

    protected void drawValue(Graphics2D graphics2D) {
        this.ssValue.setText(this.getNumericDisplayString(this.getValueF()));
        TextLayout textLayout = this.ssValue.getLines((Graphics2D)graphics2D).getFirst().layout;
        float f = textLayout.getVisibleAdvance();
        switch (this.textOrientation) {
            case -1: {
                float f2 = (this.parametricPos - 0.5f) * this.trackLength + textLayout.getDescent();
                float f3 = -this.trackOffset;
                this.buffer.pushMatrix();
                this.buffer.translate(f2, f3);
                this.buffer.rotate(-1.5707964f);
                textLayout.draw(graphics2D, 0.0f, 0.0f);
                this.buffer.popMatrix();
                break;
            }
            case 1: {
                float f4 = (this.parametricPos - 0.5f) * this.trackLength - textLayout.getDescent();
                float f5 = -this.trackOffset - f;
                this.buffer.pushMatrix();
                this.buffer.translate(f4, f5);
                this.buffer.rotate(1.5707964f);
                textLayout.draw(graphics2D, 0.0f, 0.0f);
                this.buffer.popMatrix();
                break;
            }
            case 0: {
                float f6 = (this.parametricPos - 0.5f) * this.trackLength - f / 2.0f;
                if (f6 < -this.trackDisplayLength / 2.0f) {
                    f6 = -this.trackDisplayLength / 2.0f;
                } else if (f6 + f > this.trackDisplayLength / 2.0f) {
                    f6 = this.trackDisplayLength / 2.0f - f;
                }
                float f7 = -this.trackOffset - textLayout.getDescent();
                textLayout.draw(graphics2D, f6, f7);
                textLayout = this.ssEndLimit.getLines((Graphics2D)graphics2D).getFirst().layout;
            }
        }
    }

    protected void drawLimits(Graphics2D graphics2D) {
        if (this.limitsInvalid) {
            this.ssStartLimit.setText(this.getNumericDisplayString(this.startLimit));
            this.ssEndLimit.setText(this.getNumericDisplayString(this.endLimit));
            this.limitsInvalid = false;
        }
        switch (this.textOrientation) {
            case -1: {
                TextLayout textLayout = this.ssStartLimit.getLines((Graphics2D)graphics2D).getFirst().layout;
                float f = -this.trackLength / 2.0f + textLayout.getDescent();
                float f2 = this.trackOffset + textLayout.getVisibleAdvance();
                this.buffer.pushMatrix();
                this.buffer.translate(f, f2);
                this.buffer.rotate(-1.5707964f);
                textLayout.draw(graphics2D, 0.0f, 0.0f);
                this.buffer.popMatrix();
                textLayout = this.ssEndLimit.getLines((Graphics2D)graphics2D).getFirst().layout;
                f = this.trackLength / 2.0f + textLayout.getDescent();
                f2 = this.trackOffset + textLayout.getVisibleAdvance();
                this.buffer.pushMatrix();
                this.buffer.translate(f, f2);
                this.buffer.rotate(-1.5707964f);
                textLayout.draw(graphics2D, 0.0f, 0.0f);
                this.buffer.popMatrix();
                break;
            }
            case 1: {
                TextLayout textLayout = this.ssStartLimit.getLines((Graphics2D)graphics2D).getFirst().layout;
                float f = -this.trackLength / 2.0f - textLayout.getDescent();
                float f3 = this.trackOffset;
                this.buffer.pushMatrix();
                this.buffer.translate(f, f3);
                this.buffer.rotate(1.5707964f);
                textLayout.draw(graphics2D, 0.0f, 0.0f);
                this.buffer.popMatrix();
                textLayout = this.ssEndLimit.getLines((Graphics2D)graphics2D).getFirst().layout;
                f = this.trackLength / 2.0f - textLayout.getDescent();
                f3 = this.trackOffset;
                this.buffer.pushMatrix();
                this.buffer.translate(f, f3);
                this.buffer.rotate(1.5707964f);
                textLayout.draw(graphics2D, 0.0f, 0.0f);
                this.buffer.popMatrix();
                break;
            }
            case 0: {
                TextLayout textLayout = this.ssStartLimit.getLines((Graphics2D)graphics2D).getFirst().layout;
                float f = -(this.trackLength + this.trackWidth) / 2.0f;
                float f4 = this.trackOffset + textLayout.getAscent();
                textLayout.draw(graphics2D, f, f4);
                textLayout = this.ssEndLimit.getLines((Graphics2D)graphics2D).getFirst().layout;
                f = (this.trackLength + this.trackWidth) / 2.0f - textLayout.getVisibleAdvance();
                f4 = this.trackOffset + textLayout.getAscent();
                textLayout.draw(graphics2D, f, f4);
            }
        }
    }

    protected void drawLabels(Graphics2D graphics2D) {
        if (this.labelsInvalid) {
            this.ssStartLimit.setText(this.getNumericDisplayString(this.startLimit));
            this.ssEndLimit.setText(this.getNumericDisplayString(this.endLimit));
            this.limitsInvalid = false;
        }
        float f = 1.0f / (float)(this.nbrTicks - 1);
        switch (this.textOrientation) {
            case -1: {
                for (int i = 0; i < this.labels.length; ++i) {
                    TextLayout textLayout = this.labels[i].getLines((Graphics2D)graphics2D).getFirst().layout;
                    float f2 = ((float)i * f - 0.5f) * this.trackLength + textLayout.getDescent();
                    float f3 = this.trackOffset + textLayout.getVisibleAdvance();
                    this.buffer.pushMatrix();
                    this.buffer.translate(f2, f3);
                    this.buffer.rotate(-1.5707964f);
                    textLayout.draw(graphics2D, 0.0f, 0.0f);
                    this.buffer.popMatrix();
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.labels.length; ++i) {
                    TextLayout textLayout = this.labels[i].getLines((Graphics2D)graphics2D).getFirst().layout;
                    float f4 = ((float)i * f - 0.5f) * this.trackLength - textLayout.getDescent();
                    float f5 = this.trackOffset;
                    this.buffer.pushMatrix();
                    this.buffer.translate(f4, f5);
                    this.buffer.rotate(1.5707964f);
                    textLayout.draw(graphics2D, 0.0f, 0.0f);
                    this.buffer.popMatrix();
                }
                break;
            }
            case 0: {
                for (int i = 0; i < this.labels.length; ++i) {
                    TextLayout textLayout = this.labels[i].getLines((Graphics2D)graphics2D).getFirst().layout;
                    float f6 = ((float)i * f - 0.5f) * this.trackLength - 0.5f * textLayout.getVisibleAdvance();
                    float f7 = this.trackOffset + textLayout.getAscent();
                    textLayout.draw(graphics2D, f6, f7);
                }
                break;
            }
        }
    }
}

