/*
 * Decompiled with CFR 0.152.
 */
package processing.serial;

import java.lang.reflect.Method;
import java.util.Map;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import jssc.SerialPortList;
import processing.core.PApplet;

public class Serial
implements SerialPortEventListener {
    PApplet parent;
    public SerialPort port;
    Method serialAvailableMethod;
    Method serialEventMethod;
    byte[] buffer = new byte[32768];
    int inBuffer = 0;
    int readOffset = 0;
    int bufferUntilSize = 1;
    byte bufferUntilByte = 0;
    volatile boolean invokeSerialAvailable = false;

    public Serial(PApplet pApplet) {
        this(pApplet, "COM1", 9600, 'N', 8, 1.0f);
    }

    public Serial(PApplet pApplet, int n) {
        this(pApplet, "COM1", n, 'N', 8, 1.0f);
    }

    public Serial(PApplet pApplet, String string) {
        this(pApplet, string, 9600, 'N', 8, 1.0f);
    }

    public Serial(PApplet pApplet, String string, int n) {
        this(pApplet, string, n, 'N', 8, 1.0f);
    }

    public Serial(PApplet pApplet, String string, int n, char c, int n2, float f) {
        this.parent = pApplet;
        pApplet.registerMethod("dispose", (Object)this);
        pApplet.registerMethod("pre", (Object)this);
        c = c == 'O' ? (char)'\u0001' : (c == 'E' ? (char)2 : (c == 'M' ? (char)3 : (c == 'S' ? (char)4 : (char)'\u0000')));
        int n3 = 1;
        if (f == 1.5f) {
            n3 = 3;
        } else if (f == 2.0f) {
            n3 = 2;
        }
        this.port = new SerialPort(string);
        try {
            this.port.openPort();
            this.port.setParams(n, n2, n3, (int)c);
            this.port.addEventListener((SerialPortEventListener)this, 1);
        }
        catch (SerialPortException serialPortException) {
            throw new RuntimeException("Error opening serial port " + serialPortException.getPortName() + ": " + serialPortException.getExceptionType());
        }
        this.serialEventMethod = this.findCallback("serialEvent");
        this.serialAvailableMethod = this.findCallback("serialAvailable");
    }

    private Method findCallback(String string) {
        try {
            return this.parent.getClass().getMethod(string, this.getClass());
        }
        catch (Exception exception) {
            try {
                return this.parent.getClass().getMethod(string, Object.class);
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    public void dispose() {
        this.stop();
    }

    public boolean active() {
        return this.port.isOpened();
    }

    public void pre() {
        if (this.serialAvailableMethod != null && this.invokeSerialAvailable) {
            this.invokeSerialAvailable = false;
            try {
                this.serialAvailableMethod.invoke((Object)this.parent, this);
            }
            catch (Exception exception) {
                System.err.println("Error, disabling serialAvailable() for " + this.port.getPortName());
                System.err.println(exception.getLocalizedMessage());
                this.serialAvailableMethod = null;
            }
        }
    }

    public int available() {
        return this.inBuffer - this.readOffset;
    }

    public void buffer(int n) {
        this.bufferUntilSize = n;
    }

    public void bufferUntil(int n) {
        this.bufferUntilSize = 0;
        this.bufferUntilByte = (byte)n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            this.inBuffer = 0;
            this.readOffset = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean getCTS() {
        try {
            return this.port.isCTS();
        }
        catch (SerialPortException serialPortException) {
            throw new RuntimeException("Error reading the CTS line: " + serialPortException.getExceptionType());
        }
    }

    public boolean getDSR() {
        try {
            return this.port.isDSR();
        }
        catch (SerialPortException serialPortException) {
            throw new RuntimeException("Error reading the DSR line: " + serialPortException.getExceptionType());
        }
    }

    public static Map<String, String> getProperties(String string) {
        return SerialPortList.getPortProperties((String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int last() {
        if (this.inBuffer == this.readOffset) {
            return -1;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n = this.buffer[this.inBuffer - 1] & 0xFF;
            this.inBuffer = 0;
            this.readOffset = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    public char lastChar() {
        return (char)this.last();
    }

    public static String[] list() {
        return SerialPortList.getPortNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() {
        if (this.inBuffer == this.readOffset) {
            return -1;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n = this.buffer[this.readOffset++] & 0xFF;
            if (this.inBuffer == this.readOffset) {
                this.inBuffer = 0;
                this.readOffset = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes() {
        if (this.inBuffer == this.readOffset) {
            return null;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            byte[] byArray2 = new byte[this.inBuffer - this.readOffset];
            System.arraycopy(this.buffer, this.readOffset, byArray2, 0, byArray2.length);
            this.inBuffer = 0;
            this.readOffset = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes(int n) {
        if (this.inBuffer == this.readOffset) {
            return null;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n2 = this.inBuffer - this.readOffset;
            if (n2 > n) {
                n2 = n;
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(this.buffer, this.readOffset, byArray2, 0, n2);
            this.readOffset += n2;
            if (this.inBuffer == this.readOffset) {
                this.inBuffer = 0;
                this.readOffset = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytes(byte[] byArray) {
        if (this.inBuffer == this.readOffset) {
            return 0;
        }
        byte[] byArray2 = this.buffer;
        synchronized (this.buffer) {
            int n = this.inBuffer - this.readOffset;
            if (byArray.length < n) {
                n = byArray.length;
            }
            System.arraycopy(this.buffer, this.readOffset, byArray, 0, n);
            this.readOffset += n;
            if (this.inBuffer == this.readOffset) {
                this.inBuffer = 0;
                this.readOffset = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytesUntil(int n) {
        if (this.inBuffer == this.readOffset) {
            return null;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n2;
            int n3;
            block8: {
                n3 = -1;
                n2 = this.readOffset;
                while (n2 < this.inBuffer) {
                    if (this.buffer[n2] == (byte)n) {
                        n3 = n2;
                        break;
                    }
                    ++n2;
                }
                if (n3 != -1) break block8;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            n2 = n3 - this.readOffset + 1;
            byte[] byArray2 = new byte[n2];
            System.arraycopy(this.buffer, this.readOffset, byArray2, 0, n2);
            this.readOffset += n2;
            if (this.inBuffer == this.readOffset) {
                this.inBuffer = 0;
                this.readOffset = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytesUntil(int n, byte[] byArray) {
        if (this.inBuffer == this.readOffset) {
            return 0;
        }
        byte[] byArray2 = this.buffer;
        synchronized (this.buffer) {
            int n2;
            block10: {
                int n3;
                block9: {
                    n3 = -1;
                    n2 = this.readOffset;
                    while (n2 < this.inBuffer) {
                        if (this.buffer[n2] == (byte)n) {
                            n3 = n2;
                            break;
                        }
                        ++n2;
                    }
                    if (n3 != -1) break block9;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return 0;
                }
                n2 = n3 - this.readOffset + 1;
                if (byArray.length >= n2) break block10;
                System.err.println("The buffer passed to readBytesUntil() is to small to contain " + n2 + " bytes up to and including " + "char " + (byte)n);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return -1;
            }
            System.arraycopy(this.buffer, this.readOffset, byArray, 0, n2);
            this.readOffset += n2;
            if (this.inBuffer == this.readOffset) {
                this.inBuffer = 0;
                this.readOffset = 0;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return n2;
        }
    }

    public char readChar() {
        return (char)this.read();
    }

    public String readString() {
        if (this.inBuffer == this.readOffset) {
            return null;
        }
        return new String(this.readBytes());
    }

    public String readStringUntil(int n) {
        byte[] byArray = this.readBytesUntil(n);
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void serialEvent(SerialPortEvent serialPortEvent) {
        if (serialPortEvent.getEventType() != 1) return;
        try {
            while (true) {
                byte[] byArray;
                int n;
                if ((n = this.port.getInputBufferBytesCount()) <= 0) {
                    return;
                }
                byte[] byArray2 = this.buffer;
                // MONITORENTER : this.buffer
                if (this.serialEventMethod != null) {
                    n = 1;
                }
                if (this.buffer.length < this.inBuffer + n) {
                    byArray = new byte[this.buffer.length << 1];
                    System.arraycopy(this.buffer, 0, byArray, 0, this.inBuffer);
                    this.buffer = byArray;
                }
                byArray = this.port.readBytes(n);
                System.arraycopy(byArray, 0, this.buffer, this.inBuffer, byArray.length);
                this.inBuffer += byArray.length;
                // MONITOREXIT : byArray2
                if (this.serialEventMethod != null && (this.bufferUntilSize > 0 && this.bufferUntilSize <= this.inBuffer - this.readOffset || this.bufferUntilSize == 0 && this.bufferUntilByte == this.buffer[this.inBuffer - 1])) {
                    try {
                        this.serialEventMethod.invoke((Object)this.parent, this);
                    }
                    catch (Exception exception) {
                        System.err.println("Error, disabling serialEvent() for " + this.port.getPortName());
                        System.err.println(exception.getLocalizedMessage());
                        this.serialEventMethod = null;
                    }
                }
                this.invokeSerialAvailable = true;
            }
        }
        catch (SerialPortException serialPortException) {
            throw new RuntimeException("Error reading from serial port " + serialPortException.getPortName() + ": " + serialPortException.getExceptionType());
        }
    }

    public void setDTR(boolean bl) {
        try {
            this.port.setDTR(bl);
        }
        catch (SerialPortException serialPortException) {
            throw new RuntimeException("Error setting the DTR line: " + serialPortException.getExceptionType());
        }
    }

    public void setRTS(boolean bl) {
        try {
            this.port.setRTS(bl);
        }
        catch (SerialPortException serialPortException) {
            throw new RuntimeException("Error setting the RTS line: " + serialPortException.getExceptionType());
        }
    }

    public void stop() {
        try {
            this.port.closePort();
        }
        catch (SerialPortException serialPortException) {}
        this.inBuffer = 0;
        this.readOffset = 0;
    }

    public void write(byte[] byArray) {
        try {
            this.port.writeBytes(byArray);
        }
        catch (SerialPortException serialPortException) {
            throw new RuntimeException("Error writing to serial port " + serialPortException.getPortName() + ": " + serialPortException.getExceptionType());
        }
    }

    public void write(int n) {
        try {
            this.port.writeInt(n);
        }
        catch (SerialPortException serialPortException) {
            throw new RuntimeException("Error writing to serial port " + serialPortException.getPortName() + ": " + serialPortException.getExceptionType());
        }
    }

    public void write(String string) {
        try {
            this.port.writeString(string);
        }
        catch (SerialPortException serialPortException) {
            throw new RuntimeException("Error writing to serial port " + serialPortException.getPortName() + ": " + serialPortException.getExceptionType());
        }
    }
}

