/*
 * command_process.h
 *
 *  Created on: May 1, 2022
 *      Author: charan
 */

#ifndef COMMAND_PROCESS_H_
#define COMMAND_PROCESS_H_

#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include<string.h>

#define No_Of_Commands 11
#define SHELL_MAX_ARGS 5
typedef struct ShellCommand {
  const char *command;
  int (*handler)(int argc, char *argv[]);
  const char *help;
} sShellCommand;


typedef struct {
  bool enabled;
  uint32_t revision;
  size_t num_code_comparators;
  size_t num_literal_comparators;
} sFpbConfig;

typedef struct {
  volatile uint32_t COMP;
  volatile uint32_t MASK;
  volatile uint32_t FUNCTION;
  volatile uint32_t RSVD;
} sDwtCompCfg;

typedef struct {
  volatile uint32_t CTRL;
  volatile uint32_t CYCCNT;
  volatile uint32_t CPICNT;
  volatile uint32_t EXCCNT;
  volatile uint32_t SLEEPCNT;
  volatile uint32_t LSUCNT;
  volatile uint32_t FOLDCNT;
  volatile const  uint32_t PCSR;
  sDwtCompCfg COMP_CONFIG[];
} sDWTUnit;

extern unsigned char msg[100];
extern uint8_t rx_interrupt;
extern uint8_t Debug_interrupt;

void get_config(sFpbConfig *config) ;
int set_breakpoint(int argc, char *argv[]);
void enable_debug(bool do_enable);
int debug_monitor_enable();
void Process_command();
int call_dummy_funcs(int argc, char *argv[]);
void show_fun_Addr();
void fpb_enable(void);
void fpb_disable(void);
void fpb_dump_breakpoint_config(void);
void help_handler();
void set_watchpoint(int argc, char *argv[]);
void dwt_dump(void);
void poke_handler();
void dwt_reset(void);

#endif /* COMMAND_PROCESS_H_ */
