/*
 * command_porcess.c
 *
 *  Created on: May 1, 2022
 *      Author: charan
 */
#include <command_process.h>
#include <LED_display.h>
#include <UART.h>






static const sShellCommand  s_shell_commands[]  = {
        {"debug_mon_en",debug_monitor_enable, "Enable debugging !\r\n"},
        {"set_breakpoint",set_breakpoint, "Breakpoint set at [Comp Id] [Address] !\r\n"},
        {"call_fun", call_dummy_funcs, "Invoke dummy functions\r\n"},
        {"show_fun_address",show_fun_Addr,"Show function address\r\n"},
        {"dump_bkpt",fpb_dump_breakpoint_config,"dump breakpoints\r\n"},
        {"help",help_handler,"List of commands\r\n"},
        {"set_watchpoint", set_watchpoint, "watch point set at [Comp Id] [function] [Address]!\r\n" },
        {"dwt_dump",dwt_dump,"Dump DWT configuration\r\n"},
        {"poke",poke_handler,"Change value at [Address]\r\n"},
        {"dwt_reset",dwt_reset,"Reset Watchpoints\r\n"},
        /*{"peek", peek, "peeking at [Address] \r\n"},
        {"poke", poke, "poking at [Address] [value]\r\n"},*/
};



typedef struct {
  volatile uint32_t FP_CTRL;
  volatile uint32_t FP_REMAP;
  // Number Implemented determined by FP_CTRL
  volatile uint32_t FP_COMP[];
} sFpbUnit;



static sFpbUnit *const FPB = (sFpbUnit *)0xE0002000;

void Process_command(){

    rx_interrupt=0;
    char *argv[SHELL_MAX_ARGS] = {0};

    char command_array[No_Of_Commands][20];


    short k=0;
    short j;
    short argc=0;
    while(argc<No_Of_Commands){
        j=0;
        while(rx_buf[k]!=' ' && rx_buf[k]!='\0'){
             command_array[argc][j]=tolower(rx_buf[k]);
             rx_buf[k]=command_array[argc][j];
              k++;j++;
          }
          command_array[argc][j]='\0';
          argc++;
          if(rx_buf[k]=='\0')
             break;
          k++;
     }
     rx_buf[k++]='\0';
     for(int i=0;i<argc;i++){
          argv[i]=*(command_array+i);
     }
     int i;
     for(i=0;i<No_Of_Commands;i++){
       if(strcmp(argv[0],s_shell_commands[i].command)==0){
           s_shell_commands[i].handler(argc,argv);
           break;
     }
    }
     if(i==No_Of_Commands){
         UART_Send_Str("\r\n Enter valid command. Type \"help\" to get list of commands");
     }
     UART_Prompt();

}

void poke_handler(int argc,char *argv[]){
    uint32_t *addr;
    addr= strtoul(argv[1], NULL, 0x0);
    uint32_t value = strtoul(argv[2], NULL, 0x0);

    *addr = value;
    sprintf(msg,"\r\nvalue at address: %x changed to %d", addr, value);
       UART_Send_Str(msg);

}

void dwt_reset(void) {
    static sDWTUnit *const DWT = (sDWTUnit *)0xE0001000;
  const size_t num_comparators = (DWT->CTRL>>28) & 0xF;

  for (size_t i = 0; i < num_comparators; i++) {
    sDwtCompCfg *config = &DWT->COMP_CONFIG[i];
    config->FUNCTION = config->COMP = config->MASK = 0;
  }
}



void set_watchpoint(int argc, char *argv[]) {

  static sDWTUnit *const DWT = (sDWTUnit *)0xE0001000;
  const size_t num_comparators = (DWT->CTRL>>28) & 0xF;
  size_t comp_id = strtoul(argv[1], NULL, 0x0);
  uint32_t func = strtoul(argv[2], NULL, 0x0);
  uint32_t comp = strtoul(argv[3], NULL, 0x0);
//  uint32_t mask = strtoul(argv[4], NULL, 0x0);


  if (comp_id > num_comparators) {
    sprintf(msg,"Invalid COMP_ID of %d", comp_id);
    UART_Send_Str(msg);
    return;
  }

  sDwtCompCfg *config = &DWT->COMP_CONFIG[comp_id];
  config->COMP = comp;
  config->MASK = 0;
  // set list since this will enable the comparator
  config->FUNCTION = func;
}


void dwt_dump(void) {

    static sDWTUnit *const DWT = (sDWTUnit *)0xE0001000;
  sprintf(msg,"\r\nDWT Dump:");
  UART_Send_Str(msg);

  const size_t num_comparators = (DWT->CTRL>>28) & 0xF;
  sprintf(msg,"\r\n NUMCOMP=0x%x", num_comparators);
  UART_Send_Str(msg);

  for (size_t i = 0; i < num_comparators; i++) {
    const sDwtCompCfg *config = &DWT->COMP_CONFIG[i];

    sprintf(msg,"\r\nComparator %d Config", (int)i);
    UART_Send_Str(msg);

    sprintf(msg,"\r\n0x%08x DWT_FUNC%d: 0x%08x",
                &config->FUNCTION, (int)i, config->FUNCTION);
    UART_Send_Str(msg);

    sprintf(msg,"\r\n0x%08x DWT_COMP%d: 0x%08x",
                &config->COMP, (int)i, config->COMP);
    UART_Send_Str(msg);

    sprintf(msg,"\r\n0x%08x DWT_MASK%d: 0x%08x",
                &config->MASK, (int)i, config->MASK);
    UART_Send_Str(msg);
  }
}

int debug_monitor_enable( ){
    volatile uint32_t *dhcsr = (uint32_t *)0xE000EDF0;
    int halt_mode_enabled = ((*dhcsr) & 0x1) != 0;

      if (halt_mode_enabled) {
          UART_Send_Str("\r\nHalting Debug Enabled - "
                      "Can't Enable Monitor Mode Debug!\r\n");
              return 0;
          }
      enable_debug(1);

      volatile uint32_t *shpr3 = (uint32_t *)0xE000ED20;
      *shpr3 = 0xff;
      UART_Send_Str("\r\nMonitor Debug mode enabled!\r\n");
      return 1;
}

void enable_debug(bool do_enable) {
      volatile uint32_t *demcr = (uint32_t *)0xE000EDFC;
      const uint32_t mon_en_bit = 16;
      if (do_enable) {

          // clear any stale state in the DFSR
            volatile uint32_t *dfsr = (uint32_t*)0xE000ED30;
            *dfsr = *dfsr;
            *demcr |= 1 << mon_en_bit;
      }
      else { *demcr &= ~(1 << mon_en_bit); }
}

int set_breakpoint(int argc, char *argv[]){
    if (argc < 3) {
        UART_Send_Str("\r\nExpected [Comp Id] [Address] \r\n");
        return 0;
    }
          size_t comp_id = strtoul(argv[1], NULL, 0x0);
          uint32_t addr = strtoul(argv[2], NULL, 0x0);


          sFpbConfig config;
          get_config(&config);

          if (config.revision != 0) {
              sprintf(msg,"\r\nRevision %d Parsing Not Supported\r\n", config.revision);
              UART_Send_Str(msg);
            return 0;
          }

          const size_t num_comps = config.num_code_comparators;
          if (comp_id >= num_comps) {
              sprintf(msg,"\r\nInstruction Comparator %d Not Implemented\r\n", num_comps);
              UART_Send_Str(msg);
              return 0;
          }

          if (addr >= 0x20000000) {
              sprintf(msg,"\r\nAddress 0x%x is not in code region\r\n", addr);
              UART_Send_Str(msg);
              return 0;
          }

          if (!config.enabled) {
              UART_Send_Str("\r\nEnabling FPB.");
              FPB->FP_CTRL |= 0x3;
          }


          const uint32_t replace = (addr & 0x2) == 0 ? 1 : 2;
          const uint32_t fp_comp = (addr & ~0x3) | 0x1 | (replace << 30);
          FPB->FP_COMP[comp_id] = fp_comp;
          bool success=true;
          sprintf(msg,"\r\nSet breakpoint on address 0x%x in FP_COMP[%d] %s\r\n", addr,
                      (int)comp_id, success ? "Succeeded" : "Failed\r\n");
          UART_Send_Str(msg);
          return 1;

}


void get_config(sFpbConfig *config) {
  uint32_t fp_ctrl = FPB->FP_CTRL;

  const uint32_t enabled = fp_ctrl & 0x1;
  const uint32_t revision = (fp_ctrl >> 28) & 0xF;
  const uint32_t num_code =
      (((fp_ctrl >> 12) & 0x7) << 4) | ((fp_ctrl >> 4) & 0xF);
  const uint32_t num_lit = (fp_ctrl >> 8) & 0xF;

  *config = (sFpbConfig) {
    .enabled = enabled != 0,
    .revision = revision,
    .num_code_comparators = num_code,
    .num_literal_comparators = num_lit,
  };
}

static const sDummyFunction s_dummy_funcs[] = {
      DUMMY_FUNC_ENTRY(dummy_function_1),
      DUMMY_FUNC_ENTRY(dummy_function_2),
      DUMMY_FUNC_ENTRY(dummy_function_3),
      DUMMY_FUNC_ENTRY(dummy_function_4),
};


int call_dummy_funcs(int argc, char *argv[]) {
  size_t no_of_dum_funcs=sizeof(s_dummy_funcs) / sizeof( s_dummy_funcs[0]);
  for (size_t i = 0; i < no_of_dum_funcs; i++) {
    s_dummy_funcs[i].func();
  }
  return 0;
}


void show_fun_Addr(){
    size_t no_of_dum_funcs=sizeof(s_dummy_funcs) / sizeof( s_dummy_funcs[0]);
    UART_echo('\n');
    for (size_t i = 0; i < no_of_dum_funcs; i++) {
      volatile uint32_t *addr = (uint32_t *)(((uint32_t)s_dummy_funcs[i].func) & ~0x1);
      sprintf(msg,"%s: Address: 0x%x. First Instruction = 0x%x \r\n", s_dummy_funcs[i].name, addr, *addr) ;
      UART_Send_Str(msg);
    }
}

void fpb_dump_breakpoint_config(void) {
  const uint32_t fp_ctrl = FPB->FP_CTRL;
  const uint32_t fpb_enabled = fp_ctrl & 0x1;
  const uint32_t revision = (fp_ctrl >> 28) & 0xF;
  const uint32_t num_code_comparators =
      (((fp_ctrl >> 12) & 0x7) << 4) | ((fp_ctrl >> 4) & 0xF);

  sprintf(msg,"FPB Revision: %d, Enabled: %d, Hardware Breakpoints: %d\r\n",
              revision, (int)fpb_enabled, (int)num_code_comparators);
  UART_Send_Str(msg);

  for (size_t i = 0; i < num_code_comparators; i++) {
    const uint32_t fp_comp = FPB->FP_COMP[i];
    const bool enabled = fp_comp & 0x1;
    const uint32_t replace = fp_comp >> 30;

    uint32_t instruction_address = fp_comp & 0x1FFFFFFC;
    if (replace == 0x2) {
      instruction_address |= 0x2;
    }

    sprintf(msg,"  FP_COMP[%d] Enabled %d, Replace: %d, Address 0x%x\r\n",
                (int)i, (int)enabled, (int)replace, instruction_address);
    UART_Send_Str(msg);
  }
}

void help_handler(){
    UART_Send_Str("\r\n");
    for(int i=0;i<No_Of_Commands;i++){

        sprintf(msg,"%s : %s ",s_shell_commands[i].command,s_shell_commands[i].help);
        UART_Send_Str(msg);
        }
}

void fpb_disable(void) {
  FPB->FP_CTRL = (FPB->FP_CTRL & ~0x3) | 0x2;
}

void fpb_enable(void) {
  FPB->FP_CTRL |= 0x3;
}
