/*
 * UART.h
 *
 *  Created on: May 1, 2022
 *      Author: charan
 */

#ifndef UART_H_
#define UART_H_


#include <command_process.h>
#include <stdint.h>
#include <../TivaWare_C_Series-2.1.4.178/inc/tm4c123gh6pm.h>
#include <../TivaWare_C_Series-2.1.4.178/inc/hw_memmap.h>
#include <../TivaWare_C_Series-2.1.4.178/inc/hw_types.h>
#include <../TivaWare_C_Series-2.1.4.178/driverlib/pin_map.h>
#include <../TivaWare_C_Series-2.1.4.178/driverlib/sysctl.h>
#include <../TivaWare_C_Series-2.1.4.178/driverlib/gpio.h>
#include <../TivaWare_C_Series-2.1.4.178/driverlib/uart.h>
#include "../TivaWare_C_Series-2.1.4.178/inc/hw_uart.h"

#define REGADDRHW(x)                                                              \
        (*((volatile uint32_t *)(x)))

int UART_initialize();
void UART_Send_Str(unsigned char *buf);
void UART_read_char(unsigned char *c);
void UART_echo(unsigned char c);
void UART_handler();
void UART_Prompt();

extern char rx_buf[40];
extern int rx_buf_index;
extern uint8_t process_command;
extern unsigned char c;
extern uint8_t Debug_interrupt;
extern uint8_t rx_interrupt;
#endif /* UART_H_ */
