    /* sw1_int.c

     *

     * Runs on EK-TM4C123GXL LaunchPad

     *

     * GPIO PORTF interrupt that will toggle the on board Blue LED

     * on rising edge whenever a user switch (SW1) is pressed.

     *

     */

#include <UART.h>


unsigned char special_chars[]={'\r','\n',' ','\b'};

int UART_initialize(){
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA); // GPIO-A clock clock enable
    SysCtlPeripheralEnable(SYSCTL_PERIPH_UART0); // UART clock enable
    GPIOPinConfigure(GPIO_PA0_U0RX); // UART Tx enable
    GPIOPinConfigure(GPIO_PA1_U0TX); // UART Rx enable
    GPIOPinTypeUART(GPIO_PORTA_BASE, GPIO_PIN_0 | GPIO_PIN_1);
    UARTConfigSetExpClk(UART0_BASE, SysCtlClockGet(), 115200,(UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE)); // UART frame control
    REGADDRHW(UART0_BASE + UART_O_LCRH) &=~(0x00000010);  // Disable UART FIFO
    NVIC_PRI1_R = (NVIC_PRI1_R & 0xFFFF1FFF) | 0x0000A000; //  priority 5
    NVIC_EN0_R |= 0x00000020;        //  Enable interrupt 5 in NVIC
    REGADDRHW(UART0_BASE + UART_O_IM) |= (1<<4);    // Enable UART0 RX interrupt

    return 1;
}

void UART_Send_Str(unsigned char *buf){
   while(*buf!='\0'){
    UARTCharPut(UART0_BASE, *buf);
    buf++;
   }
}

void UART_Prompt(){
    UART_Send_Str("\r\n $>");
}

void UART_read_char( unsigned char *c){
    *c=UARTCharGet(UART0_BASE);
}

void UART_echo(  unsigned char c){
    if (c == '\n') {
       UARTCharPut(UART0_BASE,*special_chars);
       UARTCharPut(UART0_BASE,*(special_chars+1));
     } else if (127==c) {
       UARTCharPut(UART0_BASE,*(special_chars+3));
       UARTCharPut(UART0_BASE,*(special_chars+2));
       UARTCharPut(UART0_BASE,*(special_chars+3));
       rx_buf_index=rx_buf_index-1;
       rx_buf[rx_buf_index]='\0';
       rx_buf_index=rx_buf_index-1;
     } else {
       UARTCharPut(UART0_BASE,c);
     }
}


void UART_handler(){

   if( UART0_MIS_R & (1<<4)){
              UART0_ICR_R = 0x10;

    UART_read_char(&c);                    // reading input character
    if(Debug_interrupt){
        rx_interrupt=1;
        Debug_interrupt=0;
        return;
    }
    if(c!='\r'){
       rx_buf[rx_buf_index]=c;

      UART_echo(c);
       rx_buf_index++;
    }
    else{
       rx_buf[rx_buf_index]='\0';
       process_command=1;
       //Process_command();

       rx_buf_index=0;

    }
   }
}

