/*
 * LED_display.c
 *
 *  Created on: May 1, 2022
 *      Author: charan
 */

#include <LED_display.h>
#include <UART.h>

unsigned int hexa_code_led[10]={0x3F,0x06,0x5B,0x4F,0x66,0x6D,0x7D,0x07,0x7F,0x6F}; // hexa code for each digit input to 7 segment display

void dummy_function_1(void) {
    UART_Send_Str("\r\nstub function 1 called");
    LED_7_Seg_config();
    uint32_t sec_count;

    while(count<10){
      delayMs(1);
      if(sec_count==550){
          count++;
          sec_count=0;
      }
      sec_count++;
      write_ones(count);
    }
}

void dummy_function_2(void) {
    //sprintf(msg,"stub function '%s' called\r\n", __func__);
    UART_Send_Str("\r\nstub function 2 called");
}

void dummy_function_3(void) {
    //sprintf(msg,"stub function '%s' called\r\n", __func__);
    UART_Send_Str("\r\nstub function 3 called");
}

void dummy_function_4(void) {
    //sprintf(msg,"stub function '%s' called\r\n", __func__);
    UART_Send_Str("\r\nstub function 4 called");
}


void LED_7_Seg_config(){

    SYSCTL_RCGC2_R |= 0x00000003; // enable clock to port A,B

    GPIO_PORTA_DIR_R |= 0xF0; // PORT A4 and A5 as outputs to control LED
    GPIO_PORTA_DEN_R |= 0xF0; // Digital signal enable

    GPIO_PORTB_DIR_R = 0xFF; // PORT B as output data bus
    GPIO_PORTB_DEN_R = 0xFF; // Digital signal enable

}

void write_ones(int i){
         GPIO_PORTA_DATA_R=0x10;
         GPIO_PORTB_DATA_R=hexa_code_led[i];
 }

void delayMs(int n)
{
      int i, j;
      for(i = 0 ; i < n; i++)
          for(j = 0; j < 3180; j++) {}   // do nothing for 1 ms

}

