/*
 * Debugger.h
 *
 *  Created on: May 2, 2022
 *      Author: charan
 */

#ifndef DEBUGGER_H_
#define DEBUGGER_H_

#include "UART.h"
#include "../TivaWare_C_Series-2.1.4.178/inc/tm4c123gh6pm.h"
#include "command_process.h"


typedef struct __attribute__((packed)) ContextStateFrame {
  uint32_t r0;
  uint32_t r1;
  uint32_t r2;
  uint32_t r3;
  uint32_t r12;
  uint32_t lr;
  uint32_t return_address;
  uint32_t xpsr;
} sContextStateFrame;

typedef enum {
  Debug_Continue,
  Debug_SingleStep,
} eDebugState;


#define Single_Step 0
#define Continue 1

extern unsigned char msg[100];
extern uint8_t rx_interrupt;
extern eDebugState Debug_state;



void debug_handler_c(sContextStateFrame *frame);
void DebugMon_Handler(void);

#endif /* DEBUGGER_H_ */
