/*
 * Debugger.c
 *
 *  Created on: May 2, 2022
 *      Author: charan
 */

#include <Debugger.h>





void debug_handler_c(sContextStateFrame *frame){

    Debug_interrupt=1;
    volatile uint32_t *demcr = (uint32_t *)0xE000EDFC;

    volatile uint32_t *dfsr = (uint32_t *)0xE000ED30;
    const uint32_t dfsr_dwt_evt_bitmask = (1 << 2);
    const uint32_t dfsr_bkpt_evt_bitmask = (1 << 1);
    const uint32_t dfsr_halt_evt_bitmask = (1 << 0);
    const uint32_t dwt_func_matched_bitmask = (1<<24);
    const bool is_dwt_dbg_evt = (*dfsr & dfsr_dwt_evt_bitmask);
    const bool is_bkpt_dbg_evt = (*dfsr & dfsr_bkpt_evt_bitmask);
    const bool is_halt_dbg_evt = (*dfsr & dfsr_halt_evt_bitmask);


    sprintf(msg,"\r\nDebugMonitor Exception\r\n");
    UART_Send_Str(msg);

    sprintf(msg,"DEMCR: 0x%08x\r\n", *demcr);
    UART_Send_Str(msg);

    sprintf(msg,"DFSR:  0x%08x (bkpt=%d, halt=%d, dwt=%d)\r\n", *dfsr,
                (int)is_bkpt_dbg_evt, (int)is_halt_dbg_evt,
                (int)is_dwt_dbg_evt);
    UART_Send_Str(msg);

    sprintf(msg,"Register Dump\r\n");
    UART_Send_Str(msg);

    sprintf(msg," r0  =0x%08x\r\n", frame->r0);
    UART_Send_Str(msg);

    sprintf(msg," r1  =0x%08x\r\n", frame->r1);
    UART_Send_Str(msg);

    sprintf(msg," r2  =0x%08x\r\n", frame->r2);
    UART_Send_Str(msg);

    sprintf(msg," r3  =0x%08x\r\n", frame->r3);
    UART_Send_Str(msg);

    sprintf(msg," r12 =0x%08x\r\n", frame->r12);
    UART_Send_Str(msg);

    sprintf(msg," lr  =0x%08x\r\n", frame->lr);
    UART_Send_Str(msg);

    sprintf(msg," pc  =0x%08x\r\n", frame->return_address);
    UART_Send_Str(msg);

    sprintf(msg," xpsr=0x%08x\r\n", frame->xpsr);
    UART_Send_Str(msg);

    if(is_dwt_dbg_evt){

                          static sDWTUnit *const DWT = (sDWTUnit *)0xE0001000;
                          const size_t num_comparators = (DWT->CTRL>>28) & 0xF;

                          for(int i=0;i<num_comparators;i++){
                              sDwtCompCfg *config = &DWT->COMP_CONFIG[i];
                              if(config->FUNCTION & dwt_func_matched_bitmask){
                                  volatile uint32_t *addr = (uint32_t *)(((uint32_t)config->COMP));
                                  sprintf(msg,"Address: 0x%x. Value:%d \r\n", addr, *addr) ;
                                  UART_Send_Str(msg);
                              }
                          }
                          sprintf(msg,"\r\nPress any key to continue");
                                  UART_Send_Str(msg);

                          while (!rx_interrupt);
                          rx_interrupt=0;
                          *dfsr = dfsr_dwt_evt_bitmask;
                          return;
                      }



    if (is_bkpt_dbg_evt ||
          (Debug_state == Debug_SingleStep))  {

        sprintf(msg,"\r\nDebug Event Detected, Awaiting 'c' or 's'");
        UART_Send_Str(msg);

        while (1) {
            if(!rx_interrupt){
                continue;
            }

          rx_interrupt=0;
          Debug_interrupt=0;
          sprintf(msg,"\r\nGot char '%c'!\n", c);
          UART_Send_Str(msg);

          if (c == 'c') {
              Debug_state = Debug_Continue;
            break;
          } else if (c == 's') {
              Debug_state = Debug_SingleStep;

            break;
          }
        }
      }

    const uint32_t demcr_single_step_mask = (1 << 18);

    if (is_bkpt_dbg_evt) {
        const uint16_t instruction = *(uint16_t*)frame->return_address;
        if ((instruction & 0xff00) == 0xbe00) {
          // advance past breakpoint instruction
          frame->return_address += sizeof(instruction);
        } else {
          // It's a FPB generated breakpoint
          // We need to disable the FPB and single-step
          fpb_disable();    // FPB disable
          sprintf(msg,"\r\nSingle-Stepping over FPB at 0x%x", frame->return_address);
          UART_Send_Str(msg);
        }

        // single-step to the next instruction
        // This will cause a DebugMonitor interrupt to fire
        // once we return from the exception and a single
        // instruction has been executed. The HALTED bit
        // will be set in the DFSR when this happens.
        *demcr |= (demcr_single_step_mask);
        // We have serviced the breakpoint event so clear mask
        *dfsr = dfsr_bkpt_evt_bitmask;
      } else if (is_halt_dbg_evt) {
        // re-enable FPB in case we got here via single-step
        // for a BKPT debug event
          fpb_enable(); // FPB enable

        if (Debug_state  !=Debug_SingleStep) {
          *demcr &= ~(demcr_single_step_mask);
          sprintf(msg,"\r\nResuming ...");
          UART_Send_Str(msg);
        }

        // We have serviced the single step event so clear mask
        *dfsr = dfsr_halt_evt_bitmask;
      }

}








__attribute__((naked))
void DebugMon_Handler(void) {
  __asm volatile(
      "tst lr, #4 \n"
      "ite eq \n"
      "mrseq r0, msp \n"
      "mrsne r0, psp \n"
      "b debug_handler_c \n");
}
