#include <stdint.h>
#include <stdbool.h>
#include <string.h>
#include "inc/tm4c123gh6pm.h"
//#include <inc/hw_memmap.h>
//#include <inc/hw_types.h>
//#include <driverlib/gpio.h>
//#include <driverlib/pin_map.h>
#include <driverlib/sysctl.h>
#include <math.h>
#include <CONTROLLER.h>
#include "SWITCH_button.h"
#include "LEDs.h"


void delayUs(int n);
void decode_cmd(char* data, int length) ;
void GPIO_Config(void);
void PWM_Config(void);
void UART_Config(void);
void PWM_ISR(void);
void ADC_Config(void);
void EnableInterrupts(void);

volatile int adc_data[8];

int clock_speed;

//
int main(void)
{
    //System clock using PLL
    SysCtlClockSet(SYSCTL_USE_PLL|SYSCTL_OSC_MAIN|SYSCTL_XTAL_16MHZ|SYSCTL_SYSDIV_2_5);
    clock_speed=SysCtlClockGet();

    // enable clocks
    SYSCTL_RCGCPWM_R |= 1;   // clock enable pwm0
    SYSCTL_RCGCGPIO_R |= 0x3B; /* enable clock to PF, PE ,PD and PB PA */
    SYSCTL_RCGCADC_R |= 1;       /* enable clock to ADC0 */

    GPIO_Config();
    ADC_Config();
    PWM_Config();
    sinegen();
    Switch_PF_config();
    LED_PF_config();

    Controller_init();
    fault_pin_0enb=1;
    EnableInterrupts();
    while(1)
    {
        // fault tolerant feature
       fault_pin_0enb=(GPIO_PORTA_DATA_R & 0x08)>>3;
        if(relay_button==1)
        {
            GPIO_PORTA_DATA_R|=0xE0;
            LED_color(3) ;
        }
        else
        {
            GPIO_PORTA_DATA_R&=~0xE0;
            LED_color(2) ;
        }

        if(pwm_button==1&& fault_pin_0enb==1)
        {
            if(relay_button==1){
            GPIO_PORTA_DATA_R|=0x10;
            PWM0_ENABLE_R=0x3F;
            LED_color(4) ;
            }
            else
            {pwm_button=0;}

        }else{
            if(fault_pin_0enb==0)
            {
                pwm_button=0;
                relay_button=0;
                LED_color(1) ;
            }
            GPIO_PORTA_DATA_R&=~0x10;
            PWM0_ENABLE_R=0;

        }


    }
    return 0;
}
void PWM_Config()
{
    PWM0_0_CTL_R=0x00000002;
    PWM0_1_CTL_R=0x00000002;
    PWM0_2_CTL_R=0x00000002;

    PWM0_0_GENA_R=0xE0;
    PWM0_1_GENA_R=0xE0;
    PWM0_2_GENA_R=0xE0;
  //  PWM0_3_GENA_R=0x0B0;

    PWM0_0_GENB_R=0xB00;
    PWM0_1_GENB_R=0xB00;
    PWM0_2_GENB_R=0xB00;
   // PWM0_3_GENB_R=0xB00;

    PWM0_0_LOAD_R=4000;
    PWM0_1_LOAD_R=4000;
    PWM0_2_LOAD_R=4000;


  //  PWM0_0_CMPA_R=500;
    //PWM0_1_CMPA_R=500;
    //PWM0_2_CMPA_R=500;

   // PWM0_0_CMPB_R=400;
   // PWM0_1_CMPB_R=400;
   // PWM0_2_CMPB_R=400;

    // Dead-Band Enable
    PWM0_0_DBCTL_R=1;
    PWM0_1_DBCTL_R=1;
    PWM0_2_DBCTL_R=1;

    PWM0_0_DBRISE_R=80;
    PWM0_1_DBRISE_R=80;
    PWM0_2_DBRISE_R=80;

    PWM0_0_DBFALL_R=80;
    PWM0_1_DBFALL_R=80;
    PWM0_2_DBFALL_R=80;

    //interrupt with pwm0_0
    PWM0_INTEN_R=1;
    PWM0_ISC_R=1;

    PWM0_0_INTEN_R=0x0101;    // when count =0
    PWM0_0_ISC_R |= 0x01;

    PWM0_0_CTL_R=0x00000003;
    PWM0_1_CTL_R=0x00000003;
    PWM0_2_CTL_R=0x00000003;

    //PWM0_ENABLE_R=0x3F;

    NVIC_PRI2_R = (NVIC_PRI2_R & 0xFF1FFFFF) | 0x00200000; /*  priority 5 */
    NVIC_EN0_R = 0x00000400;

//    EnableInterrupts();

}
void ADC_Config(void)
{
    // initialize ADC0 with Seq 0 and pwm0 trigger
        ADC0_ACTSS_R =0;          // disable SS0 during configuration
        ADC0_PC_R=0x07;
        ADC0_EMUX_R &= ~0x000F;        // software trigger mask
        ADC0_EMUX_R |= 0x0006;       // PWM gen 0 trigger conversion seq 0
        ADC0_TSSEL_R = 0 ;          // select source for PWM module 0
        ADC0_SSMUX0_R = 0x76543210 ;           // get 7 inputs from channel 0-6
        ADC0_SSCTL0_R = 0x60000000 ;       // take one sample at a time, set flag at 1st sample
        ADC0_ACTSS_R = 1 ;           // enable ADC0 sequencer 0

}

void GPIO_Config(void)
{
    GPIO_PORTE_AFSEL_R =0x30;   //Port e pin 4 and 5 alternate function select

    GPIO_PORTB_AFSEL_R =0xF0;   // Port B pin  4 5 6 7 alternate function select


    GPIO_PORTE_PCTL_R=0x00440000;
    GPIO_PORTB_PCTL_R=0x44440000;
   // SYSCTL_RCC_R &=~0x100000;
    SYSCTL_RCC_R =(SYSCTL_RCC_R & ~0x1E0000)|0x120000;

    GPIO_PORTE_DEN_R |= 0x30;
    GPIO_PORTB_DEN_R |= 0xF0;

    // initialize PE3-0 for 4 input
    GPIO_PORTE_AFSEL_R |= 0x0F;   // enable alternate function
    GPIO_PORTE_DEN_R &= ~0x0F;    // disable digital function
    GPIO_PORTE_AMSEL_R |= 0x0F;   // enable analog function

    // initialize PD3-0 for 3 input
    GPIO_PORTD_AFSEL_R |= 0x0F;   // enable alternate function
    GPIO_PORTD_DEN_R &= ~0x0F;    // disable digital function
    GPIO_PORTD_AMSEL_R |= 0x0F;   // enable analog function

    // init for GPIO toggling for time checking O/P PD7
    GPIO_PORTD_DEN_R |=0x40;
    GPIO_PORTD_DIR_R |=0x40;

    // init PA7:5 for Relay1,2,3 O/P and init PA4:3 for pwm enb O/P and error I/P
    GPIO_PORTA_DEN_R |=0xF8;
    GPIO_PORTA_DIR_R |=0xF0;
    GPIO_PORTA_PDR_R |=0x08;


}

void PWM_ISR(void)
{
    GPIO_PORTD_DATA_R|=0x40;



       // start a conversion sequence 3
       while((ADC0_RIS_R & 1) == 0)    // look for end of conv for seq 0
            ;
       for (int i=0; i<8; i++)
        {
            if ((ADC0_SSFSTAT0_R & 0x100 ) == 0)    // look for non empty flag
                adc_data[i] = ADC0_SSFIFO0_R ;    // read conversion data
        }
        ADC0_ISC_R = 1 ;
        Controller_computation();


        GPIO_PORTD_DATA_R&=~0x40;
        PWM0_0_ISC_R |= 0x01;



}

void delayUs(int n)
{
    int i, j;
    for(i = 0 ; i < n; i++)
        for(j = 0; j < 3; j++) {}   /* do nothing for 1 ms */
}

void EnableInterrupts(void)
{
    __asm  ("    CPSIE  I\n");
}
