/* File: Master FSM for Washing Machine DRIVER for TIVA-C series board
   Generated by : Subhajit M
   purpose : Washing Machine Assignment of E3 257 course
   date : 07-04-2022
*/
#if 1
#include <stdbool.h>
#include <stdint.h>
#include <inc/tm4c123gh6pm.h>
#include "SWITCH_button.h"

void Switch_PF_config(void)
{

   // SYSCTL_RCGC2_R |= 0x00000020;   /* 1) activate clock for Port F */

    GPIO_PORTF_LOCK_R = 0x4C4F434B;  /* 2) unlock GPIO Port F */
    GPIO_PORTF_CR_R |= 0x11;         /* allow changes to PF4,0 */
    GPIO_PORTF_AMSEL_R &= 0x00;      /* 3) disable analog on PF */
    GPIO_PORTF_PCTL_R &= 0x00;      /* 4) PCTL GPIO on PF4-0 */
    GPIO_PORTF_DIR_R &= ~0x11;        /* 5) PF4,PF0 in, PF3-1 out */
    GPIO_PORTF_AFSEL_R &= 0x00;      /* 6) disable alt funct on PF7-0 */
    GPIO_PORTF_PUR_R |= 0x11;        /* enable pull-up on PF0 and PF4 */
    GPIO_PORTF_DEN_R |= 0x11;        /* 7) enable digital I/O on PF4-0 */

    GPIO_PORTF_IS_R &= ~0x11;       /*  PF4 PF0 is edge-sensitive */
    GPIO_PORTF_IBE_R &= ~0x11;      /*  PF4 PF0 is not both edges */
    GPIO_PORTF_IEV_R &= ~0x11;      /*  PF4 PF0 falling edge event */
    GPIO_PORTF_ICR_R = 0x11;        /*  Clear flag4 flag0 */
    GPIO_PORTF_IM_R |= 0x11;        /*  arm interrupt on PF4 PF0*/
    NVIC_PRI7_R = (NVIC_PRI7_R & 0xFF1FFFFF) | 0x00A00000; /*  priority 5 */
    NVIC_EN0_R = 0x40000000;        /*  Enable interrupt 30 in NVIC */

    sw2_flag = 0 ;
    sw1_flag = 0 ;
}

void GPIOPortF_SW_ISR_Handler(void)
{
    volatile int readback;
    volatile int sw1_int, sw2_int ;

    sw1_int = GPIO_PORTF_MIS_R & 0x10; // read the PF4 int status
    sw2_int = GPIO_PORTF_MIS_R & 0x01; // read the PF0 int status



    if (sw1_int==16)
    {
        if (sw1_flag==0) {
            sw1_flag = 1 ;
            pwm_button = 1;  // pwm enb
        }
        else {
            sw1_flag = 0 ;
            pwm_button = 0;  //
        }

    }
    else if (sw2_int==1)
    {
        if (sw2_flag==0) {
            sw2_flag = 1 ;
            relay_button = 1;  // relay enb
        }
        else {
            sw2_flag = 0 ;
            relay_button = 0;  //
        }
    }

    delayUs(50);

    GPIO_PORTF_ICR_R = 0x11;        /* clear PF4 PF0 int */
    readback = GPIO_PORTF_ICR_R;    /* a read to force clearing of interrupt flag */
    readback = readback;            /* suppress compiler warning "unused variable" */
}

#endif
