/*
 * main.c
 *
 *  Created on: 29-March-2022
 *      Author: subha
 */

/* read potentiometer voltage value from GPIO PE3, using ADC0 sequencer 3 ,
 * and display the ADC count on seven segment display
 * On board : short 3,4 of J7 (for pot), short 1,3 of J5 (for display)
 */


#include <stdint.h>
#include <stdbool.h>
#include <string.h>
#include "inc/tm4c123gh6pm.h"
#include <math.h>
#include<SWITCH_button.h>
#include <CONTROLLER.h>
#define N 500
float V[12][N];
int CC;
float a=0;
float dc_gain=0.3006;
float dc_offset=10.75;
float ma=0,mb=0,mc=0;
float two_vdc=0;
/////////////////////////////////////
float Kp_pll = 15,Ki_pll =1500, error_pll=0.0,integral_pll=0.0,theta=0.0,omega_pll=0.0, Vt=0.0, vd_avg=0.0,vq_avg=0.0;
float Van,Vbn,Vcn;
float cn,sn,cn120,sn120,cn240,sn240;
float scaling=0.0025;
int offset=3110;
float frequency=0; f=0;
void Controller_computation(void)
{


    Vab = (adc_data[0]-V_MEAS_C)*V_MEAS_M ;
    Vbc = (adc_data[1]-V_MEAS_C)*V_MEAS_M ;
    Vca = (adc_data[2]-V_MEAS_C)*V_MEAS_M ;
    Ia = (adc_data[3]-offset)*scaling ;
    Vdc = (adc_data[4])*dc_gain-dc_offset;
    Ib = -(adc_data[5]-offset)*scaling ;
   // Vdc = (adc_data[6])*0.0762;
    Ic=-(Ia+Ib);
    Van = (Vab-Vca)*0.3333;
    Vbn = (Vbc-Vab)*0.3333;
    Vcn = (Vca-Vbc)*0.3333;
    two_vdc=2/Vdc;
    //Vt = sqrt(((Vab*Vab)+(Vbc*Vbc)+(Vca*Vca))*0.3333);
    if(Vdc>VDC_MAX_LIMIT)
    {
        relay_button=0;
        pwm_button=0;
    }
/*
    cn    = cos(theta);
    cn120 = cos(theta+(0.6666*pi));
    cn240 = cos(theta-(0.6666*pi));
    sn    = sin(theta);
    sn120 = sin(theta+(0.6666*pi));
    sn240 = sin(theta-(0.6666*pi));
*/
    //////
#if 1
        cn    = cos(theta);
        sn    = sin(theta);
       // cn120 = cos(theta-(2.0931));
           cn120=cn*cos120+sn*sin120;
      //  cn240 = cos(theta+(2.0931));
           cn240=cn*cos120-sn*sin120;
      //  sn120 = sin(theta-(2.0931));
           sn120=sn*cos120-cn*sin120;
     //   sn240 = sin(theta+(2.0931));
           sn240=sin120*cn+cos120*sn;
    //////
           vab_f=(Van*FILTER_B1)+(vab_1*FILTER_B2)-(vab_f_1*FILTER_A2); vab_1=Van; vab_f_1=vab_f;
            vbc_f=(frequency*FILTER_B1)+(vbc_1*FILTER_B2)-(vbc_f_1*FILTER_A2); vbc_1=Vbn; vbc_f_1=vbc_f;
            vca_f=(Vcn*FILTER_B1)+(vca_1*FILTER_B2)-(vca_f_1*FILTER_A2); vca_1=Vcn; vca_f_1=vca_f;
            f=vbc_f;
        ///////////

    V_d =- 0.6666*(Van*sn + Vbn*sn120 +Vcn*sn240);
    V_q = 0.6666*(Van*cn + Vbn*cn120 +Vcn*cn240);

    I_d =- 0.6666*(Ia*sn + Ib*sn120 +Ic*sn240);
    I_q = 0.6666*(Ia*cn + Ib*cn120 +Ic*cn240);

 //  vd_avg = vd_avg + (V_d-vd_avg)*0.001;
//    vq_avg = vq_avg + (V_q-vq_avg)*0.001;

    error_pll    = V_d;
    integral_pll = integral_pll+(tstep*error_pll);
    omega_pll    = (Kp_pll*error_pll)+(Ki_pll*integral_pll);

    theta        = theta+(omega_pll+314.1599)*tstep;
    frequency=(omega_pll+314.159)*0.159;
    if (theta>2*pi)
    {
        theta= theta-2*pi;
    }
    else if (theta<-2*pi)
    {
       theta = theta+(2*pi);
    }




#endif
#if 0
    a=a+314.159*0.0004;
    if (a>2*pi)
        {
            a= a-2*pi;
        }
        else if (a<-2*pi)
        {
           a = a+(2*pi);
        }
#endif
#if 1
    V[0][CC]=Van;
    V[1][CC]=Vbn;
    V[2][CC]=Vcn;
    V[3][CC]=Ia;
    V[4][CC]=Ib;
    V[5][CC]=Ic;
    V[6][CC]=V_d;
    V[7][CC]=V_q;
    V[8][CC]=vab_f;
    V[9][CC]=frequency;
    V[10][CC]=theta;
    V[11][CC]=Vdc;
        CC++;
    if (CC == N)
        {CC = 0;}
#endif
#if 1


    V_dc_error = V_dc_star -Vdc ;
   // I_q_star = I_d_star0 + ID_KP*(V_dc_error - V_dc_error0) + ID_KI*(V_dc_error)*Ts ;
    I_q_star=V_KP*V_dc_error+V_KI*V_dc_error0;
    if (I_q_star >= IQ_START_LIMIT)
        I_q_star = IQ_START_LIMIT ;
    else if (I_q_star <= -IQ_START_LIMIT)
        I_q_star = -IQ_START_LIMIT ;
    else
    {
        V_dc_error0 = V_dc_error+tstep*V_dc_error;
    }
    // Iq Current Controller
    I_q_error = I_q_star - I_q;
   // V_q_star = V_q_star0 + VQ_KP*(I_q_error - I_q_error0) + VQ_KI*(I_q_error)*Ts ;
    V_q_star=(IQ_KP*I_q_error+IQ_KI*I_q_error0+V_q)*(2/Vdc);
       if (V_q_star >= VQ_START_LIMIT)
           V_q_star = VQ_START_LIMIT ;
       else if (V_q_star <= -VQ_START_LIMIT)
           V_q_star = -VQ_START_LIMIT ;
       else{
            I_q_error0 = I_q_error0+tstep*I_q_error;
       }
    // Id Current Controller
     I_d_error = I_d_star - I_d;
     // V_q_star = V_q_star0 + VQ_KP*(I_q_error - I_q_error0) + VQ_KI*(I_q_error)*Ts ;
          V_d_star=(ID_KP*I_d_error+ID_KI*I_d_error0+V_d)*(2/Vdc);
             if (V_d_star >= VD_START_LIMIT)
                 V_d_star = VD_START_LIMIT ;
             else if (V_d_star <= -VD_START_LIMIT)
                 V_d_star = -VD_START_LIMIT ;
             else{
                  I_d_error0 = I_d_error0+tstep*I_d_error;
             }
     ma = V_q_star*cn-V_d_star*sn;
     mb = V_q_star*cn120-V_d_star*sn120;
     mc = V_q_star*cn240-V_d_star*sn240;
     if(ma>1)
         ma=1;
     if(ma<-1)
         ma=-1;
     if(mb>1)
              mb=1;
     if(mb<-1)
              mb=-1;
     if(mc>1)
              mc=1;
     if(mc<-1)
          mc=-1;


     PWM0_0_CMPA_R=(int)((ma*1998)+2000);//(int)(((adc_data[0]-1861)*14)+4000) ;
     PWM0_1_CMPA_R=(int)((mb*1998)+2000);//(int)(((adc_data[1]-1861)*14)+4000) ;
     PWM0_2_CMPA_R=(int)((mc*1998)+2000);
     /*PWM0_0_CMPA_R=(int)1000;//(int)(((adc_data[0]-1861)*14)+4000) ;
     PWM0_1_CMPA_R=(int)1500;//(int)(((adc_data[1]-1861)*14)+4000) ;
     PWM0_2_CMPA_R=(int)2000;*/



#endif
}

void Controller_init(void)
{
    Vab = 0;
    Vbc = 0;
    Vca = 0;
    Ia = 0;
    Ib = 0;
    Ic = 0;
    Vdc = 0;
    Theta = 0 ;
    Ts = 0.0002;
    a0 = 0 ;
    Theta0 =0;
    //V_q0 = 10.2;
    I_d_star0 = 0;
    V_dc_error0 = 0;
    V_d_star0 = 57.7;
    V_dc_star=100;
    I_d_error0 = 0;
    V_q_star0 = 0;
    I_q_error0 =  0;
    vab_f=0;
    vab_f_1=0;
    vab_1=0;
    vbc_f=0;
    vbc_f_1=0;
    vbc_1=0;
    vca_f=0;
    vca_f_1=0;
    vca_1=0;
    CC=0;
    V_KP=0.0866;
    V_KI=4.5344;
    ID_KP=8.6394;
    ID_KI=4523;
    IQ_KP=8.6394;
    IQ_KI=4523;

    //PROTECTION
    VDC_MAX_LIMIT=160;
    relay_button=0;
    pwm_button=0;



}

float SinCos_conv(float angle_r, int sin_flag)
{
    int angle_d ;
        angle_d = (int)(angle_r * 572.957795131+0.05) ;

        //angle_d = (int)(angle_r * 57.2957795131+0.5) ;

  /*  if (sin_flag == 1)
        angle_d = (int)(angle_r * 57.2957795131+0.5) ;
    else
        angle_d = 90 - (int)(angle_r * 57.2957795131+0.5) ;*/

    if ((0 <= angle_d) && (angle_d <= 900))
    {   if(sin_flag==1)
        return SIN_table[angle_d] ;
        else
        return SIN_table[900-angle_d] ;
    }
    else if ((900 < angle_d) && (angle_d <= 1800))
    {
        if(sin_flag==1)
            return SIN_table[1800-angle_d] ;
        else
            return (-SIN_table[900-(1800-angle_d)]) ;
    }

    else if ((1800 < angle_d) && (angle_d <= 2700))
    {
         if(sin_flag==1)
            return (-SIN_table[angle_d-1800]) ;
         else
            return (-SIN_table[900-(angle_d-1800)]) ;
    }

    else if ((2700 < angle_d) && (angle_d <= 3600))
    {
          if(sin_flag==1)
             return (-SIN_table[3600-angle_d]) ;
          else
             return (SIN_table[900-(3600-angle_d)]) ;
     }

}

void sinegen(void)
{
    //float angle = 0 ;
    sin120=sin(2.0931);
    cos120=cos(2.0931);
 /*   for(int i;i<901;i++)
    {
        SIN_table[i] = sin(angle*M_PI/180);
        angle = angle+0.1 ;
    }
    */
}
