/*****************************************************
 *
 * ECCLib ECSM Test Code
 *
 * Last Modified: 2022 May 02
 *
 */

#include "ECCLib.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <./inc/tm4c123gh6pm.h>
#include "UART_Driver.h"
#include "GPTM_module.h"

int main ( )
{
    int ret,len;
    int start, stop;
    char val[3];
    long cc_encrypt,cc_decrypt,cc_search, cc_aggregation;

    UART_Init(
        0,          /* UART port number as per chip */
        115200,      /* baudrate not all may be supported */
        FIFO_ENABLE,
        UART_PARITY_NONE) ;/* parity enable 0- none, 1-odd, 2-even, 3-mark, 4-space */


    struct ecclib_ecp G, H, M, C_1, C_2, C1_1, C1_2, C2_1, C2_2;
    struct ecclib_mpi sk, r, msg;
    struct ecclib_mpi param_a, param_b, order, prime;
    //if n is the order of the elliptic curve. The
    //scalar for point multiplication is chosen as a number between 0 and n – 1

    ecclib_mpi_init( &param_a );
    ecclib_mpi_init( &param_b );
    ecclib_mpi_init( &order );
    ecclib_mpi_init( &prime );

    ecclib_mpi_init( &sk );
    ecclib_mpi_init( &r );
    ecclib_mpi_init( &msg );

    ecclib_ecp_init( &G );
    ecclib_ecp_init( &H );
    ecclib_ecp_init( &M );
    ecclib_ecp_init( &C_1 );
    ecclib_ecp_init( &C_2 );
    ecclib_ecp_init( &C1_1 );
    ecclib_ecp_init( &C1_2 );
    ecclib_ecp_init( &C2_1 );
    ecclib_ecp_init( &C2_2 );

    // Prime p
    prime.p[7] = 0xFFFFFFFF; prime.p[6] = 0x00000001; prime.p[5] = 0x00000000; prime.p[4] = 0x00000000;
    prime.p[3] = 0x00000000; prime.p[2] = 0xFFFFFFFF; prime.p[1] = 0xFFFFFFFF; prime.p[0] = 0xFFFFFFFF;

    // Order n
    order.p[7] = 0xFFFFFFFF; order.p[6] = 0x00000000; order.p[5] = 0xFFFFFFFF; order.p[4] = 0xFFFFFFFF;
    order.p[3] = 0xBCE6FAAD; order.p[2] = 0xA7179E84; order.p[1] = 0xF3B9CAC2; order.p[0] = 0xFC632551;

    // Curve Param a
    param_a.p[7] = 0xFFFFFFFF; param_a.p[6] = 0x00000001; param_a.p[5] = 0x00000000; param_a.p[4] = 0x00000000;
    param_a.p[3] = 0x00000000; param_a.p[2] = 0xFFFFFFFF; param_a.p[1] = 0xFFFFFFFF; param_a.p[0] = 0xFFFFFFFC;

    // Curve Param b
    param_b.p[7] = 0x5AC635D8; param_b.p[6] = 0xAA3A93E7; param_b.p[5] = 0xB3EBBD55; param_b.p[4] = 0x769886BC;
    param_b.p[3] = 0x651D06B0; param_b.p[2] = 0xCC53B0F6; param_b.p[1] = 0x3BCE3C3E; param_b.p[0] = 0x27D2604B;

    // Secret Key sk
    sk.p[7] = 7; sk.p[6] = 6; sk.p[5] = 5; sk.p[4] = 4;
    sk.p[3] = 3; sk.p[2] = 2; sk.p[1] = 1; sk.p[0] = 0;

    // Random Scalar r
    r.p[7] = 0xFFFFFFFF; r.p[6] = 0x00000000; r.p[5] = 0xFFFFFFFF; r.p[4] = 0xFFFFFFFF;
    r.p[3] = 0xBCE6FAAD; r.p[2] = 0xA7179E84; r.p[1] = 0xF3B9CAC2; r.p[0] = 0;

    // Secret Key msg
    msg.p[7] = 0; msg.p[6] = 0; msg.p[5] = 0; msg.p[4] = 0;
    msg.p[3] = 0; msg.p[2] = 0; msg.p[1] = 0; msg.p[0] = 0;

    // Generator Point G
    G.inf = 0;
    G.X.p[7] = 0x6B17D1F2; G.X.p[6] = 0xE12C4247; G.X.p[5] = 0xF8BCE6E5; G.X.p[4] = 0x63A440F2;
    G.X.p[3] = 0x77037D81; G.X.p[2] = 0x2DEB33A0; G.X.p[1] = 0xF4A13945; G.X.p[0] = 0xD898C296;
    G.Y.p[7] = 0x4FE342E2; G.Y.p[6] = 0xFE1A7F9B; G.Y.p[5] = 0x8EE7EB4A; G.Y.p[4] = 0x7C0F9E16;
    G.Y.p[3] = 0x2BCE3357; G.Y.p[2] = 0x6B315ECE; G.Y.p[1] = 0xCBB64068; G.Y.p[0] = 0x37BF51F5;

    timer_cycle_count=0;
    timer1A_Init();
    start=TIMER1_TAR_R;
	
	// Elliptic Curve ElGamal Additively Homomorphic Encryption
	
	// KeyPair Generation
	ret = ecclib_ecp_affine_scalar_mul( &H, &G, &sk, &param_a, &param_b, &order, &prime );
	
	// Encryption of msg1 = 16
	r.p[0] = 1;
    msg.p[0] = 16;
	ret = ecclib_ecp_affine_scalar_mul( &C1_1, &G, &r, &param_a, &param_b, &order, &prime );
	ret = ecclib_ecp_affine_scalar_mul( &C1_2, &H, &r, &param_a, &param_b, &order, &prime );
	ret = ecclib_ecp_affine_scalar_mul( &M, &G, &msg, &param_a, &param_b, &order, &prime );
	ecclib_ecp_affine_add( &C1_2, &C1_2, &M, &param_a, &prime );
	
    stop=TIMER1_TAR_R;
    TIMER1_CTL_R = 0;
    cc_encrypt=start-stop+(timer_cycle_count <<16);
    cc_encrypt=cc_encrypt;

    print_str_uart("Secret key (x): \r\n");
    ecclib_mpi_print (&sk);
    print_str_uart("Public key (xG): \r\n");
    ecclib_ecp_print (&H);
    print_str_uart("Encryption of msg1: \r\n");
    print_str_uart("msg1: \r\n");
    ecclib_mpi_print (&msg);
    print_str_uart("C1_1: \r\n");
    ecclib_ecp_print (&C1_1);
    print_str_uart("C1_2: \r\n");
    ecclib_ecp_print (&C1_2);

	// Encryption of msg2 = 25
	r.p[0] = 2;
    msg.p[0] = 25;
    print_str_uart("Encryption of msg2: \r\n");
    print_str_uart("msg2: \r\n");
    ecclib_mpi_print (&msg);
	ret = ecclib_ecp_affine_scalar_mul( &C2_1, &G, &r, &param_a, &param_b, &order, &prime );
	ret = ecclib_ecp_affine_scalar_mul( &C2_2, &H, &r, &param_a, &param_b, &order, &prime );
	print_str_uart("C2_1: \r\n");
	ecclib_ecp_print (&C2_1);
	ret = ecclib_ecp_affine_scalar_mul( &M, &G, &msg, &param_a, &param_b, &order, &prime );
	ecclib_ecp_affine_add( &C2_2, &C2_2, &M, &param_a, &prime );
	print_str_uart("C2_2: \r\n");
	ecclib_ecp_print (&C2_2);
	
	print_str_uart("Encrypted aggregated ciphertext: \r\n");
    timer_cycle_count=0;
    timer1A_Init();
    start=TIMER1_TAR_R;

	// Aggregation in Encrypted Domain
	ecclib_ecp_affine_add( &C_1, &C1_1, &C2_1, &param_a, &prime );
	ecclib_ecp_affine_add( &C_2, &C1_2, &C2_2, &param_a, &prime );
	
    stop=TIMER1_TAR_R;
    TIMER1_CTL_R = 0;
    cc_aggregation=start-stop+(timer_cycle_count <<16);
    cc_aggregation=cc_aggregation;

    print_str_uart("C_1 aggregated: \r\n");
    ecclib_ecp_print (&C_1);
    print_str_uart("C_2 aggregated: \r\n");
    ecclib_ecp_print (&C_2);

    print_str_uart("Decryption of aggregated msg: \r\n");

    timer_cycle_count=0;
    timer1A_Init();
    start=TIMER1_TAR_R;

	// Decryption
	ret = ecclib_ecp_affine_scalar_mul( &C_1, &C_1, &sk, &param_a, &param_b, &order, &prime );
	msg.p[0] = 0; // proxy for zero
	ecclib_fp_sub( &C_1.Y, &msg, &C_1.Y, &prime );// J-K=J+(-K), where, -k=(Xk, -Yk mod p)
	ecclib_ecp_affine_add( &M, &C_2, &C_1, &param_a, &prime );
	
    stop=TIMER1_TAR_R;
    TIMER1_CTL_R = 0;
    cc_decrypt=start-stop+(timer_cycle_count <<16);
    cc_decrypt=cc_decrypt;

    print_str_uart("msg*G: \r\n");
    ecclib_ecp_print (&M);

    timer_cycle_count=0;
    timer1A_Init();
    start=TIMER1_TAR_R;

	uint32_t i, mu = 0;
	for (i = 1; i < 63; i++)
	{
		msg.p[0] = i;
		ret = ecclib_ecp_affine_scalar_mul( &H, &G, &msg, &param_a, &param_b, &order, &prime );
		if( ret == 0 && ( ecclib_mpi_cmp_mpi( &H.X, &M.X ) == 0 ) &&  ( ecclib_mpi_cmp_mpi( &H.Y, &M.Y ) == 0 ) )
		{
			mu = i;
			break;
		}
	}

    stop=TIMER1_TAR_R;
    TIMER1_CTL_R = 0;
    cc_search=start-stop+(timer_cycle_count <<16);
    cc_search=cc_search;
     mu=mu;
     itoa(mu,val,10);
     len=strlen(val);
     print_str_uart("Decrypted aggregated message: ");
     UART_Write_Blocking(
            0,           /* port identifier */
            len,           /* max number of bytes that should be written */
            val);        /* buffer to be used to write into FIFO */
    while(1);

}
