
/**
 ** UART functions
 **/
 
#define UART_PARITY_NONE				0x00
#define UART_PARITY_ODD				    0x02
#define UART_PARITY_EVEN				0x06
#define UART_PARITY_MARK			    0x82
#define UART_PARITY_SPACE				0x86
#define FIFO_ENABLE                     0x70
#define FIFO_DISABLE                    0x60
    
/* 
 * initialize UART based on the port number, baudrate and parity type
 * 
 * returns 0 if no error and opened properly else error no indicating error type
 * */
int UART_Init(
    int iPort,          /* UART port number as per chip */
    int iBaudRate,      /* baudrate not all may be supported */
    int iFIFO_E_D,       /*Fifo enabled or disabled info*/
    int iParity_NOEMS); /* parity enable 0- none, 1-odd, 2-even, 3-mark, 4-space */

/* 
 * UART write - send chars through UART using buffer and count passed as parameters. If the FIFO is 
 * full return back with number of bytes that was successfully added to FIFO (Non blocking)
 * 
 * returns number of bytes actually transferred 
 * */

int UART_Write(
    int iPort,						/* port identifier */
    int iBytes,						/* max number of bytes that should be written */
    unsigned char *pcBytes);		/* buffer to be used to write into FIFO */

/*
 * UART Read a character from UART FIFO (non blocking). IF fifo does not have sufficient bytes then function 
 * reads available bytes and returns the count of bytes that was read
 * 
 * return number of bytes actually read
 * */

int UART_Write_Blocking(
    int iPort,                      /* port identifier */
    int iBytes,                     /* max number of bytes that should be written */
    unsigned char *pcBytes)  ;   /* buffer to be used to write into FIFO */


int UART_Read(
    int iPort,						/* port identifier */
    int iBytes,						/* max number of bytes that should be read */
    unsigned char *pcBytes);		/* buffer to be used to read into FIFO */
	
/*
 * UART BytesInRx - returns number of bytes available in RX fifo that can be read
 * 
 * return number of bytes in the RX fifo
 * */

int UART_BytesInRx(
    int iPort);					/* port identifier */

int UART_BytesInTx(
    int iPort)    ;             /* port identifier */
