#include <stdint.h>
#include <stdbool.h>
#include <./inc/tm4c123gh6pm.h>
#include <UART_Driver.h>

int UART_Init(
    int iPort,          /* UART port number as per chip */
    int iBaudRate,      /* baudrate not all may be supported */
    int iFIFO_E_D,       /*Fifo enabled or disabled info*/
    int iParity_NOEMS) /* parity enable 0- none, 1-odd, 2-even, 3-mark, 4-space */
{
    unsigned long uart_addr;
    uart_addr=(0x4000C000+((0x00001000)*iPort));
    double temp_i;
    int temp_k;
    int temp_f;
    temp_i=(1000000.0/iBaudRate);
    temp_k=1000000/iBaudRate;
    temp_f=((temp_i-temp_k)*64)+0.5;
    switch (iPort)
   {
    case 0:
      SYSCTL_RCGCUART_R|= 0x01;  /* enable clock to UART0 */
      SYSCTL_RCGCGPIO_R |= 0x01;  /* enable clock to PORTA*/
      GPIO_PORTA_DEN_R |= 0x03; /* Make PA0 and PA1 as digital */
      GPIO_PORTA_AFSEL_R |= 0x03;/* Use PA0,PA1 alternate function */
      GPIO_PORTA_PCTL_R |= 0x00000011 ;// PA0 and PA1 configure for UART module
      break;
      
    case 1:
      SYSCTL_RCGCUART_R |= 0x02;  /* enable clock to UART1 */
      SYSCTL_RCGCGPIO_R |= 0x02;  /* enable clock to PORTB*/
      GPIO_PORTB_DEN_R |= 0x03; /* Make PB0 and PB1 as digital */
      GPIO_PORTB_AFSEL_R = 0x03;/* Use PB0,PB1 alternate function */
      GPIO_PORTB_PCTL_R |= 0x00000011 ;// PB0 and PB1 configure for UART module
      break;
      
    case 2:
      SYSCTL_RCGCUART_R |= 0x04;  /* enable clock to UART2 */
      SYSCTL_RCGCGPIO_R |= 0x08;  /* enable clock to PORTD*/
      GPIO_PORTD_DEN_R |= 0xC0; /* Make PD6 and PD7 as digital */
      GPIO_PORTD_AFSEL_R |= 0xC0;/* Use PD6,PD7 alternate function */
      GPIO_PORTD_PCTL_R|= 0x11000000 ;// PD6 and PD7 configure for UART module
      break;
      
    case 3:
      SYSCTL_RCGCUART_R |= 0x08;  /* enable clock to UART3 */
      SYSCTL_RCGCGPIO_R |= 0x04;  /* enable clock to PORTC*/
      GPIO_PORTC_DEN_R |= 0xC0; /* Make PC6 and PC7 as digital */
      GPIO_PORTC_AFSEL_R |= 0xC0;/* Use PC6,PC7 alternate function */
      GPIO_PORTC_PCTL_R |= 0x11000000 ;// PC6 and PC7 configure for UART module
      break;
      
   case 4:
      SYSCTL_RCGCUART_R |= 0x10;  /* enable clock to UART4 */
      SYSCTL_RCGCGPIO_R |= 0x04;  /* enable clock to PORTC*/
      GPIO_PORTC_DEN_R |= 0x30; /* Make PC4 and PC5 as digital */
      GPIO_PORTC_AFSEL_R |= 0x30;/* Use PC4,PC5 alternate function */
      GPIO_PORTC_PCTL_R |= 0x00110000 ;// PC4 and PC5 configure for UART module
      break;
      
    case 5:
      SYSCTL_RCGCUART_R |= 0x20;  /* enable clock to UART5 */
      SYSCTL_RCGCGPIO_R |= 0x10;  /* enable clock to PORTE*/
      GPIO_PORTE_DEN_R |= 0x30; /* Make PE4 and PE5 as digital */
      GPIO_PORTE_AFSEL_R |= 0x30;/* Use PE4,PE5 alternate function */
      GPIO_PORTE_PCTL_R|= 0x00110000 ;// PE4 and PE5 configure for UART module
      break;
    
    case 6:
      SYSCTL_RCGCUART_R |= 0x40;  /* enable clock to UART6 */
      SYSCTL_RCGCGPIO_R|= 0x08;  /* enable clock to PORTD*/
      GPIO_PORTD_DEN_R |= 0x30; /* Make PD4 and PD5 as digital */
      GPIO_PORTD_AFSEL_R |= 0x30;/* Use PD4,PD5 alternate function */
      GPIO_PORTD_PCTL_R|= 0x00110000 ;// PD4 and PD5 configure for UART module
      break;
    
    case 7:
      SYSCTL_RCGCUART_R |= 0x80;  /* enable clock to UART7 */
      SYSCTL_RCGCGPIO_R |= 0x10;  /* enable clock to PORTE*/
      GPIO_PORTE_DEN_R |= 0x03; /* Make PE0 and PE1 as digital */
      GPIO_PORTE_AFSEL_R |= 0x03;/* Use PE0,PE1 alternate function */
      GPIO_PORTE_PCTL_R|= 0x00000011 ;// PE0 and PE1 configure for UART module
      break;
      
    default:
      ;// default statements
    }
          *((volatile uint32_t *)(uart_addr+0x030)) = 0; //UART_CTL=uart_addr+0x030;
          *((volatile uint32_t *)(uart_addr+0x024))=temp_k ; //UART_IBRD=uart_addr+0x024;
          *((volatile uint32_t *)(uart_addr+0x028))= temp_f; //UART_FBRD=uart_addr+0x028;
          *((volatile uint32_t *)(uart_addr+0xFC8)) = 0;  //UART_CC=uart_addr+0xFC8;
          *((volatile uint32_t *)(uart_addr+0x02C))= (iFIFO_E_D|iParity_NOEMS); //UART_LCRH=uart_addr+0x02C;
          *((volatile uint32_t *)(uart_addr+0x030)) = 0x301; //UART_CTL=uart_addr+0x030;
    return 0;
}

int UART_Write(
    int iPort,                      /* port identifier */
    int iBytes,                     /* max number of bytes that should be written */
    unsigned char *pcBytes)     /* buffer to be used to write into FIFO */
{
    int i;
    unsigned long uart_addr;
        uart_addr=(0x4000C000+((0x00001000)*iPort));

                for(i=0;i<iBytes;i++)
                {
                    if(!((*((volatile uint32_t *)(uart_addr+0x018))) & (1<<5))) //TXFF bit access in Flag register UART_FR=uart_addr+0x018;
                                        {
                                  *((volatile uint32_t *)(uart_addr))= *(pcBytes+i);
                                        }
                                        else
                                        {
                                            return i;
                                        }
                }
    return iBytes;

}

int UART_Write_Blocking(
    int iPort,                      /* port identifier */
    int iBytes,                     /* max number of bytes that should be written */
    unsigned char *pcBytes)     /* buffer to be used to write into FIFO */
{
    int i;
    unsigned long uart_addr;
        uart_addr=(0x4000C000+((0x00001000)*iPort));

                for(i=0;i<iBytes;i++)
                {
                    while((*((volatile uint32_t *)(uart_addr+0x018))) & (1<<5)); //TXFF bit access in Flag register UART_FR=uart_addr+0x018;

                     *((volatile uint32_t *)(uart_addr))= *(pcBytes+i);


                }
    return iBytes;

}

int UART_Read(
    int iPort,                      /* port identifier */
    int iBytes,                     /* max number of bytes that should be read */
    unsigned char *pcBytes)     /* buffer to be used to read into FIFO */
{
    int i;
    unsigned long uart_addr;
            uart_addr=(0x4000C000+((0x00001000)*iPort));

                for(i=0;i<iBytes;i++)
                {
                    if(!((*((volatile uint32_t *)(uart_addr+0x018))) & (1<<4))) //RXFE bit access in Flag register
                                        {
                                            *(pcBytes+i)=*((volatile uint32_t *)(uart_addr));
                                        }
                                        else
                                        {
                                            return i;
                                        }
                }
      return iBytes;
}

int UART_BytesInRx(
    int iPort)                 /* port identifier */
{
    unsigned long uart_addr;
                uart_addr=(0x4000C000+((0x00001000)*iPort));

                    if((*((volatile uint32_t *)(uart_addr+0x018))) & (1<<4)) //RXFE bit access in Flag register
                        {
                            return 0;
                        }
                        else
                        {
                            return 1;
                        }
}

int UART_BytesInTx(
    int iPort)                 /* port identifier */
{
    unsigned long uart_addr;
                uart_addr=(0x4000C000+((0x00001000)*iPort));

                    if((*((volatile uint32_t *)(uart_addr+0x018))) & (1<<5)) //TXFF bit access in Flag register
                        {
                            return 1;
                        }
                        else
                        {
                            return 0;
                        }
}
    
