/*
 * GPTM_module.c
 *
 *  Created on: 24-Mar-2022
 *      Author: faiek
 */

/* Timer1 subtimer A interrupt service routine */
#include <stdint.h>
#include <./inc/tm4c123gh6pm.h>
#include "GPTM_module.h"

void TIMER1A_Handler(void)
{
      if(TIMER1_MIS_R & 0x1)
      {
          timer_cycle_count+=1;
      }
        TIMER1_ICR_R = 0x1;          /* Timer1A timeout flag bit clears*/
}

void timer1A_Init(void)
{
    SYSCTL_RCGCTIMER_R |= 2;        /* enable clock to Timer Block 1 */
    TIMER1_CTL_R = 0;               /* disable Timer before initialization */
    TIMER1_CFG_R = 0x04;            /* 16-bit option */
    TIMER1_TAMR_R = 0x02;           /* periodic mode and down-counter */
    TIMER1_TAILR_R = 65535;         /* TimerA interval load value reg */
    TIMER1_ICR_R = 0x1;             /* clear the TimerA timeout flag */
    TIMER1_IMR_R= (1<<0);           /* enables TimerA timeout interrupt*/
    TIMER1_CTL_R |= 0x01;           /* enable Timer A after initialization */
    NVIC_EN0_R |= (1<<21);          /*enable IRQ21*/
}

void timer_disable(void)
{
    TIMER1_CTL_R = 0;
}


