#include <stdint.h>
#include <stdbool.h>
#include <./inc/tm4c123gh6pm.h>
#include <inc/hw_memmap.h>
#include <inc/hw_types.h>
#include <driverlib/gpio.h>
#include <driverlib/pin_map.h>
#include <driverlib/sysctl.h>
#include <driverlib/uart.h>
#include<string.h>
#include <stdlib.h>
#include <math.h>


#define VoltageresultinV(a) (a)*(0.0008)
#define ADC_SAMPLES  5000
#define VOLTAGE_CONVERSION_FACTOR


void delay(int delayMs);
void ADC0_Initialization();
void ADC1_Initialization();
void displayNumber(int num);
void uart_initialization();
void LCD_Initialization();
void InstrEnablePulse();
void ClearLCD();
void writeStringLCD(char s[], int line);
unsigned int intToHex(int num);
float findSQRT(int number);
float dosqrt(float x);
double findCos(double y);
void writeStringLCD_concatenate(char* str);
void DataEnablePulse();


volatile uint32_t SamplesCount    = 0;
int voltage_result=0;
int voltage_temp;
int voltage_count;
int current_result;
int current_temp;
int current_count;
int current_result;
float Phasediff;
float Powerfactor;
char Powerfactor_string[10];
long long int voltage_result_square=0;
long long int voltage_result_square_sum=0;
long long int voltage_result_square_sum_save=0;
long long int current_result_square=0;
long long int current_result_square_sum=0;
long long int current_result_square_sum_save=0;
float voltage_rms=0;
float current_rms=0;
float power=0;
char power_string[10];
char voltage_rms_string[10];
char current_rms_string[10];
float voltage_result_square_sum_save_avg=0;
float current_result_square_sum_save_avg=0;
int VoltageSumReadyFlag =1;
char current_string[20];
char voltage_string[20];
char powerfactor_string[10];
char voltage[] = " Voltage is " ;
char current[] = " Current is " ;
int z;

void sendUART(char s[]){
    int i=0;
    while(s[i]!='\0'){
        UARTCharPut(UART0_BASE, s[i]);
        i++;

    }
    UARTCharPut(UART0_BASE, '\n');
    UARTCharPut(UART0_BASE, '\r');
}



int main()

{
    char s[]="";
    uart_initialization();
    UARTCharPut(UART0_BASE, 'M');
    ADC0_Initialization();
    ADC1_Initialization();
    LCD_Initialization();
    ClearLCD();
    writeStringLCD("WELCOME TO", 1);
    writeStringLCD("POWERMETER", 2);




while(1)
{
    //ADC0->PSSI |= (1<<3);        /* Enable SS3 conversion or start sampling data from AN0 */
    ADC1_PSSI_R |= 0x80000008; //Enabling GSYNC Bit on ADC 1 to start Sampling
    ADC0_PSSI_R |= 0x80000008; //Enabling GSYNC Bit on ADC 0 to start Sampling


    while(((ADC0_RIS_R & 8) == 0) && ((ADC1_RIS_R & 8) == 0));   /* Wait untill sample conversion completed*/
           voltage_result = ADC0_SSFIFO3_R; /* read adc conversion result from SS3 FIFO*/
           current_result = ADC1_SSFIFO3_R;
           voltage_temp = voltage_result;
           current_temp = current_result;
           itoa(voltage_result,s,10);
            sendUART(s);

           bzero(s,sizeof(s));
         //  itoa(voltage_result,s,10);
          // sendUART(s);
          // voltage_result_square = voltage_result*0.00080566*voltage_result*0.00080566;
           voltage_result_square = voltage_result*voltage_result;
           current_result_square = current_result*current_result;

           //gcvt(voltage_result_square, 6, voltage_rms_string);
           //sendUART(voltage_result);
           voltage_result_square_sum = voltage_result_square_sum + voltage_result_square;
           current_result_square_sum = current_result_square_sum + current_result_square;
           SamplesCount += 1;
           if(voltage_temp>voltage_result){
               voltage_count = SamplesCount;
           }
           if(current_temp>current_result){
               current_count = SamplesCount;
           }

           bzero(s,sizeof(s));
           itoa(SamplesCount,s,10);

           if ((SamplesCount == ADC_SAMPLES)) {
                   // copy the squared and summed samples result
               Phasediff = (abs(voltage_count-current_count)/ADC_SAMPLES)*360;
               Powerfactor = findCos(Phasediff);
               //snprintf(Powerfactor_string, 10, "%f", Powerfactor);
               voltage_result_square_sum_save= voltage_result_square_sum;
               voltage_result_square_sum      = 0;
               current_result_square_sum_save= voltage_result_square_sum;
               current_result_square_sum      = 0;


                  // VoltageSumReadyFlag = 0;
                   voltage_result_square_sum_save_avg = voltage_result_square_sum_save / ADC_SAMPLES;
                   current_result_square_sum_save_avg = current_result_square_sum_save / ADC_SAMPLES;

                       // Take square root for the Averaged result
                   //voltage_rms = dosqrt(voltage_result_square_sum_save_avg);
                   voltage_rms = dosqrt(voltage_result_square_sum_save_avg)*0.0008056*176;
                   current_rms = ((dosqrt(voltage_result_square_sum_save_avg)*0.0008056)/11);
                   //current_rms = dosqrt(voltage_result_square_sum_save_avg);
                   power = voltage_rms * current_rms*Powerfactor;
                   //voltage_rms = voltage_rms*0.0008;

                 gcvt(voltage_rms, 3, voltage_rms_string);
                 gcvt(current_rms, 3, current_rms_string);
                 gcvt(power, 4, power_string);
                 gcvt(Powerfactor, 3, powerfactor_string);


                 //  sprintf(voltage_rms, "%f", num);
                  // snprintf(voltage_rms_string, 10, "%f", voltage_rms);
                  // sprintf(voltage_rms_string,"%f",voltage_rms);
                   sendUART("power");
                   sendUART(voltage_rms_string);
                  // itoa(voltage_result_square_sum_save,voltage_rms_string,20);
                 //  sendUART(voltage_rms_string);
                 //  sendUART(current_rms_string);
                 //  sendUART(power_string);

                  // delay(50000);

               }
           ADC0_ISC_R = 8;           /* clear conversion clear flag bit*/
           ADC1_ISC_R = 8;

               if(SamplesCount>=ADC_SAMPLES ){
                   //for(int i=0;i<200;i++)
                    //displayNumber(voltage_rms_string);
                   char concatenate[]= "Irms = ";
                   char concatenate1[] = "Power = ";

                    itoa(current_result,current_string,10);
                    itoa(voltage_result,voltage_string,10);

                    ClearLCD();
                    //strcat(concatenate1,power_string);
                   // strcat(concatenate,voltage_rms_string);
                    //sendUART(voltage_rms_string);

                    writeStringLCD(concatenate1,1);
                    writeStringLCD_concatenate(power_string);
                    writeStringLCD_concatenate("W");

                    // GPIO_PORTF_DATA_R ^= (1<<2);







                    switch(z){
                    case 0:writeStringLCD("Irms= ",2);writeStringLCD_concatenate(current_rms_string);writeStringLCD_concatenate("A");z++;
                    break;
                    case 1:writeStringLCD("Vrms= ",2);writeStringLCD_concatenate(voltage_rms_string);writeStringLCD_concatenate("V");z++;
                    break;
                    case 2:writeStringLCD("PowerFactor= ",2);writeStringLCD_concatenate(powerfactor_string);z=0;
                    break;

                    default:writeStringLCD("Irms= ",2);writeStringLCD_concatenate(current_rms_string);z=1;
                    }


                    //writeStringLCD(concatenate,2);
                    //writeStringLCD_concatenate(current_rms_string);
                    //writeStringLCD_concatenate("A");

                    //sendUART(concatenate);
                   // writeStringLCD(concatenate,2);

                    //sendUART(power_string);
                   // writeStringLCD(" ",1);
                   // writeStringLCD(current_rms_string,1);
                    //writeStringLCD(voltage_string, 2);




                    delay(50000);
               SamplesCount=0;}



}

}



double findCos(double y){
    double x;

    double sum;
    double fa;
    double pow;
    int n =20;
    x = (3.1415926535897931*y)/180.0;
    sum = 0.0;
    for(int i = 0; i <= n; i++)
    {
    fa = 1.0;
    pow = 1.0;
    for(int j = 1; j <= 2*i; j++)
    {
    fa *= j;
    pow *= x;
    }
    sum += ((i%2?-1.0:1.0)/fa)*pow;
    }
    return sum;
    }








float dosqrt(float x)
{
float accuracy=0.0001;
float guess = 1;

do
{
guess = (guess + (x/guess))/2;
}while(abs(guess*guess-x)>=accuracy);
return guess;
}

float findSQRT(int number)
{
    int start = 0, end = number;
    int mid;

    // To store the answer
    float ans;

    // To find integral part of square
    // root of number
    while (start <= end) {

        // Find mid
        mid = (start + end) / 2;

        // If number is perfect square
        // then break
        if (mid * mid == number) {
            ans = mid;
            break;
        }

        // Increment start if integral
        // part lies on right side
        // of the mid
        if (mid * mid < number) {
          //first start value should be added to answer
            ans=start;
          //then start should be changed
            start = mid + 1;
        }

        // Decrement end if integral part
        // lies on the left side of the mid
        else {
            end = mid - 1;
        }
    }

    // To find the fractional part
    // of square root upto 5 decimal
    float increment = 0.1;
    for (int i = 0; i < 5; i++) {
        while (ans * ans <= number) {
            ans += increment;
        }

        // Loop terminates,
        // when ans * ans > number
        ans = ans - increment;
        increment = increment / 10;
    }
    return ans;
}




void delay(int delayMs)
{

    int delay = delayMs*16000;
    NVIC_ST_CTRL_R = 0; /* disable SysTick during setup */
    NVIC_ST_RELOAD_R = delay-1; /* Reload Valuvoid writeStringLCD_concatenate(char* str)e goes here */
    NVIC_ST_CTRL_R |= 0x5; /* enable SysTick with core clock */
    while( (NVIC_ST_CTRL_R & (1<<16) ) == 0); /* Monitoring bit 16 to be set */
    NVIC_ST_CTRL_R = 0; /* Disabling SysTick Timer */

}





void ADC0_Initialization(){
    SYSCTL_RCGCADC_R |= 1;// Enable Clock to ADC0
    SYSCTL_RCGC2_R|= 0x10;// Enable Clock to PORTE for taking Analog Input
    GPIO_PORTE_AFSEL_R |= 0x08; // Enable Alternate Functionality for PE3 Pin to take Analog Input
    GPIO_PORTE_DEN_R &= ~(1<<3);
    //GPIO_PORTE_DIR_R &= ~(1<<3); // Disable Digital Functionality on PE3
    GPIO_PORTE_AMSEL_R |= (1<<3); // Enable Analog Function on PE3 Pin
    ADC0_ACTSS_R &= ~8; // Disabling Sample Sequencer SS3 before configuration
    ADC0_EMUX_R &= ~0xF000; // Setting Trigger option to software
    ADC0_SSMUX3_R = 0; // Selecting SS3 SAMPLE SEQUENCER FOR AN0 INPUT
    ADC0_SSCTL3_R |= 6;
    ADC0_PP_R = 0x3; // Setting Sampling Rate to 1MSPS
    ADC0_ACTSS_R |= 8; // Enabling Sample Sequencer SS3 after configuration
   ADC0_PSSI_R |= 0x08000008; // Enabling Conversion for SS3 Sample Sequencer and Enable Sync Wait Bit
////////////////////////////////////////////////////////////////


 ////////////////////////////////////
   //// LED Initialization

    SYSCTL_RCGC2_R |= 0x00000020; /* enable clock to GPIOF at clock gating control register */
    GPIO_PORTF_DIR_R = 0x0E; /* enable the GPIO pins for the LED (PF3, 2 1) as output */
    GPIO_PORTF_DEN_R = 0x0E; /* enable the GPIO pins for digital function */

    /////////////////////////////////////////
    //7 Segment Initialization
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOB);
    GPIO_PORTB_DIR_R = 0XFF;
    GPIO_PORTB_DEN_R = 0XFF;
    GPIO_PORTA_DIR_R |= 0XF0;
    GPIO_PORTA_DEN_R |= 0XF0;
    /////////////////////////////////////////////////




}

void ADC1_Initialization(){
    SYSCTL_RCGCADC_R |= 2;// Enable Clock to ADC1
    //SYSCTL_RCGC2_R|= 0x08;// Enable Clock to PORTD for taking Analog Input
    GPIO_PORTE_AFSEL_R |= 0x02; // Enable Alternate Functionality for PE1 Pin to take Analog Input
    GPIO_PORTE_DEN_R &= ~(1<<1); // Disable Digital Functionality on PE1
    GPIO_PORTE_AMSEL_R |= (1<<1); // Enable Analog Function on PE1 Pin
    ADC1_ACTSS_R &= ~8; // Disabling Sample Sequencer SS3 before configuration
    ADC1_EMUX_R &= ~0xF000; // Setting Trigger option to software
    ADC1_SSMUX3_R = 2; // Selecting SS3 SAMPLE SEQUENCER FOR AN0 INPUT
    ADC1_SSCTL3_R |= 6 ;
    ADC1_PP_R = 0x3; // Setting Sampling Rate to 1MSPS
    ADC1_ACTSS_R |= 8; // Enabling Sample Sequencer SS3 after configuration
   ADC1_PSSI_R |= 0x08000008; // Enabling Conversion for SS3 Sample Sequencer and Enable Sync Wait Bit

}


void displayNumber(int num){
    int ones = num%10;
        num=num/10;
    int tens = num%10;
        num=num/10;
    int hundred=num%10;
        num=num/10;
    int thousand = num%10;

    GPIO_PORTA_DATA_R = 0X10;
    GPIO_PORTB_DATA_R = intToHex(ones);
    delay(1);

    GPIO_PORTA_DATA_R = 0X20;
    GPIO_PORTB_DATA_R = intToHex(tens);
    delay(1);

    GPIO_PORTA_DATA_R = 0X40;
    GPIO_PORTB_DATA_R = intToHex(hundred);
    delay(1);

    GPIO_PORTA_DATA_R = 0X80;
    GPIO_PORTB_DATA_R = intToHex(thousand);
    delay(1);






    }



unsigned int intToHex(int num){
unsigned int data;
switch(num){
case 0: data = 0x3F;
break;
case 1: data = 0x06;
break;
case 2: data = 0x5B;
break;
case 3: data = 0x4F;
break;
case 4: data = 0x66;
break;
case 5: data = 0x6D;
break;
case 6: data = 0x7D;
break;
case 7: data = 0x07;
break;
case 8: data = 0x7F;
break;
case 9: data = 0x6F;
break;
default: data = 0x3F;
}
return data;
}


void LCD_Initialization(){
   delay(200);
    GPIO_PORTB_DATA_R = 0x30;
    GPIO_PORTA_DATA_R = 0x80;
    delay(1);
    GPIO_PORTA_DATA_R = 0x00;
    delay(10);
    GPIO_PORTB_DATA_R = 0x30;
    GPIO_PORTA_DATA_R = 0x80;
    delay(1);
    GPIO_PORTA_DATA_R = 0x00;

    delay(1);
    GPIO_PORTB_DATA_R = 0x30;
    GPIO_PORTA_DATA_R = 0x80;
    delay(1);
    GPIO_PORTA_DATA_R = 0x00;
    delay(1);

    GPIO_PORTB_DATA_R = 0x38;
    GPIO_PORTA_DATA_R = 0x80;
    delay(1);
    GPIO_PORTA_DATA_R = 0x00;
    delay(1);

    GPIO_PORTB_DATA_R = 0x01;
    GPIO_PORTA_DATA_R = 0x80;
    delay(1);
    GPIO_PORTA_DATA_R = 0x00;
    delay(5);

    GPIO_PORTB_DATA_R = 0x06;
    GPIO_PORTA_DATA_R = 0x80;
    delay(1);
    GPIO_PORTA_DATA_R = 0x00;
    delay(1);
    GPIO_PORTB_DATA_R = 0x0C;
    GPIO_PORTA_DATA_R = 0x80;
    delay(1);
    GPIO_PORTA_DATA_R = 0x00;




}

void writeStringLCD_concatenate(char* str){
    for (int i=0; i<strlen(str); i++){
        GPIO_PORTB_DATA_R = str[i];
        DataEnablePulse();
    }
}
void DataEnablePulse(){
   GPIO_PORTA_DATA_R = 0xC0;
   delay(1);
   GPIO_PORTA_DATA_R = 0x40;
   delay(1);
}

void writeStringLCD(char s[], int line)
{

if (line == 1)
{
GPIO_PORTB_DATA_R = 0x80;
GPIO_PORTA_DATA_R = 0x80;
delay(3);
GPIO_PORTA_DATA_R = 0x00;
delay(3);
}
else
{

GPIO_PORTB_DATA_R = 0xC0;
GPIO_PORTA_DATA_R = 0x80;
delay(3);
GPIO_PORTA_DATA_R = 0x00;
delay(3);

}
int i = 0;
while (s[i] != '\0')
{
GPIO_PORTB_DATA_R = s[i];
GPIO_PORTA_DATA_R = 0xC0;
delay(3);
GPIO_PORTA_DATA_R = 0x40;
delay(3);
i++;
}
}

void ClearLCD(){
GPIO_PORTB_DATA_R = 0x01;
InstrEnablePulse();
}

void InstrEnablePulse(){
GPIO_PORTA_DATA_R = 0x80;
delay(5);
GPIO_PORTA_DATA_R = 0x00;
delay(5);
}

void uart_initialization(){
    SysCtlPeripheralEnable(SYSCTL_PERIPH_UART0);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA); // UART SETUP
    GPIOPinConfigure(GPIO_PA0_U0RX);
    GPIOPinConfigure(GPIO_PA1_U0TX);
    GPIOPinTypeUART(GPIO_PORTA_BASE, GPIO_PIN_0 | GPIO_PIN_1);
    UARTConfigSetExpClk(UART0_BASE, SysCtlClockGet(), 115200,(UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE));

}



