clear all;

%% Import data from text file
% Script for importing data from the following text file:
%
%    filename: C:\Users\Sanjeet\Desktop\New folder\Vabc.txt
%
% Auto-generated by MATLAB on 30-Apr-2022 21:31:20

%% Set up the Import Options and import the data
opts = delimitedTextImportOptions("NumVariables", 1);

% Specify range and delimiter
opts.DataLines = [2, Inf];
opts.Delimiter = ",";

% Specify column names and types
opts.VariableNames = "e8805dc5";
opts.VariableTypes = "double";

% Specify file level properties
opts.ExtraColumnsRule = "ignore";
opts.EmptyLineRule = "read";

% Import the data
Vabc = readtable("Final_demo_data.txt", opts);

%% Convert to output type
Vabc = table2array(Vabc);

%% Clear temporary variables
clear opts


for i=1:500
Va(i)=Vabc(i);
Vb(i)=Vabc(i+500);
Vc(i)=Vabc(i+1000);
Ia(i)=Vabc(i+1500);
Ib(i)=Vabc(i+2000);
Ic(i)=Vabc(i+2500);
V_d(i)=Vabc(i+3000);
V_q(i)=Vabc(i+3500);
I_d(i)=Vabc(i+4000);
I_q(i)=Vabc(i+4500);
THETA(i)=Vabc(i+5000);
Vdc(i)=Vabc(i+5500);
time(i)=i*0.0004;
end
figure(1)
plot(time,Va,'r','linewidth',1); hold on; grid on;plot(time,Vb,'c','linewidth',1);plot(time,Vc,'b','linewidth',1);legend('Va','Vb','Vc','fontsize',10);xlabel('Time','fontsize',10);ylabel('Voltages(V)','fontsize',10);title('Voltages (abc)','fontsize',12);
% figure(2)
% plot(time,Ia,'r'); hold on; grid on;plot(time,Ib,'y');plot(time,Ic,'b');
figure(3)
plot(time,V_d,'r','linewidth',1); hold on; grid on;plot(time,V_q,'c','linewidth',1);legend('Vd','Vq','fontsize',10);xlabel('Time','fontsize',10);ylabel('Voltages(V)','fontsize',10);title('Voltages (d-q frame)','fontsize',12);
% figure(4)
% % plot(I_d,'r'); hold on; grid on;plot(I_q,'y');
figure(5)
plot(time,THETA,'r','linewidth',1); hold on; grid on;legend('Theta','fontsize',10);xlabel('Time','fontsize',10);ylabel('Angle(rad)','fontsize',10);title('Theta (rad)','fontsize',12);
figure(6)
plot(time,57*cos(THETA),'b'); hold on; grid on;plot(time,Va,'r');legend('Pll output','Va','fontsize',10);xlabel('Time','fontsize',10);ylabel('Voltages(V)','fontsize',10);title('PLL Output','fontsize',12);
figure(7)
plot(time,Vdc,'b');grid on; ylim([0,150]);legend('Vdc','fontsize',10);xlabel('Time','fontsize',10);ylabel('Voltage(V)','fontsize',10);title('DC link Voltages','fontsize',12);
